/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.osgi.impl;

import java.io.Closeable;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.osgi.impl.HttpClientBuilderConfigurator;
import org.apache.http.osgi.impl.OSGiCachingHttpClientBuilderFactory;
import org.apache.http.osgi.impl.OSGiHttpClientBuilderFactory;
import org.apache.http.osgi.impl.OSGiProxyConfiguration;
import org.apache.http.osgi.impl.WeakList;
import org.apache.http.osgi.services.CachingHttpClientBuilderFactory;
import org.apache.http.osgi.services.HttpClientBuilderFactory;
import org.apache.http.osgi.services.ProxyConfiguration;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;

public final class HttpProxyConfigurationActivator
implements BundleActivator,
ManagedServiceFactory {
    private static final String PROXY_SERVICE_FACTORY_NAME = "Apache HTTP Client Proxy Configuration Factory";
    private static final String PROXY_SERVICE_PID = "org.apache.http.proxyconfigurator";
    private static final String BUILDER_FACTORY_SERVICE_NAME = "Apache HTTP Client Client Factory";
    private static final String BUILDER_FACTORY_SERVICE_PID = "org.apache.http.httpclientfactory";
    private static final String CACHEABLE_BUILDER_FACTORY_SERVICE_NAME = "Apache HTTP Client Caching Client Factory";
    private static final String CACHEABLE_BUILDER_FACTORY_SERVICE_PID = "org.apache.http.cachinghttpclientfactory";
    private ServiceRegistration configurator;
    private ServiceRegistration clientFactory;
    private ServiceRegistration cachingClientFactory;
    private BundleContext context;
    private final Map<String, ServiceRegistration> registeredConfigurations = new LinkedHashMap<String, ServiceRegistration>();
    private final List<ProxyConfiguration> proxyConfigurations = new CopyOnWriteArrayList<ProxyConfiguration>();
    private final HttpClientTracker httpClientTracker = new HttpClientTracker();

    public void start(BundleContext context) throws Exception {
        this.context = context;
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("service.pid", this.getName());
        props.put("service.vendor", (String)context.getBundle().getHeaders().get("Bundle-Vendor"));
        props.put("service.description", PROXY_SERVICE_FACTORY_NAME);
        this.configurator = context.registerService(ManagedServiceFactory.class.getName(), (Object)this, props);
        HttpClientBuilderConfigurator configurator = new HttpClientBuilderConfigurator(this.proxyConfigurations);
        props.clear();
        props.put("service.pid", BUILDER_FACTORY_SERVICE_PID);
        props.put("service.vendor", (String)context.getBundle().getHeaders().get("Bundle-Vendor"));
        props.put("service.description", BUILDER_FACTORY_SERVICE_NAME);
        this.clientFactory = context.registerService(HttpClientBuilderFactory.class.getName(), (Object)new OSGiHttpClientBuilderFactory(configurator, this.httpClientTracker), props);
        props.clear();
        props.put("service.pid", CACHEABLE_BUILDER_FACTORY_SERVICE_PID);
        props.put("service.vendor", (String)context.getBundle().getHeaders().get("Bundle-Vendor"));
        props.put("service.description", CACHEABLE_BUILDER_FACTORY_SERVICE_NAME);
        this.cachingClientFactory = context.registerService(CachingHttpClientBuilderFactory.class.getName(), (Object)new OSGiCachingHttpClientBuilderFactory(configurator, this.httpClientTracker), props);
    }

    public void stop(BundleContext context) throws Exception {
        for (ServiceRegistration registeredConfiguration : this.registeredConfigurations.values()) {
            registeredConfiguration.unregister();
        }
        this.registeredConfigurations.clear();
        if (this.configurator != null) {
            this.configurator.unregister();
        }
        if (this.clientFactory != null) {
            this.clientFactory.unregister();
        }
        if (this.cachingClientFactory != null) {
            this.cachingClientFactory.unregister();
        }
        this.httpClientTracker.closeAll();
    }

    public String getName() {
        return PROXY_SERVICE_PID;
    }

    public void updated(String pid, Dictionary config) throws ConfigurationException {
        OSGiProxyConfiguration proxyConfiguration;
        ServiceRegistration registration = this.registeredConfigurations.get(pid);
        if (registration == null) {
            proxyConfiguration = new OSGiProxyConfiguration();
            ServiceRegistration configurationRegistration = this.context.registerService(ProxyConfiguration.class.getName(), (Object)proxyConfiguration, config);
            this.registeredConfigurations.put(pid, configurationRegistration);
            this.proxyConfigurations.add(proxyConfiguration);
        } else {
            proxyConfiguration = (OSGiProxyConfiguration)this.context.getService(registration.getReference());
        }
        Dictionary properties = config;
        proxyConfiguration.update(properties);
    }

    public void deleted(String pid) {
        ServiceRegistration registration = this.registeredConfigurations.remove(pid);
        if (registration != null) {
            ServiceReference ref = registration.getReference();
            ProxyConfiguration config = (ProxyConfiguration)this.context.getService(ref);
            this.proxyConfigurations.remove(config);
            this.context.ungetService(ref);
            registration.unregister();
        }
    }

    private static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static class HttpClientTracker {
        private final List<CloseableHttpClient> trackedHttpClients = new WeakList<CloseableHttpClient>();

        HttpClientTracker() {
        }

        synchronized void track(CloseableHttpClient client) {
            this.trackedHttpClients.add(client);
        }

        synchronized void closeAll() {
            for (CloseableHttpClient client : this.trackedHttpClients) {
                HttpProxyConfigurationActivator.closeQuietly(client);
            }
            this.trackedHttpClients.clear();
        }
    }
}

