/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cheatsheets.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cheatsheets.CheatSheetsPlugin;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.cheatsheets.ICheatSheetAction;
import org.eclipse.ui.cheatsheets.ICheatSheetManager;

public class BuildAllProjectsAction
extends Action
implements ICheatSheetAction {
    public void run(String[] params, ICheatSheetManager manager) {
        this.run();
    }

    public void run() {
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                BuildAllProjectsAction.this.buildAllProjects(monitor);
            }
        };
        try {
            this.runWithProgress((IRunnableWithProgress)operation);
            this.notifyResult(true);
            return;
        }
        catch (Exception e) {
            CheatSheetsPlugin.INSTANCE.log(e);
            this.notifyResult(false);
            return;
        }
    }

    protected void runWithProgress(IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        new ProgressMonitorDialog(Display.getCurrent().getActiveShell()).run(false, false, runnable);
    }

    protected void buildAllProjects(IProgressMonitor monitor) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IProject[] projects = root.getProjects();
        monitor.beginTask(CheatSheetsPlugin.INSTANCE.getString("_UI_BuildProject_message"), projects.length);
        int i = 0;
        while (i < projects.length) {
            projects[i].build(10, (IProgressMonitor)BasicMonitor.subProgress((IProgressMonitor)monitor, (int)1));
            ++i;
        }
        monitor.done();
    }
}

