/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.merge.java.facade.ast;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.codegen.merge.java.facade.AbstractJNode;
import org.eclipse.emf.codegen.merge.java.facade.FacadeHelper;
import org.eclipse.emf.codegen.merge.java.facade.JNode;
import org.eclipse.emf.codegen.merge.java.facade.ast.ASTFacadeHelper;
import org.eclipse.emf.codegen.merge.java.facade.ast.ASTJCompilationUnit;
import org.eclipse.emf.codegen.merge.java.facade.ast.CommentAwareSourceRangeComputer;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.core.dom.rewrite.TargetSourceRangeComputer;

public abstract class ASTJNode<T extends ASTNode>
extends AbstractJNode {
    protected static final String UNITIALIZED_STRING = "UNITIALIZED_STRING";
    protected String name = "UNITIALIZED_STRING";
    protected boolean isCommentedOut = false;
    private ASTFacadeHelper facadeHelper;
    private T astNode = null;
    private ASTNode wrappedObject;
    private boolean isParentSet = false;
    private ASTJNode<?> parent = null;
    private ASTNode removedASTNode = null;
    protected ASTRewrite rewriter = null;
    private Map<ASTNode, String> trackedContentsMap = new HashMap<ASTNode, String>(4);

    protected ASTJNode(T astNode) {
        this.astNode = astNode;
        this.wrappedObject = astNode;
    }

    @Override
    public void dispose() {
        this.rewriter = null;
        this.trackedContentsMap.clear();
        this.wrappedObject = null;
        this.removedASTNode = null;
        this.astNode = null;
        this.facadeHelper = null;
        this.name = null;
    }

    @Override
    public boolean isDisposed() {
        return this.rewriter == null;
    }

    @Override
    public ASTFacadeHelper getFacadeHelper() {
        return this.facadeHelper;
    }

    @Override
    public void setFacadeHelper(FacadeHelper facadeHelper) {
        this.facadeHelper = (ASTFacadeHelper)facadeHelper;
    }

    protected T getASTNode() {
        return this.astNode;
    }

    protected void setASTNode(T astNode) {
        this.astNode = astNode;
    }

    protected ASTNode getWrappedObject() {
        return this.wrappedObject;
    }

    protected void setWrappedObject(ASTNode node) {
        this.wrappedObject = node;
    }

    @Override
    public ASTJNode<?> getParent() {
        if (this.parent == null && !this.isParentSet) {
            this.setParent(this.facadeHelper.findParent(this.getWrappedObject()));
        }
        return this.parent;
    }

    public void setParent(ASTJNode<?> parent) {
        this.isParentSet = true;
        this.parent = parent;
    }

    public ASTRewrite getRewriter() {
        return this.rewriter;
    }

    public void setRewriter(ASTRewrite rewriter) {
        this.rewriter = rewriter;
    }

    public boolean addChild(ASTJNode<?> child) {
        return false;
    }

    protected void addValueToListProperty(ASTNode node, ASTNode value, ChildListPropertyDescriptor property) {
        if (value == null) {
            return;
        }
        ListRewrite listRewrite = this.rewriter.getListRewrite(node, property);
        listRewrite.insertLast(value, null);
    }

    protected void addValueToListProperty(ASTNode node, String value, ChildListPropertyDescriptor property, int nodeType) {
        if (value == null) {
            return;
        }
        ListRewrite listRewrite = this.rewriter.getListRewrite(node, property);
        listRewrite.insertLast(this.rewriter.createStringPlaceholder(value, nodeType), null);
    }

    protected void ancestorInserted() {
        this.enableTrackAndReplace();
        for (JNode node : this.getChildren()) {
            ((ASTJNode)node).ancestorInserted();
        }
    }

    protected void ancestorToBeRemoved() {
        this.disableTrackAndReplace();
        for (JNode node : this.getChildren()) {
            ((ASTJNode)node).ancestorToBeRemoved();
        }
    }

    protected void childToBeChanged(ASTJNode<?> child) {
    }

    protected String[] convertASTNodeListToStringArray(List<? extends ASTNode> nodes) {
        if (nodes == null) {
            return EMPTY_STRING_ARRAY;
        }
        String[] strings = new String[nodes.size()];
        int i = 0;
        for (ASTNode aSTNode : nodes) {
            strings[i++] = this.facadeHelper.toString(aSTNode);
        }
        return strings;
    }

    protected void disableTrackAndReplace() {
        ASTJCompilationUnit compilationUnit = (ASTJCompilationUnit)this.facadeHelper.getCompilationUnit(this);
        if (compilationUnit != null) {
            for (ASTNode node : this.trackedContentsMap.keySet()) {
                compilationUnit.getAllTrackedContentsMap().remove(node);
            }
            if (this.isCommentedOut) {
                compilationUnit.getCommentedOutNodes().remove(this.getASTNode());
            }
        }
    }

    protected void enableTrackAndReplace() {
        ASTJCompilationUnit compilationUnit = (ASTJCompilationUnit)this.facadeHelper.getCompilationUnit(this);
        if (compilationUnit != null) {
            compilationUnit.getAllTrackedContentsMap().putAll(this.trackedContentsMap);
            if (this.isCommentedOut) {
                compilationUnit.getCommentedOutNodes().add((ASTNode)this.getASTNode());
            }
        }
    }

    private void finishInsert(ASTJNode<?> newNode) {
        ASTNode removedASTNode = newNode.getRemovedASTNode();
        if (removedASTNode != null) {
            this.nodeToBeMoved(removedASTNode);
        }
        newNode.setParent(this);
        newNode.ancestorInserted();
    }

    @Override
    public String getContents() {
        return this.facadeHelper.toString((ASTNode)this.getASTNode());
    }

    protected ASTNode getRemovedASTNode() {
        return this.removedASTNode;
    }

    protected void insert(ASTJNode<?> newNode, ChildListPropertyDescriptor property, ASTJNode<?> targetNode, boolean before) {
        ListRewrite listRewrite = this.rewriter.getListRewrite(this.getASTNode(), property);
        if (before) {
            listRewrite.insertBefore(newNode.getWrappedObject(), targetNode.getWrappedObject(), null);
        } else {
            listRewrite.insertAfter(newNode.getWrappedObject(), targetNode.getWrappedObject(), null);
        }
        this.finishInsert(newNode);
    }

    protected void insertFirst(ASTJNode<?> newNode, ChildListPropertyDescriptor property) {
        ListRewrite listRewrite = this.rewriter.getListRewrite(this.getASTNode(), property);
        listRewrite.insertFirst(newNode.getWrappedObject(), null);
        this.finishInsert(newNode);
    }

    protected void insertLast(ASTJNode<?> newNode, ChildListPropertyDescriptor property) {
        ListRewrite listRewrite = this.rewriter.getListRewrite(this.getASTNode(), property);
        listRewrite.insertLast(newNode.getWrappedObject(), null);
        this.finishInsert(newNode);
    }

    public boolean insertSibling(ASTJNode<?> node, ASTJNode<?> newSibling, boolean before) {
        return false;
    }

    protected void nodeToBeMoved(ASTNode node) {
        TargetSourceRangeComputer sourceRangeComputer = this.rewriter.getExtendedSourceRangeComputer();
        if (sourceRangeComputer instanceof CommentAwareSourceRangeComputer) {
            ((CommentAwareSourceRangeComputer)sourceRangeComputer).unmarkNodeForRemoval(node);
        }
    }

    protected void nodeToBeRemoved(ASTNode node) {
        TargetSourceRangeComputer sourceRangeComputer = this.rewriter.getExtendedSourceRangeComputer();
        if (sourceRangeComputer instanceof CommentAwareSourceRangeComputer) {
            ((CommentAwareSourceRangeComputer)sourceRangeComputer).markNodeForRemoval(node);
        }
    }

    public boolean remove(ASTJNode<?> node) {
        return false;
    }

    protected void remove(ASTJNode<?> node, ChildListPropertyDescriptor property) {
        node.ancestorToBeRemoved();
        ASTNode astNodeToBeRemoved = node.getWrappedObject();
        if (astNodeToBeRemoved.getParent() != null && astNodeToBeRemoved.getLocationInParent() != null) {
            this.nodeToBeRemoved(astNodeToBeRemoved);
            node.setRemovedASTNode(astNodeToBeRemoved);
            ASTNode moveTargetASTNode = this.rewriter.createMoveTarget(astNodeToBeRemoved);
            node.setWrappedObject(moveTargetASTNode);
            this.getFacadeHelper().updateObjectToNodeMap(node);
        }
        this.removeNodeFromListProperty((ASTNode)this.getASTNode(), astNodeToBeRemoved, property);
        node.setParent(null);
    }

    protected void removeNodeFromListProperty(ASTNode parentNode, ASTNode nodeToRemove, ChildListPropertyDescriptor property) {
        ListRewrite listRewrite = this.getRewriter().getListRewrite(parentNode, property);
        listRewrite.remove(nodeToRemove, null);
    }

    protected void removeTrackAndReplace(ASTNode node) {
        this.trackedContentsMap.remove(node);
        ASTJCompilationUnit compilationUnit = (ASTJCompilationUnit)this.facadeHelper.getCompilationUnit(this);
        if (compilationUnit != null) {
            compilationUnit.getAllTrackedContentsMap().remove(node);
        }
    }

    @Override
    public void setFlags(int flags) {
    }

    protected void setListNodeProperty(ASTNode node, String[] values, ChildListPropertyDescriptor property, int nodeType) {
        ListRewrite listRewrite = this.rewriter.getListRewrite(node, property);
        List oldValues = listRewrite.getRewrittenList();
        for (ASTNode oldValue : oldValues) {
            listRewrite.remove(oldValue, null);
        }
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            listRewrite.insertLast(this.rewriter.createStringPlaceholder(value, nodeType), null);
            ++n2;
        }
    }

    protected void setNodeProperty(ASTNode node, Object value, StructuralPropertyDescriptor property) {
        this.rewriter.set(node, property, value, null);
    }

    protected void setNodeProperty(ASTNode node, String stringValue, StructuralPropertyDescriptor property, int nodeType) {
        ASTNode value = null;
        if (stringValue != null) {
            value = this.rewriter.createStringPlaceholder(stringValue, nodeType);
        }
        this.rewriter.set(node, property, (Object)value, null);
    }

    protected String[] combineArrayAndList(String[] strings, List<String> stringsList) {
        if (stringsList != null && stringsList.size() > 0) {
            if (strings.length > 0) {
                String[] newStringArray = new String[strings.length + stringsList.size()];
                int i = 0;
                while (i < strings.length) {
                    newStringArray[i] = strings[i];
                    ++i;
                }
                i = 0;
                while (i < stringsList.size()) {
                    newStringArray[strings.length + i] = stringsList.get(i);
                    ++i;
                }
                strings = newStringArray;
            } else {
                strings = stringsList.toArray(EMPTY_STRING_ARRAY);
            }
            stringsList.clear();
        }
        return strings;
    }

    protected void setRemovedASTNode(ASTNode removedASTNode) {
        this.removedASTNode = removedASTNode;
    }

    protected void setTrackedNodeProperty(ASTNode node, String stringValue, StructuralPropertyDescriptor property, int nodeType) {
        ASTNode nodeValue = (ASTNode)this.rewriter.get(node, property);
        if (stringValue == null || "".equals(stringValue)) {
            this.removeTrackAndReplace(nodeValue);
            this.rewriter.set(node, property, null, null);
        } else if (nodeValue != null) {
            this.trackAndReplace(nodeValue, stringValue);
        } else {
            nodeValue = this.rewriter.createStringPlaceholder(stringValue, nodeType);
            this.rewriter.set(node, property, (Object)nodeValue, null);
            this.trackAndReplace(nodeValue, stringValue);
        }
    }

    protected void trackAndReplace(ASTNode node, String contents) {
        this.trackedContentsMap.put(node, contents);
        ASTJCompilationUnit compilationUnit = (ASTJCompilationUnit)this.facadeHelper.getCompilationUnit(this);
        if (compilationUnit != null) {
            compilationUnit.getAllTrackedContentsMap().put(node, contents);
        }
    }

    public void commentOut() {
        this.isCommentedOut = true;
        ASTJCompilationUnit compilationUnit = (ASTJCompilationUnit)this.facadeHelper.getCompilationUnit(this);
        if (compilationUnit != null) {
            compilationUnit.getCommentedOutNodes().add((ASTNode)this.getASTNode());
        }
    }
}

