/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.core;

import java.util.Hashtable;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.eclipse.osgi.service.debug.DebugTrace;
import org.eclipse.osgi.util.NLS;
import org.eclipse.remote.internal.core.RemoteCorePlugin;
import org.osgi.framework.BundleContext;

public class RemoteDebugOptions
implements DebugOptionsListener {
    public static final String DEBUG_REMOTE_COMMANDS = "/debug/commands";
    private static DebugTrace fDebugTrace;
    private static DebugOptions fDebugOptions;
    private static RemoteDebugOptions fRemoteDebugOptions;

    public static void configure(BundleContext context) {
        if (fRemoteDebugOptions == null) {
            fRemoteDebugOptions = new RemoteDebugOptions(context);
        }
    }

    private RemoteDebugOptions(BundleContext context) {
        Hashtable<String, String> props = new Hashtable<String, String>(2);
        props.put("listener.symbolic.name", RemoteCorePlugin.getUniqueIdentifier());
        context.registerService(DebugOptionsListener.class.getName(), (Object)this, props);
    }

    public void optionsChanged(DebugOptions options) {
        fDebugOptions = options;
        fDebugTrace = options.newDebugTrace(RemoteCorePlugin.getUniqueIdentifier());
    }

    public static boolean isDebugging() {
        return RemoteCorePlugin.getDefault().isDebugging();
    }

    public static boolean isDebugging(String option) {
        if (fDebugOptions == null) {
            return false;
        }
        return fDebugOptions.getBooleanOption(RemoteCorePlugin.getUniqueIdentifier() + option, false);
    }

    public static void setDebugging(String option, boolean value) {
        if (fDebugOptions != null) {
            if (value) {
                fDebugOptions.setDebugEnabled(true);
            }
            fDebugOptions.setOption(option, Boolean.toString(value));
        }
    }

    public static void trace(String message) {
        RemoteDebugOptions.trace(null, message, new String[0]);
    }

    public static void trace(String option, String message, String ... arguments) {
        String traceMsg = message;
        if (arguments.length > 0) {
            traceMsg = NLS.bind((String)message, (Object[])arguments);
        }
        if (option != null && RemoteDebugOptions.isDebugging(option) || RemoteDebugOptions.isDebugging()) {
            System.out.println(traceMsg);
            if (fDebugTrace != null) {
                fDebugTrace.trace(option, traceMsg, null);
            }
        }
    }
}

