/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.type.core.internal.descriptors;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.emf.type.core.IContainerDescriptor;
import org.eclipse.gmf.runtime.emf.type.core.IElementMatcher;
import org.eclipse.gmf.runtime.emf.type.core.internal.EMFTypePlugin;
import org.eclipse.gmf.runtime.emf.type.core.internal.EMFTypePluginStatusCodes;
import org.eclipse.gmf.runtime.emf.type.core.internal.descriptors.MetamodelDescriptor;
import org.eclipse.gmf.runtime.emf.type.core.internal.impl.XMLExpressionMatcher;
import org.eclipse.gmf.runtime.emf.type.core.internal.l10n.EMFTypeCoreMessages;

class ContainerDescriptor
implements IContainerDescriptor {
    private String matcherClassName;
    private IElementMatcher matcher;
    private IConfigurationElement matcherConfig;
    private EReference[] containmentFeatures;
    private List featureNames = new ArrayList();
    private final MetamodelDescriptor metamodelDescriptor;

    public ContainerDescriptor(IConfigurationElement config, MetamodelDescriptor metamodelDescriptor, String id) throws CoreException {
        IConfigurationElement[] matcherConfigs;
        this.metamodelDescriptor = metamodelDescriptor;
        IConfigurationElement[] featureConfigs = config.getChildren("eContainmentFeature");
        if (featureConfigs.length > 0 && metamodelDescriptor == null) {
            throw EMFTypePluginStatusCodes.getInitException(id, EMFTypeCoreMessages.bind((String)EMFTypeCoreMessages.element_reason_no_econtainmentfeature_metamodel_WARN_, (Object)featureConfigs[0]), null);
        }
        int i = 0;
        while (i < featureConfigs.length) {
            IConfigurationElement nextFeatureConfig = featureConfigs[i];
            String qname = nextFeatureConfig.getAttribute("qname");
            if (qname == null) {
                throw EMFTypePluginStatusCodes.getInitException(id, EMFTypeCoreMessages.element_reason_no_econtainmentfeature_qname_WARN_, null);
            }
            this.featureNames.add(qname);
            ++i;
        }
        IConfigurationElement[] enablementConfigs = config.getChildren("enablement");
        if (enablementConfigs.length > 0) {
            this.matcher = new XMLExpressionMatcher(enablementConfigs[0], id);
        }
        if (this.matcher == null && (matcherConfigs = config.getChildren("matcher")).length > 0) {
            this.matcherClassName = matcherConfigs[0].getAttribute("class");
            if (this.matcherClassName == null) {
                throw EMFTypePluginStatusCodes.getInitException(id, EMFTypeCoreMessages.element_reason_matcher_no_class_WARN_, null);
            }
            this.matcherConfig = matcherConfigs[0];
        }
    }

    @Override
    public IElementMatcher getMatcher() {
        if (this.matcher == null && this.matcherClassName != null && this.matcherConfig != null) {
            try {
                this.matcher = (IElementMatcher)this.matcherConfig.createExecutableExtension("class");
            }
            catch (CoreException e) {
                Log.error((Plugin)EMFTypePlugin.getPlugin(), (int)21, (String)EMFTypeCoreMessages.bind((String)EMFTypeCoreMessages.matcher_class_not_found_ERROR_, (Object)this.matcherClassName), (Throwable)e);
                this.matcherClassName = null;
            }
        }
        return this.matcher;
    }

    @Override
    public EReference[] getContainmentFeatures() {
        if (this.containmentFeatures == null && !this.featureNames.isEmpty()) {
            ArrayList<EStructuralFeature> references = new ArrayList<EStructuralFeature>();
            if (this.metamodelDescriptor != null) {
                for (String nextFeatureName : this.featureNames) {
                    EPackage ePackage = this.metamodelDescriptor.getEPackage();
                    int featureIndex = nextFeatureName.lastIndexOf(".");
                    String classifierName = nextFeatureName.substring(0, featureIndex);
                    EClassifier classifier = ePackage.getEClassifier(classifierName);
                    if (featureIndex < nextFeatureName.length() - 1 && classifier instanceof EClass) {
                        String featureName = nextFeatureName.substring(featureIndex + 1);
                        EStructuralFeature feature = ((EClass)classifier).getEStructuralFeature(featureName);
                        if (feature instanceof EReference) {
                            references.add(feature);
                            continue;
                        }
                        Log.error((Plugin)EMFTypePlugin.getPlugin(), (int)25, (String)EMFTypeCoreMessages.bind((String)EMFTypeCoreMessages.eContainmentFeature_not_reference_feature_ERROR_, (Object)nextFeatureName), null);
                        continue;
                    }
                    Log.error((Plugin)EMFTypePlugin.getPlugin(), (int)26, (String)EMFTypeCoreMessages.bind((String)EMFTypeCoreMessages.eContainmentFeature_no_such_feature_ERROR_, (Object)nextFeatureName), null);
                }
            }
            this.containmentFeatures = references.toArray(new EReference[0]);
        }
        return this.containmentFeatures;
    }
}

