/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.core.ibundle.IManifestHeader;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.eclipse.pde.internal.core.util.UtilMessages;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;
import org.osgi.resource.Resource;

public class ManifestUtils {
    public static final String MANIFEST_VERSION = "Manifest-Version";
    public static final String MANIFEST_LIST_SEPARATOR = ",\n ";
    public static final String MANIFEST_LINE_SEPARATOR = "\n ";
    private static int MANIFEST_MAXLINE = 511;
    public static final int STATUS_CODE_NOT_A_BUNDLE_MANIFEST = 204;
    private static final Map<String, String> SIMPLE_EE_FILTERS = new HashMap<String, String>();
    private static final Map<String, Map<String, String>> AVAILABLE_EE_ATTRIBUTES = new HashMap<String, Map<String, String>>();
    private static final Pattern WHITESPACE;

    static {
        AVAILABLE_EE_ATTRIBUTES.put("CDC-1.0/Foundation-1.0", Map.of("osgi.ee", "CDC/Foundation", "version", "1.0"));
        AVAILABLE_EE_ATTRIBUTES.put("CDC-1.1/Foundation-1.1", Map.of("osgi.ee", "CDC/Foundation", "version", "1.1"));
        for (String eeId : TargetPlatformHelper.getKnownExecutionEnvironments()) {
            String eeVersion;
            String eeName;
            Map<String, String> predefinedAttributes = AVAILABLE_EE_ATTRIBUTES.get(eeId);
            if (predefinedAttributes == null) {
                if (eeId.indexOf(47) >= eeId.indexOf(45)) {
                    ILog.get().error("Cannot reliably parse filter attributes from BREE with id: " + eeId);
                    continue;
                }
                int versionSeparator = eeId.lastIndexOf(45);
                if (versionSeparator < 0) {
                    throw new IllegalArgumentException("Missing version-separator in EE Id");
                }
                eeName = eeId.substring(0, versionSeparator);
                if ("J2SE".equals(eeName)) {
                    eeName = "JavaSE";
                }
                eeVersion = eeId.substring(versionSeparator + 1);
                AVAILABLE_EE_ATTRIBUTES.put(eeId, Map.of("osgi.ee", eeName, "version", eeVersion));
            } else {
                eeName = predefinedAttributes.get("osgi.ee");
                eeVersion = predefinedAttributes.get("version");
            }
            String eeNamespace = "osgi.ee";
            String versionAttribute = "version";
            String filter1 = "(&(" + eeNamespace + "=" + eeName + ")(" + versionAttribute + "=" + eeVersion + "))";
            String filter2 = "(&(" + versionAttribute + "=" + eeVersion + ")(" + eeNamespace + "=" + eeName + "))";
            SIMPLE_EE_FILTERS.put(filter1, eeId);
            SIMPLE_EE_FILTERS.put(filter2, eeId);
        }
        WHITESPACE = Pattern.compile("\\s*");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String> loadManifest(File bundleLocation) throws CoreException {
        try {
            if (bundleLocation.isFile()) {
                InputStream stream;
                ZipFile jarFile;
                block12: {
                    Map map;
                    jarFile = null;
                    stream = null;
                    try {
                        Map map2;
                        jarFile = new ZipFile(bundleLocation, 1);
                        ZipEntry manifestEntry = jarFile.getEntry("META-INF/MANIFEST.MF");
                        if (manifestEntry == null || (stream = jarFile.getInputStream(manifestEntry)) == null || (map2 = ManifestElement.parseBundleManifest((InputStream)stream, null)) == null || !map2.containsKey("Bundle-SymbolicName")) break block12;
                        map = map2;
                    }
                    catch (Throwable throwable) {
                        ManifestUtils.closeZipFileAndStream(stream, jarFile);
                        throw throwable;
                    }
                    ManifestUtils.closeZipFileAndStream(stream, jarFile);
                    return map;
                }
                ManifestUtils.closeZipFileAndStream(stream, jarFile);
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", 204, NLS.bind((String)UtilMessages.ErrorReadingManifest, (Object)bundleLocation.getAbsolutePath()), null));
            }
            File file = new File(bundleLocation, "META-INF/MANIFEST.MF");
            if (!file.exists()) throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", 204, NLS.bind((String)UtilMessages.ErrorManifestFileAbsent, (Object)bundleLocation.getAbsolutePath()), null));
            Throwable throwable = null;
            Object var3_8 = null;
            try (FileInputStream stream = new FileInputStream(file);){
                Map map = ManifestElement.parseBundleManifest((InputStream)stream, new HashMap(10));
                if (map == null) throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", 204, NLS.bind((String)UtilMessages.ErrorReadingManifest, (Object)bundleLocation.getAbsolutePath()), null));
                if (!map.containsKey("Bundle-SymbolicName")) throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", 204, NLS.bind((String)UtilMessages.ErrorReadingManifest, (Object)bundleLocation.getAbsolutePath()), null));
                return map;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException | BundleException e) {
            throw new CoreException(Status.error((String)NLS.bind((String)UtilMessages.ErrorReadingManifest, (Object)bundleLocation.getAbsolutePath()), (Throwable)e));
        }
    }

    public static IPackageFragmentRoot[] findPackageFragmentRoots(IManifestHeader header, IProject project) {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        String[] libs = header == null || header.getValue() == null ? new String[]{"."} : header.getValue().split(",");
        IBuild build = ManifestUtils.getBuild(project);
        if (build == null) {
            try {
                return javaProject.getPackageFragmentRoots();
            }
            catch (JavaModelException e) {
                return new IPackageFragmentRoot[0];
            }
        }
        LinkedList<IPackageFragmentRoot> pkgFragRoots = new LinkedList<IPackageFragmentRoot>();
        String[] stringArray = libs;
        int n = libs.length;
        int n2 = 0;
        while (n2 < n) {
            String lib = stringArray[n2];
            IPackageFragmentRoot root = null;
            if (!lib.equals(".")) {
                try {
                    root = javaProject.getPackageFragmentRoot((IResource)project.getFile(lib));
                }
                catch (IllegalArgumentException e) {
                    return new IPackageFragmentRoot[0];
                }
            }
            if (root != null && root.exists()) {
                pkgFragRoots.add(root);
            } else {
                IBuildEntry entry = build.getEntry("source." + lib);
                if (entry != null) {
                    String[] tokens;
                    String[] stringArray2 = tokens = entry.getTokens();
                    int n3 = tokens.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String token = stringArray2[n4];
                        IResource resource = project.findMember(token);
                        if (resource != null && (root = javaProject.getPackageFragmentRoot(resource)) != null && root.exists()) {
                            pkgFragRoots.add(root);
                        }
                        ++n4;
                    }
                }
            }
            ++n2;
        }
        return pkgFragRoots.toArray(new IPackageFragmentRoot[pkgFragRoots.size()]);
    }

    public static boolean isImmediateRoot(IPackageFragmentRoot root) throws JavaModelException {
        int kind = root.getKind();
        return kind == 1 || kind == 2 && !root.isExternal();
    }

    public static void writeManifest(Map<String, String> manifestToWrite, Writer out) throws IOException {
        manifestToWrite = new Hashtable<String, String>(manifestToWrite);
        ManifestUtils.writeEntry(out, MANIFEST_VERSION, manifestToWrite.remove(MANIFEST_VERSION));
        ManifestUtils.writeEntry(out, "Bundle-ManifestVersion", manifestToWrite.remove("Bundle-ManifestVersion"));
        ManifestUtils.writeEntry(out, "Bundle-Name", manifestToWrite.remove("Bundle-Name"));
        ManifestUtils.writeEntry(out, "Bundle-SymbolicName", manifestToWrite.remove("Bundle-SymbolicName"));
        ManifestUtils.writeEntry(out, "Bundle-Version", manifestToWrite.remove("Bundle-Version"));
        ManifestUtils.writeEntry(out, "Bundle-ClassPath", manifestToWrite.remove("Bundle-ClassPath"));
        ManifestUtils.writeEntry(out, "Bundle-Activator", manifestToWrite.remove("Bundle-Activator"));
        ManifestUtils.writeEntry(out, "Bundle-Vendor", manifestToWrite.remove("Bundle-Vendor"));
        ManifestUtils.writeEntry(out, "Fragment-Host", manifestToWrite.remove("Fragment-Host"));
        ManifestUtils.writeEntry(out, "Bundle-Localization", manifestToWrite.remove("Bundle-Localization"));
        ManifestUtils.writeEntry(out, "Export-Package", manifestToWrite.remove("Export-Package"));
        ManifestUtils.writeEntry(out, "Provide-Package", manifestToWrite.remove("Provide-Package"));
        ManifestUtils.writeEntry(out, "Require-Bundle", manifestToWrite.remove("Require-Bundle"));
        for (Map.Entry<String, String> entry : manifestToWrite.entrySet()) {
            ManifestUtils.writeEntry(out, entry.getKey(), entry.getValue());
        }
        out.flush();
    }

    private static IBuild getBuild(IProject project) {
        IFile buildProps = PDEProject.getBuildProperties(project);
        if (buildProps.exists()) {
            WorkspaceBuildModel model = new WorkspaceBuildModel(buildProps);
            return model.getBuild();
        }
        return null;
    }

    private static void closeZipFileAndStream(InputStream stream, ZipFile jarFile) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException e) {
            PDECore.log(e);
        }
        try {
            if (jarFile != null) {
                jarFile.close();
            }
        }
        catch (IOException e) {
            PDECore.log(e);
        }
    }

    private static void writeEntry(Writer out, String key, String value) throws IOException {
        if (value != null && value.length() > 0) {
            out.write(ManifestUtils.splitOnComma(key + ": " + value));
            out.write(10);
        }
    }

    private static String splitOnComma(String value) {
        if (value.length() < MANIFEST_MAXLINE || value.contains(MANIFEST_LINE_SEPARATOR)) {
            return value;
        }
        String[] values = ManifestElement.getArrayFromList((String)value);
        if (values == null || values.length == 0) {
            return value;
        }
        StringBuilder sb = new StringBuilder(value.length() + (values.length - 1) * MANIFEST_LIST_SEPARATOR.length());
        int i = 0;
        while (i < values.length - 1) {
            sb.append(values[i]).append(MANIFEST_LIST_SEPARATOR);
            ++i;
        }
        sb.append(values[values.length - 1]);
        return sb.toString();
    }

    public static Stream<String> getRequiredExecutionEnvironments(Resource resource) {
        List requirements = resource.getRequirements("osgi.ee");
        return requirements.stream().map(requirement -> (String)requirement.getDirectives().get("filter")).mapMulti(ManifestUtils::parseRequiredEEsFromFilter);
    }

    public static void parseRequiredEEsFromFilter(String eeFilter, Consumer<String> collector) {
        String ee;
        if (eeFilter == null) {
            return;
        }
        if (eeFilter.chars().anyMatch(Character::isWhitespace)) {
            eeFilter = WHITESPACE.matcher(eeFilter).replaceAll("");
        }
        if ((ee = SIMPLE_EE_FILTERS.get(eeFilter)) != null) {
            collector.accept(ee);
        } else {
            try {
                Filter filter = FrameworkUtil.createFilter((String)eeFilter);
                AVAILABLE_EE_ATTRIBUTES.forEach((eeId, eeAttributes) -> {
                    if (filter.matches(eeAttributes)) {
                        collector.accept((String)eeId);
                    }
                });
            }
            catch (InvalidSyntaxException e) {
                throw new IllegalArgumentException("Invalid execution environment filter", e);
            }
        }
    }

    public static Optional<VersionRange> createConsumerRequirementRange(Version version) {
        if (version != null && !Version.emptyVersion.equals((Object)version)) {
            return Optional.ofNullable(new VersionRange('[', new Version(version.getMajor(), version.getMinor(), 0), new Version(version.getMajor() + 1, 0, 0), ')'));
        }
        return Optional.empty();
    }

    public static String getSourceReferences(Bundle bundle) {
        String srcRef = ManifestUtils.findScmGit(bundle);
        if (srcRef != null) {
            try {
                ManifestElement element = ManifestElement.parseHeader((String)"Eclipse-SourceReferences", (String)srcRef)[0];
                srcRef = element.getValue().trim().replaceFirst("^scm:git:", "");
            }
            catch (BundleException bundleException) {
                // empty catch block
            }
        }
        return srcRef;
    }

    private static String findScmGit(Bundle bundle) {
        if (bundle != null) {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (InputStream is = bundle.getEntry("META-INF/MANIFEST.MF").openStream();){
                    Attributes attributes = new Manifest(is).getMainAttributes();
                    return attributes.getValue("Eclipse-SourceReferences");
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Eclipse-SourceReferences not found for bundle : " + String.valueOf(bundle));
            }
        }
        return null;
    }
}

