/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server;

import org.eclipse.emf.cdo.server.IRepositoryProtector;
import org.eclipse.emf.cdo.spi.server.CDOCommand;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.net4j.util.security.IAuthenticator;
import org.eclipse.net4j.util.security.IUserManagement;
import org.eclipse.net4j.util.security.SecurityUtil;

public abstract class UserManagementCommand
extends CDOCommand.WithRepository {
    public UserManagementCommand(String name, String description, CDOCommand.CommandParameter ... parameters) {
        super(name, description, parameters);
    }

    public UserManagementCommand(String name, String description) {
        super(name, description);
    }

    @Override
    public void execute(InternalRepository repository, String[] args) throws Exception {
        IUserManagement userManagement = UserManagementCommand.getUserManagement(repository);
        this.execute(repository, userManagement, args);
    }

    protected abstract void execute(InternalRepository var1, IUserManagement var2, String[] var3) throws Exception;

    private static IUserManagement getUserManagement(InternalRepository repository) {
        IRepositoryProtector.UserAuthenticator userAuthenticator;
        IRepositoryProtector protector = repository.getProtector();
        if (protector != null && (userAuthenticator = protector.getUserAuthenticator()) instanceof IUserManagement) {
            return (IUserManagement)userAuthenticator;
        }
        IAuthenticator authenticator = repository.getSessionManager().getAuthenticator();
        if (authenticator instanceof IUserManagement) {
            return (IUserManagement)authenticator;
        }
        throw new CDOCommand.CommandException("User management of " + repository + " not found!");
    }

    protected final IRepositoryProtector.UserAuthenticator.PasswordChangeSupport getPasswordChangeSupport(InternalRepository repository) {
        IRepositoryProtector.UserAuthenticator userAuthenticator;
        IRepositoryProtector protector = repository.getProtector();
        if (protector != null && (userAuthenticator = protector.getUserAuthenticator()) instanceof IRepositoryProtector.UserAuthenticator.PasswordChangeSupport) {
            return (IRepositoryProtector.UserAuthenticator.PasswordChangeSupport)((Object)userAuthenticator);
        }
        IAuthenticator authenticator = repository.getSessionManager().getAuthenticator();
        if (authenticator instanceof IRepositoryProtector.UserAuthenticator.PasswordChangeSupport) {
            return (IRepositoryProtector.UserAuthenticator.PasswordChangeSupport)authenticator;
        }
        throw new CDOCommand.CommandException("Password change support not found for " + repository);
    }

    public static final class UserAdd
    extends UserManagementCommand {
        public UserAdd() {
            super("useradd", "add a user to a repository", UserAdd.parameter("username"), UserAdd.optional("password"));
        }

        @Override
        protected void execute(InternalRepository repository, IUserManagement userManagement, String[] args) throws Exception {
            String username = args[0];
            String password = args[1];
            userManagement.addUser(username, SecurityUtil.toCharArray((String)password));
            this.println("User " + username + " added");
        }
    }

    public static final class UserAdmin
    extends UserManagementCommand {
        public UserAdmin() {
            super("useradmin", "set or unset the administrator role of a repository user", UserAdmin.parameter("username"), UserAdmin.parameter("administrator"));
        }

        @Override
        protected void execute(InternalRepository repository, IUserManagement userManagement, String[] args) throws Exception {
            String username = args[0];
            boolean administrator = Boolean.parseBoolean(args[1]);
            userManagement.setAdministrator(username, administrator);
            this.println("Administrator role of user " + username + (administrator ? " set" : " unset"));
        }
    }

    public static final class UserDelete
    extends UserManagementCommand {
        public UserDelete() {
            super("userdel", "delete a user from a repository", UserDelete.parameter("username"));
        }

        @Override
        protected void execute(InternalRepository repository, IUserManagement userManagement, String[] args) throws Exception {
            String username = args[0];
            userManagement.removeUser(username);
            this.println("User " + username + " deleted");
        }
    }

    public static final class UserPassword
    extends UserManagementCommand {
        public UserPassword() {
            super("userpw", "set or unset the password of a repository user", UserPassword.parameter("username"), UserPassword.optional("password"));
        }

        @Override
        protected void execute(InternalRepository repository, IUserManagement userManagement, String[] args) throws Exception {
            String username = args[0];
            String password = args[1];
            userManagement.setPassword(username, SecurityUtil.toCharArray((String)password));
            this.println("Password of user " + username + (password != null ? " set" : " unset"));
        }
    }

    public static final class UserSetAttribute
    extends UserManagementCommand {
        public UserSetAttribute() {
            super("userattr", "set or unset an attribute of a repository user", UserSetAttribute.parameter("username"), UserSetAttribute.parameter("attribute"), UserSetAttribute.optional("value"));
        }

        @Override
        protected void execute(InternalRepository repository, IUserManagement userManagement, String[] args) throws Exception {
            String username = args[0];
            String attribute = args[1];
            String value = args[2];
            if (!(userManagement instanceof IUserManagement.Attributed)) {
                throw new CDOCommand.CommandException("User management of " + repository + " has not support for attributes!");
            }
            IUserManagement.Attributed attributed = (IUserManagement.Attributed)userManagement;
            attributed.setAttribute(username, attribute, value);
            this.println("Attribute " + attribute + " of user " + username + (value != null ? " set to " + value : " unset"));
        }
    }
}

