/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.common.revision;

import java.util.function.Predicate;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionValueVisitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public interface CDORevisionData {
    public static final Object NIL = EStructuralFeature.Internal.DynamicValueHolder.NIL;

    public CDORevision revision();

    public CDOID getResourceID();

    public Object getContainerID();

    public int getContainerFeatureID();

    default public EReference getContainingReference(EClass containerClass) {
        int containerFeatureID = this.getContainerFeatureID();
        EClass eClass = this.revision().getEClass();
        return CDORevisionData.calculateContainingReference(containerFeatureID, eClass, containerClass);
    }

    public Object getValue(EStructuralFeature var1);

    public CDOList getListOrNull(EStructuralFeature var1);

    public Object get(EStructuralFeature var1, int var2);

    public int size(EStructuralFeature var1);

    public boolean isEmpty(EStructuralFeature var1);

    public boolean contains(EStructuralFeature var1, Object var2);

    public int indexOf(EStructuralFeature var1, Object var2);

    public int lastIndexOf(EStructuralFeature var1, Object var2);

    public <T> T[] toArray(EStructuralFeature var1, T[] var2);

    public Object[] toArray(EStructuralFeature var1);

    public int hashCode(EStructuralFeature var1);

    public void accept(CDORevisionValueVisitor var1);

    public void accept(CDORevisionValueVisitor var1, Predicate<EStructuralFeature> var2);

    default public int calculateContainerReferenceID(EReference containingReference) {
        EClass eClass = this.revision().getEClass();
        return CDORevisionData.calculateContainerReferenceID(containingReference, eClass);
    }

    public static int calculateContainerReferenceID(EReference containingReference, EClass childClass) {
        EReference inverseReference = containingReference.getEOpposite();
        if (inverseReference != null) {
            Class instanceClass = containingReference.getEType().getInstanceClass();
            if (instanceClass == null) {
                return childClass.getFeatureID((EStructuralFeature)inverseReference);
            }
            return inverseReference.getFeatureID();
        }
        return -1 - containingReference.getFeatureID();
    }

    public static EReference calculateContainingReference(int containerFeatureID, EClass childClass, EClass containerClass) {
        if (containerFeatureID <= -1) {
            return (EReference)containerClass.getEStructuralFeature(-1 - containerFeatureID);
        }
        return ((EReference)childClass.getEStructuralFeature(containerFeatureID)).getEOpposite();
    }

    @Deprecated
    public void accept(CDORevisionValueVisitor var1, org.eclipse.net4j.util.Predicate<EStructuralFeature> var2);

    @Deprecated
    public int getContainingFeatureID();

    @Deprecated
    default public int calculateContainingReferenceID(EReference containingReference) {
        return this.calculateContainerReferenceID(containingReference);
    }

    @Deprecated
    public static int calculateContainingReferenceID(EReference containingReference, EClass childClass) {
        return CDORevisionData.calculateContainerReferenceID(containingReference, childClass);
    }
}

