/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.dnd;

import java.util.ArrayList;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.CDOState;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.ui.dnd.DNDDropAdapter;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;

public class CDOObjectDropAdapter
extends DNDDropAdapter<TreeSelection> {
    public static final Transfer[] TRANSFERS = new Transfer[]{LocalTransfer.getInstance()};

    protected CDOObjectDropAdapter(StructuredViewer viewer) {
        super(TRANSFERS, viewer);
        this.setExpandEnabled(false);
    }

    protected boolean performDrop(TreeSelection data, Object target) {
        if (target instanceof IContainer.Modifiable) {
            IContainer.Modifiable objectContainer = (IContainer.Modifiable)target;
            ArrayList<CDOObject> elementsToAdd = new ArrayList<CDOObject>();
            Object[] objectArray = data.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                if (CDOObjectDropAdapter.isWatchable(obj)) {
                    elementsToAdd.add(CDOUtil.getCDOObject((EObject)((EObject)obj)));
                }
                ++n2;
            }
            objectContainer.addAllElements(elementsToAdd);
            return true;
        }
        return false;
    }

    protected boolean validateTarget(Object target, int operation) {
        return true;
    }

    public static void support(StructuredViewer viewer) {
        int dndOperations = 7;
        viewer.addDropSupport(dndOperations, TRANSFERS, (DropTargetListener)new CDOObjectDropAdapter(viewer));
    }

    public static boolean isWatchable(Object obj) {
        CDOObject cdoObject;
        if (obj instanceof EObject && (cdoObject = CDOUtil.getCDOObject((EObject)((EObject)obj))) != null) {
            return cdoObject.cdoState() == CDOState.CLEAN || cdoObject.cdoState() == CDOState.DIRTY;
        }
        return false;
    }
}

