/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.commit.command;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.core.internal.Utils;
import org.eclipse.egit.core.op.CherryPickOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.internal.UIRepositoryUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.branch.LaunchFinder;
import org.eclipse.egit.ui.internal.commit.RepositoryCommit;
import org.eclipse.egit.ui.internal.dialogs.CommitSelectDialog;
import org.eclipse.egit.ui.internal.jobs.RepositoryJob;
import org.eclipse.egit.ui.internal.jobs.RepositoryJobResultAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.api.CherryPickResult;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.ResolveMerger;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class CherryPickUI {
    public void run(@NonNull Repository repository, @NonNull RevCommit commit, boolean confirm) throws CoreException {
        Shell shell = PlatformUI.getWorkbench().getModalDialogShellProvider().getShell();
        int parentIndex = -1;
        if (commit.getParentCount() > 1) {
            ArrayList<RevCommit> parents = new ArrayList<RevCommit>();
            String branch = null;
            try {
                RevCommit[] revCommitArray = commit.getParents();
                int n = revCommitArray.length;
                int n2 = 0;
                while (n2 < n) {
                    RevCommit parent = revCommitArray[n2];
                    parents.add(repository.parseCommit((AnyObjectId)parent));
                    ++n2;
                }
                branch = repository.getBranch();
            }
            catch (Exception e) {
                Activator.handleError(e.getLocalizedMessage(), e, true);
            }
            CommitSelectDialog selectCommit = new CommitSelectDialog(shell, parents, this.getLaunchMessage(repository));
            selectCommit.create();
            selectCommit.setTitle(UIText.CommitSelectDialog_ChooseParentTitle);
            selectCommit.setMessage(MessageFormat.format(UIText.CherryPickHandler_CherryPickMergeMessage, Utils.getShortObjectId((ObjectId)commit), branch));
            if (selectCommit.open() != 0) {
                return;
            }
            parentIndex = parents.indexOf(selectCommit.getSelectedCommit());
        } else if (confirm ? !this.confirmCherryPick(shell, repository, commit) : LaunchFinder.shouldCancelBecauseOfRunningLaunches(repository, null)) {
            return;
        }
        this.doCherryPick(repository, commit, parentIndex, true);
    }

    private void doCherryPick(final @NonNull Repository repo, final RevCommit commit, final int parentIndex, final boolean withCleanup) {
        final CherryPickOperation op = new CherryPickOperation(repo, commit);
        op.setMainlineIndex(parentIndex);
        RepositoryJob job = new RepositoryJob(MessageFormat.format(UIText.CherryPickHandler_JobName, 1), null){
            private CherryPickResult result;

            @Override
            protected IStatus performJob(IProgressMonitor monitor) {
                try {
                    op.execute(monitor);
                    this.result = op.getResult();
                    if (!withCleanup && this.result.getStatus() == CherryPickResult.CherryPickStatus.FAILED) {
                        return CherryPickUI.getErrorList(this.result.getFailingPaths());
                    }
                }
                catch (CoreException e) {
                    return Activator.createErrorStatus(UIText.CherryPickOperation_InternalError, e);
                }
                return Status.OK_STATUS;
            }

            @Override
            protected IAction getAction() {
                RevCommit newHead = this.result.getNewHead();
                if (newHead == null) {
                    switch (this.result.getStatus()) {
                        case CONFLICTING: {
                            return new MessageAction(UIText.CherryPickHandler_CherryPickConflictsTitle, UIText.CherryPickHandler_CherryPickConflictsMessage);
                        }
                        case FAILED: {
                            if (!withCleanup) {
                                return new RepositoryJobResultAction(repo, UIText.CherryPickHandler_CherryPickFailedMessage){

                                    @Override
                                    protected void showResult(Repository repository) {
                                        Activator.showErrorStatus(UIText.CherryPickHandler_CherryPickFailedMessage, CherryPickUI.getErrorList(result.getFailingPaths()));
                                    }
                                };
                            }
                            return new CleanupAction(repo, UIText.CherryPickHandler_UncommittedFilesTitle, this.result, () -> CherryPickUI.this.doCherryPick(repo, commit, parentIndex, false));
                        }
                        case OK: {
                            return null;
                        }
                    }
                } else if (this.result.getCherryPickedRefs().isEmpty()) {
                    return new MessageAction(UIText.CherryPickHandler_NoCherryPickPerformedTitle, UIText.CherryPickHandler_NoCherryPickPerformedMessage);
                }
                return null;
            }

            public boolean belongsTo(Object family) {
                if (JobFamilies.CHERRY_PICK.equals(family)) {
                    return true;
                }
                return super.belongsTo(family);
            }
        };
        job.setUser(true);
        job.setRule(op.getSchedulingRule());
        job.schedule();
    }

    private String getLaunchMessage(Repository repository) {
        String launch = LaunchFinder.getRunningLaunchConfiguration(Collections.singleton(repository), null);
        if (launch != null) {
            return MessageFormat.format(UIText.LaunchFinder_RunningLaunchMessage, launch);
        }
        return null;
    }

    private boolean confirmCherryPick(final Shell shell, final Repository repository, final RevCommit commit) throws CoreException {
        Object message;
        final AtomicBoolean confirmed = new AtomicBoolean(false);
        try {
            message = MessageFormat.format(UIText.CherryPickHandler_ConfirmMessage, 1, repository.getBranch());
        }
        catch (IOException e) {
            throw new CoreException(Activator.createErrorStatus("Exception obtaining current repository branch", e));
        }
        String launchMessage = this.getLaunchMessage(repository);
        if (launchMessage != null) {
            message = (String)message + "\n\n" + launchMessage;
        }
        final String question = message;
        shell.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ConfirmCherryPickDialog dialog = new ConfirmCherryPickDialog(shell, question, repository, Arrays.asList(commit));
                int result = dialog.open();
                confirmed.set(result == 0);
            }
        });
        return confirmed.get();
    }

    private static IStatus getErrorList(Map<String, ResolveMerger.MergeFailureReason> failingPaths) {
        MultiStatus result = new MultiStatus("org.eclipse.egit.ui", 4, UIText.CherryPickHandler_CherryPickFailedMessage, null);
        for (Map.Entry<String, ResolveMerger.MergeFailureReason> entry : failingPaths.entrySet()) {
            String path = entry.getKey();
            String reason = CherryPickUI.getReason(entry.getValue());
            String errorMessage = NLS.bind((String)UIText.CherryPickHandler_ErrorMsgTemplate, (Object)path, (Object)reason);
            result.add(Activator.createErrorStatus(errorMessage));
        }
        return result;
    }

    private static String getReason(ResolveMerger.MergeFailureReason mergeFailureReason) {
        switch (mergeFailureReason) {
            case COULD_NOT_DELETE: {
                return UIText.CherryPickHandler_CouldNotDeleteFile;
            }
            case DIRTY_INDEX: {
                return UIText.CherryPickHandler_IndexDirty;
            }
            case DIRTY_WORKTREE: {
                return UIText.CherryPickHandler_WorktreeDirty;
            }
        }
        return UIText.CherryPickHandler_unknown;
    }

    private static class CleanupAction
    extends RepositoryJobResultAction {
        private final CherryPickResult result;
        private final Runnable retry;

        public CleanupAction(@NonNull Repository repo, String title, CherryPickResult result, Runnable retry) {
            super(repo, title);
            this.result = result;
            this.retry = retry;
        }

        @Override
        protected void showResult(Repository repository) {
            Map failed = this.result.getFailingPaths();
            ArrayList<String> failedPaths = new ArrayList<String>(failed.size());
            for (Map.Entry entry : failed.entrySet()) {
                ResolveMerger.MergeFailureReason reason = (ResolveMerger.MergeFailureReason)entry.getValue();
                if (reason == null) {
                    Activator.showErrorStatus(UIText.CherryPickHandler_CherryPickFailedMessage, CherryPickUI.getErrorList(failed));
                    return;
                }
                switch (reason) {
                    case DIRTY_INDEX: 
                    case DIRTY_WORKTREE: {
                        failedPaths.add((String)entry.getKey());
                        break;
                    }
                    default: {
                        Activator.showErrorStatus(UIText.CherryPickHandler_CherryPickFailedMessage, CherryPickUI.getErrorList(failed));
                        return;
                    }
                }
            }
            if (UIRepositoryUtils.showCleanupDialog(repository, failedPaths, UIText.CherryPickHandler_UncommittedFilesTitle, PlatformUI.getWorkbench().getModalDialogShellProvider().getShell())) {
                this.retry.run();
            }
        }
    }

    private static class ConfirmCherryPickDialog
    extends MessageDialog {
        private RepositoryCommit[] commits;

        public ConfirmCherryPickDialog(Shell parentShell, String message, Repository repository, List<RevCommit> revCommits) {
            super(parentShell, UIText.CherryPickHandler_ConfirmTitle, null, message, 5, new String[]{UIText.CherryPickHandler_cherryPickButtonLabel, IDialogConstants.CANCEL_LABEL}, 0);
            this.setShellStyle(this.getShellStyle() | 0x10);
            ArrayList<RepositoryCommit> repoCommits = new ArrayList<RepositoryCommit>();
            for (RevCommit commit : revCommits) {
                repoCommits.add(new RepositoryCommit(repository, commit));
            }
            this.commits = repoCommits.toArray(new RepositoryCommit[0]);
        }

        protected Control createCustomArea(Composite parent) {
            Composite area = new Composite(parent, 0);
            area.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
            area.setLayout((Layout)new FillLayout());
            TreeViewer treeViewer = new TreeViewer(area);
            treeViewer.setContentProvider((IContentProvider)new ContentProvider());
            treeViewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new WorkbenchLabelProvider()));
            treeViewer.setInput((Object)this.commits);
            return area;
        }

        private static class ContentProvider
        extends WorkbenchContentProvider {
            private ContentProvider() {
            }

            public Object[] getElements(Object element) {
                return (Object[])element;
            }

            public Object[] getChildren(Object element) {
                if (element instanceof RepositoryCommit) {
                    return ((RepositoryCommit)((Object)element)).getDiffs();
                }
                return super.getChildren(element);
            }
        }
    }

    private static class MessageAction
    extends Action {
        private final String title;
        private final String message;

        public MessageAction(String title, String message) {
            super(title);
            this.title = title;
            this.message = message;
        }

        public void run() {
            MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getModalDialogShellProvider().getShell(), (String)this.title, (String)this.message);
        }
    }
}

