/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.commons.ui;

import java.lang.reflect.Method;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

@Deprecated
public class TaskBarManager {
    private static final String TASK_BAR_MENU_MANAGER_KEY = "org.eclipse.mylyn.commons.TaskBarMenuManager.instance";

    @Deprecated
    public static MenuManager getTaskBarMenuManager() {
        Widget taskItem = TaskBarManager.getApplicationTaskItem();
        if (taskItem != null) {
            TaskBarMenuManager taskBarMenuManager = TaskBarManager.getTaskBarMenuManager(taskItem);
            return taskBarMenuManager;
        }
        return null;
    }

    private static Widget getApplicationTaskItem() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && workbench.getDisplay() != null && !workbench.isClosing()) {
            try {
                Method getItemMethod;
                Object taskItem;
                Class<?> taskBarClass = Class.forName("org.eclipse.swt.widgets.TaskBar");
                Method getSystemTaskBarMethod = Display.class.getMethod("getSystemTaskBar", new Class[0]);
                Object systemTaskBar = getSystemTaskBarMethod.invoke((Object)workbench.getDisplay(), new Object[0]);
                if (systemTaskBar != null && systemTaskBar.getClass().equals(taskBarClass) && (taskItem = (getItemMethod = taskBarClass.getMethod("getItem", Shell.class)).invoke(systemTaskBar, new Object[1])) instanceof Widget) {
                    return (Widget)taskItem;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    private static TaskBarMenuManager getTaskBarMenuManager(Widget taskItem) {
        TaskBarMenuManager taskBarMenuManager;
        Assert.isNotNull((Object)taskItem);
        Object data = taskItem.getData(TASK_BAR_MENU_MANAGER_KEY);
        if (data instanceof TaskBarMenuManager) {
            taskBarMenuManager = (TaskBarMenuManager)((Object)data);
        } else {
            taskBarMenuManager = new TaskBarMenuManager(taskItem);
            taskItem.setData(TASK_BAR_MENU_MANAGER_KEY, (Object)taskBarMenuManager);
        }
        return taskBarMenuManager;
    }

    private static final class TaskBarMenuManager
    extends MenuManager {
        private final Widget taskItem;

        public TaskBarMenuManager(Widget taskItem) {
            this.taskItem = taskItem;
        }

        protected void update(boolean force, boolean recursive) {
            Shell shell;
            Menu menu = this.getMenu();
            if (menu == null && (shell = TaskBarMenuManager.getShell()) != null) {
                menu = this.createContextMenu((Control)shell);
            }
            super.update(force, recursive);
            if (menu != null && menu.getItemCount() == 0) {
                menu = null;
            }
            if (this.taskItem != null && !this.taskItem.isDisposed()) {
                this.setMenuOnTaskItem(this.taskItem, menu);
            }
        }

        private void setMenuOnTaskItem(Widget taskItem, Menu menu) {
            try {
                Class<?> taskItemClass = Class.forName("org.eclipse.swt.widgets.TaskItem");
                if (taskItem.getClass().equals(taskItemClass)) {
                    Method setMenuMethod = taskItemClass.getMethod("setMenu", Menu.class);
                    setMenuMethod.invoke((Object)taskItem, menu);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        private static Shell getShell() {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window == null) {
                IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
                if (windows.length > 0) {
                    return windows[0].getShell();
                }
            } else {
                return window.getShell();
            }
            return null;
        }
    }
}

