/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene99;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.KnnFieldVectorsWriter;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.apache.lucene.codecs.KnnVectorsWriter;
import org.apache.lucene.codecs.hnsw.FlatFieldVectorsWriter;
import org.apache.lucene.codecs.hnsw.FlatVectorsScorer;
import org.apache.lucene.codecs.hnsw.FlatVectorsWriter;
import org.apache.lucene.codecs.lucene95.OrdToDocDISIReaderConfiguration;
import org.apache.lucene.codecs.lucene99.Lucene99ScalarQuantizedVectorsFormat;
import org.apache.lucene.codecs.lucene99.OffHeapQuantizedByteVectorValues;
import org.apache.lucene.codecs.perfield.PerFieldKnnVectorsFormat;
import org.apache.lucene.index.DocIDMerger;
import org.apache.lucene.index.DocsWithFieldSet;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Sorter;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.internal.hppc.IntArrayList;
import org.apache.lucene.search.VectorScorer;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.InfoStream;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.VectorUtil;
import org.apache.lucene.util.hnsw.CloseableRandomVectorScorerSupplier;
import org.apache.lucene.util.hnsw.RandomVectorScorerSupplier;
import org.apache.lucene.util.hnsw.UpdateableRandomVectorScorer;
import org.apache.lucene.util.quantization.QuantizedByteVectorValues;
import org.apache.lucene.util.quantization.QuantizedVectorsReader;
import org.apache.lucene.util.quantization.ScalarQuantizer;

public final class Lucene99ScalarQuantizedVectorsWriter
extends FlatVectorsWriter {
    private static final long SHALLOW_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(Lucene99ScalarQuantizedVectorsWriter.class);
    private static final float QUANTILE_RECOMPUTE_LIMIT = 32.0f;
    private static final float REQUANTIZATION_LIMIT = 0.2f;
    private final SegmentWriteState segmentWriteState;
    private final List<FieldWriter> fields = new ArrayList<FieldWriter>();
    private final IndexOutput meta;
    private final IndexOutput quantizedVectorData;
    private final Float confidenceInterval;
    private final FlatVectorsWriter rawVectorDelegate;
    private final byte bits;
    private final boolean compress;
    private final int version;
    private boolean finished;

    public Lucene99ScalarQuantizedVectorsWriter(SegmentWriteState state, Float confidenceInterval, FlatVectorsWriter rawVectorDelegate, FlatVectorsScorer scorer) throws IOException {
        this(state, 0, confidenceInterval, 7, false, rawVectorDelegate, scorer);
        if (confidenceInterval != null && confidenceInterval.floatValue() == 0.0f) {
            throw new IllegalArgumentException("confidenceInterval cannot be set to zero");
        }
    }

    public Lucene99ScalarQuantizedVectorsWriter(SegmentWriteState state, Float confidenceInterval, byte bits, boolean compress, FlatVectorsWriter rawVectorDelegate, FlatVectorsScorer scorer) throws IOException {
        this(state, 1, confidenceInterval, bits, compress, rawVectorDelegate, scorer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Lucene99ScalarQuantizedVectorsWriter(SegmentWriteState state, int version, Float confidenceInterval, byte bits, boolean compress, FlatVectorsWriter rawVectorDelegate, FlatVectorsScorer scorer) throws IOException {
        super(scorer);
        this.confidenceInterval = confidenceInterval;
        this.bits = bits;
        this.compress = compress;
        this.version = version;
        this.segmentWriteState = state;
        String metaFileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "vemq");
        String quantizedVectorDataFileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "veq");
        this.rawVectorDelegate = rawVectorDelegate;
        boolean success = false;
        try {
            this.meta = state.directory.createOutput(metaFileName, state.context);
            this.quantizedVectorData = state.directory.createOutput(quantizedVectorDataFileName, state.context);
            CodecUtil.writeIndexHeader(this.meta, "Lucene99ScalarQuantizedVectorsFormatMeta", version, state.segmentInfo.getId(), state.segmentSuffix);
            CodecUtil.writeIndexHeader(this.quantizedVectorData, "Lucene99ScalarQuantizedVectorsFormatData", version, state.segmentInfo.getId(), state.segmentSuffix);
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(this);
            throw throwable;
        }
    }

    @Override
    public FlatFieldVectorsWriter<?> addField(FieldInfo fieldInfo) throws IOException {
        KnnFieldVectorsWriter rawVectorDelegate = this.rawVectorDelegate.addField(fieldInfo);
        if (fieldInfo.getVectorEncoding().equals((Object)VectorEncoding.FLOAT32)) {
            if (this.bits <= 4 && fieldInfo.getVectorDimension() % 2 != 0) {
                throw new IllegalArgumentException("bits=" + this.bits + " is not supported for odd vector dimensions; vector dimension=" + fieldInfo.getVectorDimension());
            }
            FieldWriter quantizedWriter = new FieldWriter(this.confidenceInterval, this.bits, this.compress, fieldInfo, this.segmentWriteState.infoStream, (FlatFieldVectorsWriter<float[]>)rawVectorDelegate);
            this.fields.add(quantizedWriter);
            return quantizedWriter;
        }
        return rawVectorDelegate;
    }

    @Override
    public void mergeOneField(FieldInfo fieldInfo, MergeState mergeState) throws IOException {
        this.rawVectorDelegate.mergeOneField(fieldInfo, mergeState);
        if (fieldInfo.getVectorEncoding().equals((Object)VectorEncoding.FLOAT32)) {
            ScalarQuantizer mergedQuantizationState = Lucene99ScalarQuantizedVectorsWriter.mergeAndRecalculateQuantiles(mergeState, fieldInfo, this.confidenceInterval, this.bits);
            MergedQuantizedVectorValues byteVectorValues = MergedQuantizedVectorValues.mergeQuantizedByteVectorValues(fieldInfo, mergeState, mergedQuantizationState);
            long vectorDataOffset = this.quantizedVectorData.alignFilePointer(4);
            DocsWithFieldSet docsWithField = Lucene99ScalarQuantizedVectorsWriter.writeQuantizedVectorData(this.quantizedVectorData, byteVectorValues, this.bits, this.compress);
            long vectorDataLength = this.quantizedVectorData.getFilePointer() - vectorDataOffset;
            this.writeMeta(fieldInfo, this.segmentWriteState.segmentInfo.maxDoc(), vectorDataOffset, vectorDataLength, this.confidenceInterval, this.bits, this.compress, Float.valueOf(mergedQuantizationState.getLowerQuantile()), Float.valueOf(mergedQuantizationState.getUpperQuantile()), docsWithField);
        }
    }

    @Override
    public CloseableRandomVectorScorerSupplier mergeOneFieldToIndex(FieldInfo fieldInfo, MergeState mergeState) throws IOException {
        if (fieldInfo.getVectorEncoding().equals((Object)VectorEncoding.FLOAT32)) {
            this.rawVectorDelegate.mergeOneField(fieldInfo, mergeState);
            ScalarQuantizer mergedQuantizationState = Lucene99ScalarQuantizedVectorsWriter.mergeAndRecalculateQuantiles(mergeState, fieldInfo, this.confidenceInterval, this.bits);
            return this.mergeOneFieldToIndex(this.segmentWriteState, fieldInfo, mergeState, mergedQuantizationState);
        }
        return this.rawVectorDelegate.mergeOneFieldToIndex(fieldInfo, mergeState);
    }

    @Override
    public void flush(int maxDoc, Sorter.DocMap sortMap) throws IOException {
        this.rawVectorDelegate.flush(maxDoc, sortMap);
        for (FieldWriter field : this.fields) {
            ScalarQuantizer quantizer = field.createQuantizer();
            if (sortMap == null) {
                this.writeField(field, maxDoc, quantizer);
            } else {
                this.writeSortingField(field, maxDoc, sortMap, quantizer);
            }
            field.finish();
        }
    }

    @Override
    public void finish() throws IOException {
        if (this.finished) {
            throw new IllegalStateException("already finished");
        }
        this.finished = true;
        this.rawVectorDelegate.finish();
        if (this.meta != null) {
            this.meta.writeInt(-1);
            CodecUtil.writeFooter(this.meta);
        }
        if (this.quantizedVectorData != null) {
            CodecUtil.writeFooter(this.quantizedVectorData);
        }
    }

    @Override
    public long ramBytesUsed() {
        long total = SHALLOW_RAM_BYTES_USED;
        for (FieldWriter field : this.fields) {
            total += field.ramBytesUsed();
        }
        return total;
    }

    private void writeField(FieldWriter fieldData, int maxDoc, ScalarQuantizer scalarQuantizer) throws IOException {
        long vectorDataOffset = this.quantizedVectorData.alignFilePointer(4);
        this.writeQuantizedVectors(fieldData, scalarQuantizer);
        long vectorDataLength = this.quantizedVectorData.getFilePointer() - vectorDataOffset;
        this.writeMeta(fieldData.fieldInfo, maxDoc, vectorDataOffset, vectorDataLength, this.confidenceInterval, this.bits, this.compress, Float.valueOf(scalarQuantizer.getLowerQuantile()), Float.valueOf(scalarQuantizer.getUpperQuantile()), fieldData.getDocsWithFieldSet());
    }

    private void writeMeta(FieldInfo field, int maxDoc, long vectorDataOffset, long vectorDataLength, Float confidenceInterval, byte bits, boolean compress, Float lowerQuantile, Float upperQuantile, DocsWithFieldSet docsWithField) throws IOException {
        this.meta.writeInt(field.number);
        this.meta.writeInt(field.getVectorEncoding().ordinal());
        this.meta.writeInt(field.getVectorSimilarityFunction().ordinal());
        this.meta.writeVLong(vectorDataOffset);
        this.meta.writeVLong(vectorDataLength);
        this.meta.writeVInt(field.getVectorDimension());
        int count = docsWithField.cardinality();
        this.meta.writeInt(count);
        if (count > 0) {
            assert (Float.isFinite(lowerQuantile.floatValue()) && Float.isFinite(upperQuantile.floatValue()));
            if (this.version >= 1) {
                this.meta.writeInt(confidenceInterval == null ? -1 : Float.floatToIntBits(confidenceInterval.floatValue()));
                this.meta.writeByte(bits);
                this.meta.writeByte(compress ? (byte)1 : 0);
            } else {
                assert (confidenceInterval == null || confidenceInterval.floatValue() != 0.0f);
                this.meta.writeInt(Float.floatToIntBits(confidenceInterval == null ? Lucene99ScalarQuantizedVectorsFormat.calculateDefaultConfidenceInterval(field.getVectorDimension()) : confidenceInterval.floatValue()));
            }
            this.meta.writeInt(Float.floatToIntBits(lowerQuantile.floatValue()));
            this.meta.writeInt(Float.floatToIntBits(upperQuantile.floatValue()));
        }
        OrdToDocDISIReaderConfiguration.writeStoredMeta(16, this.meta, this.quantizedVectorData, count, maxDoc, docsWithField);
    }

    private void writeQuantizedVectors(FieldWriter fieldData, ScalarQuantizer scalarQuantizer) throws IOException {
        float[] copy;
        byte[] vector = new byte[fieldData.fieldInfo.getVectorDimension()];
        byte[] compressedVector = fieldData.compress ? OffHeapQuantizedByteVectorValues.compressedArray(fieldData.fieldInfo.getVectorDimension(), this.bits) : null;
        ByteBuffer offsetBuffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
        float[] fArray = copy = fieldData.normalize ? new float[fieldData.fieldInfo.getVectorDimension()] : null;
        assert (fieldData.getVectors().isEmpty() || scalarQuantizer != null);
        for (float[] v : fieldData.getVectors()) {
            if (fieldData.normalize) {
                System.arraycopy(v, 0, copy, 0, copy.length);
                VectorUtil.l2normalize(copy);
                v = copy;
            }
            float offsetCorrection = scalarQuantizer.quantize(v, vector, fieldData.fieldInfo.getVectorSimilarityFunction());
            if (compressedVector != null) {
                OffHeapQuantizedByteVectorValues.compressBytes(vector, compressedVector);
                this.quantizedVectorData.writeBytes(compressedVector, compressedVector.length);
            } else {
                this.quantizedVectorData.writeBytes(vector, vector.length);
            }
            offsetBuffer.putFloat(offsetCorrection);
            this.quantizedVectorData.writeBytes(offsetBuffer.array(), offsetBuffer.array().length);
            offsetBuffer.rewind();
        }
    }

    private void writeSortingField(FieldWriter fieldData, int maxDoc, Sorter.DocMap sortMap, ScalarQuantizer scalarQuantizer) throws IOException {
        int[] ordMap = new int[fieldData.getDocsWithFieldSet().cardinality()];
        DocsWithFieldSet newDocsWithField = new DocsWithFieldSet();
        Lucene99ScalarQuantizedVectorsWriter.mapOldOrdToNewOrd(fieldData.getDocsWithFieldSet(), sortMap, null, ordMap, newDocsWithField);
        long vectorDataOffset = this.quantizedVectorData.alignFilePointer(4);
        this.writeSortedQuantizedVectors(fieldData, ordMap, scalarQuantizer);
        long quantizedVectorLength = this.quantizedVectorData.getFilePointer() - vectorDataOffset;
        this.writeMeta(fieldData.fieldInfo, maxDoc, vectorDataOffset, quantizedVectorLength, this.confidenceInterval, this.bits, this.compress, Float.valueOf(scalarQuantizer.getLowerQuantile()), Float.valueOf(scalarQuantizer.getUpperQuantile()), newDocsWithField);
    }

    private void writeSortedQuantizedVectors(FieldWriter fieldData, int[] ordMap, ScalarQuantizer scalarQuantizer) throws IOException {
        byte[] vector = new byte[fieldData.fieldInfo.getVectorDimension()];
        byte[] compressedVector = fieldData.compress ? OffHeapQuantizedByteVectorValues.compressedArray(fieldData.fieldInfo.getVectorDimension(), this.bits) : null;
        ByteBuffer offsetBuffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
        float[] copy = fieldData.normalize ? new float[fieldData.fieldInfo.getVectorDimension()] : null;
        for (int ordinal : ordMap) {
            float[] v = fieldData.getVectors().get(ordinal);
            if (fieldData.normalize) {
                System.arraycopy(v, 0, copy, 0, copy.length);
                VectorUtil.l2normalize(copy);
                v = copy;
            }
            float offsetCorrection = scalarQuantizer.quantize(v, vector, fieldData.fieldInfo.getVectorSimilarityFunction());
            if (compressedVector != null) {
                OffHeapQuantizedByteVectorValues.compressBytes(vector, compressedVector);
                this.quantizedVectorData.writeBytes(compressedVector, compressedVector.length);
            } else {
                this.quantizedVectorData.writeBytes(vector, vector.length);
            }
            offsetBuffer.putFloat(offsetCorrection);
            this.quantizedVectorData.writeBytes(offsetBuffer.array(), offsetBuffer.array().length);
            offsetBuffer.rewind();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ScalarQuantizedCloseableRandomVectorScorerSupplier mergeOneFieldToIndex(SegmentWriteState segmentWriteState, FieldInfo fieldInfo, MergeState mergeState, ScalarQuantizer mergedQuantizationState) throws IOException {
        ScalarQuantizedCloseableRandomVectorScorerSupplier scalarQuantizedCloseableRandomVectorScorerSupplier;
        block4: {
            if (segmentWriteState.infoStream.isEnabled("QVEC")) {
                segmentWriteState.infoStream.message("QVEC", "quantized field= confidenceInterval=" + this.confidenceInterval + " minQuantile=" + mergedQuantizationState.getLowerQuantile() + " maxQuantile=" + mergedQuantizationState.getUpperQuantile());
            }
            long vectorDataOffset = this.quantizedVectorData.alignFilePointer(4);
            IndexOutput tempQuantizedVectorData = segmentWriteState.directory.createTempOutput(this.quantizedVectorData.getName(), "temp", segmentWriteState.context);
            IndexInput quantizationDataInput = null;
            boolean success = false;
            try {
                MergedQuantizedVectorValues byteVectorValues = MergedQuantizedVectorValues.mergeQuantizedByteVectorValues(fieldInfo, mergeState, mergedQuantizationState);
                DocsWithFieldSet docsWithField = Lucene99ScalarQuantizedVectorsWriter.writeQuantizedVectorData(tempQuantizedVectorData, byteVectorValues, this.bits, this.compress);
                CodecUtil.writeFooter(tempQuantizedVectorData);
                IOUtils.close(tempQuantizedVectorData);
                quantizationDataInput = segmentWriteState.directory.openInput(tempQuantizedVectorData.getName(), segmentWriteState.context);
                this.quantizedVectorData.copyBytes(quantizationDataInput, quantizationDataInput.length() - (long)CodecUtil.footerLength());
                long vectorDataLength = this.quantizedVectorData.getFilePointer() - vectorDataOffset;
                CodecUtil.retrieveChecksum(quantizationDataInput);
                this.writeMeta(fieldInfo, segmentWriteState.segmentInfo.maxDoc(), vectorDataOffset, vectorDataLength, this.confidenceInterval, this.bits, this.compress, Float.valueOf(mergedQuantizationState.getLowerQuantile()), Float.valueOf(mergedQuantizationState.getUpperQuantile()), docsWithField);
                success = true;
                IndexInput finalQuantizationDataInput = quantizationDataInput;
                scalarQuantizedCloseableRandomVectorScorerSupplier = new ScalarQuantizedCloseableRandomVectorScorerSupplier(() -> {
                    IOUtils.close(finalQuantizationDataInput);
                    segmentWriteState.directory.deleteFile(tempQuantizedVectorData.getName());
                }, docsWithField.cardinality(), this.vectorsScorer.getRandomVectorScorerSupplier(fieldInfo.getVectorSimilarityFunction(), new OffHeapQuantizedByteVectorValues.DenseOffHeapVectorValues(fieldInfo.getVectorDimension(), docsWithField.cardinality(), mergedQuantizationState, this.compress, fieldInfo.getVectorSimilarityFunction(), this.vectorsScorer, quantizationDataInput)));
                if (success) break block4;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException(tempQuantizedVectorData, quantizationDataInput);
                    IOUtils.deleteFilesIgnoringExceptions(segmentWriteState.directory, tempQuantizedVectorData.getName());
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(tempQuantizedVectorData, quantizationDataInput);
            IOUtils.deleteFilesIgnoringExceptions(segmentWriteState.directory, tempQuantizedVectorData.getName());
        }
        return scalarQuantizedCloseableRandomVectorScorerSupplier;
    }

    static ScalarQuantizer mergeQuantiles(List<ScalarQuantizer> quantizationStates, IntArrayList segmentSizes, byte bits) {
        assert (quantizationStates.size() == segmentSizes.size());
        if (quantizationStates.isEmpty()) {
            return null;
        }
        float lowerQuantile = 0.0f;
        float upperQuantile = 0.0f;
        int totalCount = 0;
        for (int i = 0; i < quantizationStates.size(); ++i) {
            if (quantizationStates.get(i) == null) {
                return null;
            }
            lowerQuantile += quantizationStates.get(i).getLowerQuantile() * (float)segmentSizes.get(i);
            upperQuantile += quantizationStates.get(i).getUpperQuantile() * (float)segmentSizes.get(i);
            totalCount += segmentSizes.get(i);
            if (quantizationStates.get(i).getBits() == bits) continue;
            return null;
        }
        return new ScalarQuantizer(lowerQuantile /= (float)totalCount, upperQuantile /= (float)totalCount, bits);
    }

    static boolean shouldRecomputeQuantiles(ScalarQuantizer mergedQuantizationState, List<ScalarQuantizer> quantizationStates) {
        float limit = (mergedQuantizationState.getUpperQuantile() - mergedQuantizationState.getLowerQuantile()) / 32.0f;
        for (ScalarQuantizer quantizationState : quantizationStates) {
            if (Math.abs(quantizationState.getUpperQuantile() - mergedQuantizationState.getUpperQuantile()) > limit) {
                return true;
            }
            if (!(Math.abs(quantizationState.getLowerQuantile() - mergedQuantizationState.getLowerQuantile()) > limit)) continue;
            return true;
        }
        return false;
    }

    private static QuantizedVectorsReader getQuantizedKnnVectorsReader(KnnVectorsReader vectorsReader, String fieldName) {
        if (vectorsReader instanceof PerFieldKnnVectorsFormat.FieldsReader) {
            PerFieldKnnVectorsFormat.FieldsReader candidateReader = (PerFieldKnnVectorsFormat.FieldsReader)vectorsReader;
            vectorsReader = candidateReader.getFieldReader(fieldName);
        }
        if (vectorsReader instanceof QuantizedVectorsReader) {
            QuantizedVectorsReader reader = (QuantizedVectorsReader)((Object)vectorsReader);
            return reader;
        }
        return null;
    }

    private static ScalarQuantizer getQuantizedState(KnnVectorsReader vectorsReader, String fieldName) {
        QuantizedVectorsReader reader = Lucene99ScalarQuantizedVectorsWriter.getQuantizedKnnVectorsReader(vectorsReader, fieldName);
        if (reader != null) {
            return reader.getQuantizationState(fieldName);
        }
        return null;
    }

    public static ScalarQuantizer mergeAndRecalculateQuantiles(MergeState mergeState, FieldInfo fieldInfo, Float confidenceInterval, byte bits) throws IOException {
        assert (fieldInfo.getVectorEncoding().equals((Object)VectorEncoding.FLOAT32));
        ArrayList<ScalarQuantizer> quantizationStates = new ArrayList<ScalarQuantizer>(mergeState.liveDocs.length);
        IntArrayList segmentSizes = new IntArrayList(mergeState.liveDocs.length);
        for (int i = 0; i < mergeState.liveDocs.length; ++i) {
            FloatVectorValues fvv;
            if (!KnnVectorsWriter.MergedVectorValues.hasVectorValues(mergeState.fieldInfos[i], fieldInfo.name) || (fvv = mergeState.knnVectorsReaders[i].getFloatVectorValues(fieldInfo.name)) == null || fvv.size() <= 0) continue;
            ScalarQuantizer quantizationState = Lucene99ScalarQuantizedVectorsWriter.getQuantizedState(mergeState.knnVectorsReaders[i], fieldInfo.name);
            quantizationStates.add(quantizationState);
            segmentSizes.add(fvv.size());
        }
        ScalarQuantizer mergedQuantiles = Lucene99ScalarQuantizedVectorsWriter.mergeQuantiles(quantizationStates, segmentSizes, bits);
        if (mergedQuantiles == null || bits <= 4 || Lucene99ScalarQuantizedVectorsWriter.shouldRecomputeQuantiles(mergedQuantiles, quantizationStates)) {
            int numVectors = 0;
            KnnVectorValues.DocIndexIterator iter = KnnVectorsWriter.MergedVectorValues.mergeFloatVectorValues(fieldInfo, mergeState).iterator();
            int doc = iter.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                ++numVectors;
                doc = iter.nextDoc();
            }
            return Lucene99ScalarQuantizedVectorsWriter.buildScalarQuantizer(KnnVectorsWriter.MergedVectorValues.mergeFloatVectorValues(fieldInfo, mergeState), numVectors, fieldInfo.getVectorSimilarityFunction(), confidenceInterval, bits);
        }
        return mergedQuantiles;
    }

    static ScalarQuantizer buildScalarQuantizer(FloatVectorValues floatVectorValues, int numVectors, VectorSimilarityFunction vectorSimilarityFunction, Float confidenceInterval, byte bits) throws IOException {
        if (vectorSimilarityFunction == VectorSimilarityFunction.COSINE) {
            floatVectorValues = new NormalizedFloatVectorValues(floatVectorValues);
            vectorSimilarityFunction = VectorSimilarityFunction.DOT_PRODUCT;
        }
        if (confidenceInterval != null && confidenceInterval.floatValue() == 0.0f) {
            return ScalarQuantizer.fromVectorsAutoInterval(floatVectorValues, vectorSimilarityFunction, numVectors, bits);
        }
        return ScalarQuantizer.fromVectors(floatVectorValues, confidenceInterval == null ? Lucene99ScalarQuantizedVectorsFormat.calculateDefaultConfidenceInterval(floatVectorValues.dimension()) : confidenceInterval.floatValue(), numVectors, bits);
    }

    static boolean shouldRequantize(ScalarQuantizer existingQuantiles, ScalarQuantizer newQuantiles) {
        float tol = 0.2f * (newQuantiles.getUpperQuantile() - newQuantiles.getLowerQuantile()) / 128.0f;
        if (Math.abs(existingQuantiles.getUpperQuantile() - newQuantiles.getUpperQuantile()) > tol) {
            return true;
        }
        return Math.abs(existingQuantiles.getLowerQuantile() - newQuantiles.getLowerQuantile()) > tol;
    }

    public static DocsWithFieldSet writeQuantizedVectorData(IndexOutput output, QuantizedByteVectorValues quantizedByteVectorValues, byte bits, boolean compress) throws IOException {
        DocsWithFieldSet docsWithField = new DocsWithFieldSet();
        byte[] compressedVector = compress ? OffHeapQuantizedByteVectorValues.compressedArray(quantizedByteVectorValues.dimension(), bits) : null;
        KnnVectorValues.DocIndexIterator iter = quantizedByteVectorValues.iterator();
        int docV = iter.nextDoc();
        while (docV != Integer.MAX_VALUE) {
            byte[] binaryValue = quantizedByteVectorValues.vectorValue(iter.index());
            assert (binaryValue.length == quantizedByteVectorValues.dimension()) : "dim=" + quantizedByteVectorValues.dimension() + " len=" + binaryValue.length;
            if (compressedVector != null) {
                OffHeapQuantizedByteVectorValues.compressBytes(binaryValue, compressedVector);
                output.writeBytes(compressedVector, compressedVector.length);
            } else {
                output.writeBytes(binaryValue, binaryValue.length);
            }
            output.writeInt(Float.floatToIntBits(quantizedByteVectorValues.getScoreCorrectionConstant(iter.index())));
            docsWithField.add(docV);
            docV = iter.nextDoc();
        }
        return docsWithField;
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(this.meta, this.quantizedVectorData, this.rawVectorDelegate);
    }

    static class FieldWriter
    extends FlatFieldVectorsWriter<float[]> {
        private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(FieldWriter.class);
        private final FieldInfo fieldInfo;
        private final Float confidenceInterval;
        private final byte bits;
        private final boolean compress;
        private final InfoStream infoStream;
        private final boolean normalize;
        private boolean finished;
        private final FlatFieldVectorsWriter<float[]> flatFieldVectorsWriter;

        FieldWriter(Float confidenceInterval, byte bits, boolean compress, FieldInfo fieldInfo, InfoStream infoStream, FlatFieldVectorsWriter<float[]> indexWriter) {
            this.confidenceInterval = confidenceInterval;
            this.bits = bits;
            this.fieldInfo = fieldInfo;
            this.normalize = fieldInfo.getVectorSimilarityFunction() == VectorSimilarityFunction.COSINE;
            this.infoStream = infoStream;
            this.compress = compress;
            this.flatFieldVectorsWriter = Objects.requireNonNull(indexWriter);
        }

        @Override
        public boolean isFinished() {
            return this.finished && this.flatFieldVectorsWriter.isFinished();
        }

        @Override
        public void finish() throws IOException {
            if (this.finished) {
                return;
            }
            assert (this.flatFieldVectorsWriter.isFinished());
            this.finished = true;
        }

        ScalarQuantizer createQuantizer() throws IOException {
            assert (this.flatFieldVectorsWriter.isFinished());
            List<float[]> floatVectors = this.flatFieldVectorsWriter.getVectors();
            if (floatVectors.size() == 0) {
                return new ScalarQuantizer(0.0f, 0.0f, this.bits);
            }
            ScalarQuantizer quantizer = Lucene99ScalarQuantizedVectorsWriter.buildScalarQuantizer(new FloatVectorWrapper(floatVectors), floatVectors.size(), this.fieldInfo.getVectorSimilarityFunction(), this.confidenceInterval, this.bits);
            if (this.infoStream.isEnabled("QVEC")) {
                this.infoStream.message("QVEC", "quantized field= confidenceInterval=" + this.confidenceInterval + " bits=" + this.bits + " minQuantile=" + quantizer.getLowerQuantile() + " maxQuantile=" + quantizer.getUpperQuantile());
            }
            return quantizer;
        }

        @Override
        public long ramBytesUsed() {
            long size = SHALLOW_SIZE;
            return size += this.flatFieldVectorsWriter.ramBytesUsed();
        }

        @Override
        public void addValue(int docID, float[] vectorValue) throws IOException {
            this.flatFieldVectorsWriter.addValue(docID, vectorValue);
        }

        @Override
        public float[] copyValue(float[] vectorValue) {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<float[]> getVectors() {
            return this.flatFieldVectorsWriter.getVectors();
        }

        @Override
        public DocsWithFieldSet getDocsWithFieldSet() {
            return this.flatFieldVectorsWriter.getDocsWithFieldSet();
        }
    }

    static class MergedQuantizedVectorValues
    extends QuantizedByteVectorValues {
        private final List<QuantizedByteVectorValueSub> subs;
        private final DocIDMerger<QuantizedByteVectorValueSub> docIdMerger;
        private final int size;
        private QuantizedByteVectorValueSub current;

        public static MergedQuantizedVectorValues mergeQuantizedByteVectorValues(FieldInfo fieldInfo, MergeState mergeState, ScalarQuantizer scalarQuantizer) throws IOException {
            assert (fieldInfo != null && fieldInfo.hasVectorValues());
            ArrayList<QuantizedByteVectorValueSub> subs = new ArrayList<QuantizedByteVectorValueSub>();
            for (int i = 0; i < mergeState.knnVectorsReaders.length; ++i) {
                QuantizedByteVectorValueSub sub;
                if (!KnnVectorsWriter.MergedVectorValues.hasVectorValues(mergeState.fieldInfos[i], fieldInfo.name)) continue;
                QuantizedVectorsReader reader = Lucene99ScalarQuantizedVectorsWriter.getQuantizedKnnVectorsReader(mergeState.knnVectorsReaders[i], fieldInfo.name);
                assert (scalarQuantizer != null);
                if (reader == null || reader.getQuantizationState(fieldInfo.name) == null || scalarQuantizer.getBits() <= 4 || Lucene99ScalarQuantizedVectorsWriter.shouldRequantize(reader.getQuantizationState(fieldInfo.name), scalarQuantizer)) {
                    FloatVectorValues toQuantize = mergeState.knnVectorsReaders[i].getFloatVectorValues(fieldInfo.name);
                    if (fieldInfo.getVectorSimilarityFunction() == VectorSimilarityFunction.COSINE) {
                        toQuantize = new NormalizedFloatVectorValues(toQuantize);
                    }
                    sub = new QuantizedByteVectorValueSub(mergeState.docMaps[i], new QuantizedFloatVectorValues(toQuantize, fieldInfo.getVectorSimilarityFunction(), scalarQuantizer));
                } else {
                    sub = new QuantizedByteVectorValueSub(mergeState.docMaps[i], new OffsetCorrectedQuantizedByteVectorValues(reader.getQuantizedVectorValues(fieldInfo.name), fieldInfo.getVectorSimilarityFunction(), scalarQuantizer, reader.getQuantizationState(fieldInfo.name)));
                }
                subs.add(sub);
            }
            return new MergedQuantizedVectorValues(subs, mergeState);
        }

        private MergedQuantizedVectorValues(List<QuantizedByteVectorValueSub> subs, MergeState mergeState) throws IOException {
            this.subs = subs;
            this.docIdMerger = DocIDMerger.of(subs, mergeState.needsIndexSort);
            int totalSize = 0;
            for (QuantizedByteVectorValueSub sub : subs) {
                totalSize += sub.values.size();
            }
            this.size = totalSize;
        }

        @Override
        public byte[] vectorValue(int ord) throws IOException {
            return this.current.values.vectorValue(this.current.index());
        }

        @Override
        public KnnVectorValues.DocIndexIterator iterator() {
            return new CompositeIterator();
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public int dimension() {
            return this.subs.get((int)0).values.dimension();
        }

        @Override
        public float getScoreCorrectionConstant(int ord) throws IOException {
            return this.current.values.getScoreCorrectionConstant(this.current.index());
        }

        private class CompositeIterator
        extends KnnVectorValues.DocIndexIterator {
            private int docId = -1;
            private int ord = -1;

            @Override
            public int index() {
                return this.ord;
            }

            @Override
            public int docID() {
                return this.docId;
            }

            @Override
            public int nextDoc() throws IOException {
                MergedQuantizedVectorValues.this.current = MergedQuantizedVectorValues.this.docIdMerger.next();
                if (MergedQuantizedVectorValues.this.current == null) {
                    this.docId = Integer.MAX_VALUE;
                    this.ord = Integer.MAX_VALUE;
                } else {
                    this.docId = MergedQuantizedVectorValues.this.current.mappedDocID;
                    ++this.ord;
                }
                return this.docId;
            }

            @Override
            public int advance(int target) throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public long cost() {
                return MergedQuantizedVectorValues.this.size;
            }
        }
    }

    static final class ScalarQuantizedCloseableRandomVectorScorerSupplier
    implements CloseableRandomVectorScorerSupplier {
        private final RandomVectorScorerSupplier supplier;
        private final Closeable onClose;
        private final int numVectors;

        ScalarQuantizedCloseableRandomVectorScorerSupplier(Closeable onClose, int numVectors, RandomVectorScorerSupplier supplier) {
            this.onClose = onClose;
            this.supplier = supplier;
            this.numVectors = numVectors;
        }

        @Override
        public UpdateableRandomVectorScorer scorer() throws IOException {
            return this.supplier.scorer();
        }

        @Override
        public RandomVectorScorerSupplier copy() throws IOException {
            return this.supplier.copy();
        }

        @Override
        public void close() throws IOException {
            this.onClose.close();
        }

        @Override
        public int totalVectorCount() {
            return this.numVectors;
        }
    }

    static final class NormalizedFloatVectorValues
    extends FloatVectorValues {
        private final FloatVectorValues values;
        private final float[] normalizedVector;

        public NormalizedFloatVectorValues(FloatVectorValues values) {
            this.values = values;
            this.normalizedVector = new float[values.dimension()];
        }

        @Override
        public int dimension() {
            return this.values.dimension();
        }

        @Override
        public int size() {
            return this.values.size();
        }

        @Override
        public int ordToDoc(int ord) {
            return this.values.ordToDoc(ord);
        }

        @Override
        public float[] vectorValue(int ord) throws IOException {
            System.arraycopy(this.values.vectorValue(ord), 0, this.normalizedVector, 0, this.normalizedVector.length);
            VectorUtil.l2normalize(this.normalizedVector);
            return this.normalizedVector;
        }

        @Override
        public KnnVectorValues.DocIndexIterator iterator() {
            return this.values.iterator();
        }

        @Override
        public NormalizedFloatVectorValues copy() throws IOException {
            return new NormalizedFloatVectorValues(this.values.copy());
        }
    }

    static final class OffsetCorrectedQuantizedByteVectorValues
    extends QuantizedByteVectorValues {
        private final QuantizedByteVectorValues in;
        private final VectorSimilarityFunction vectorSimilarityFunction;
        private final ScalarQuantizer scalarQuantizer;
        private final ScalarQuantizer oldScalarQuantizer;

        OffsetCorrectedQuantizedByteVectorValues(QuantizedByteVectorValues in, VectorSimilarityFunction vectorSimilarityFunction, ScalarQuantizer scalarQuantizer, ScalarQuantizer oldScalarQuantizer) {
            this.in = in;
            this.vectorSimilarityFunction = vectorSimilarityFunction;
            this.scalarQuantizer = scalarQuantizer;
            this.oldScalarQuantizer = oldScalarQuantizer;
        }

        @Override
        public float getScoreCorrectionConstant(int ord) throws IOException {
            return this.scalarQuantizer.recalculateCorrectiveOffset(this.in.vectorValue(ord), this.oldScalarQuantizer, this.vectorSimilarityFunction);
        }

        @Override
        public int dimension() {
            return this.in.dimension();
        }

        @Override
        public int size() {
            return this.in.size();
        }

        @Override
        public byte[] vectorValue(int ord) throws IOException {
            return this.in.vectorValue(ord);
        }

        @Override
        public int ordToDoc(int ord) {
            return this.in.ordToDoc(ord);
        }

        @Override
        public KnnVectorValues.DocIndexIterator iterator() {
            return this.in.iterator();
        }
    }

    static class QuantizedFloatVectorValues
    extends QuantizedByteVectorValues {
        private final FloatVectorValues values;
        private final ScalarQuantizer quantizer;
        private final byte[] quantizedVector;
        private int lastOrd = -1;
        private float offsetValue = 0.0f;
        private final VectorSimilarityFunction vectorSimilarityFunction;

        public QuantizedFloatVectorValues(FloatVectorValues values, VectorSimilarityFunction vectorSimilarityFunction, ScalarQuantizer quantizer) {
            this.values = values;
            this.quantizer = quantizer;
            this.quantizedVector = new byte[values.dimension()];
            this.vectorSimilarityFunction = vectorSimilarityFunction;
        }

        @Override
        public float getScoreCorrectionConstant(int ord) {
            if (ord != this.lastOrd) {
                throw new IllegalStateException("attempt to retrieve score correction for different ord " + ord + " than the quantization was done for: " + this.lastOrd);
            }
            return this.offsetValue;
        }

        @Override
        public int dimension() {
            return this.values.dimension();
        }

        @Override
        public int size() {
            return this.values.size();
        }

        @Override
        public byte[] vectorValue(int ord) throws IOException {
            if (ord != this.lastOrd) {
                this.offsetValue = this.quantize(ord);
                this.lastOrd = ord;
            }
            return this.quantizedVector;
        }

        @Override
        public VectorScorer scorer(float[] target) throws IOException {
            throw new UnsupportedOperationException();
        }

        private float quantize(int ord) throws IOException {
            return this.quantizer.quantize(this.values.vectorValue(ord), this.quantizedVector, this.vectorSimilarityFunction);
        }

        @Override
        public int ordToDoc(int ord) {
            return this.values.ordToDoc(ord);
        }

        @Override
        public KnnVectorValues.DocIndexIterator iterator() {
            return this.values.iterator();
        }
    }

    static class QuantizedByteVectorValueSub
    extends DocIDMerger.Sub {
        private final QuantizedByteVectorValues values;
        private final KnnVectorValues.DocIndexIterator iterator;

        QuantizedByteVectorValueSub(MergeState.DocMap docMap, QuantizedByteVectorValues values) {
            super(docMap);
            this.values = values;
            this.iterator = values.iterator();
            assert (this.iterator.docID() == -1);
        }

        @Override
        public int nextDoc() throws IOException {
            return this.iterator.nextDoc();
        }

        public int index() {
            return this.iterator.index();
        }
    }

    static class FloatVectorWrapper
    extends FloatVectorValues {
        private final List<float[]> vectorList;

        FloatVectorWrapper(List<float[]> vectorList) {
            this.vectorList = vectorList;
        }

        @Override
        public int dimension() {
            return this.vectorList.get(0).length;
        }

        @Override
        public int size() {
            return this.vectorList.size();
        }

        @Override
        public FloatVectorValues copy() throws IOException {
            return this;
        }

        @Override
        public float[] vectorValue(int ord) throws IOException {
            if (ord < 0 || ord >= this.vectorList.size()) {
                throw new IOException("vector ord " + ord + " out of bounds");
            }
            return this.vectorList.get(ord);
        }

        @Override
        public KnnVectorValues.DocIndexIterator iterator() {
            return this.createDenseIterator();
        }
    }
}

