/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.viewsupport;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IEnumerator;
import org.eclipse.cdt.core.model.IField;
import org.eclipse.cdt.core.model.IFunctionDeclaration;
import org.eclipse.cdt.core.model.IMacro;
import org.eclipse.cdt.core.model.IMethodDeclaration;
import org.eclipse.cdt.core.model.ITypeDef;
import org.eclipse.cdt.core.model.IVariableDeclaration;
import org.eclipse.cdt.internal.core.model.CoreModelMessages;
import org.eclipse.cdt.internal.corext.util.Strings;
import org.eclipse.cdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.cdt.internal.ui.viewsupport.CElementLabelComposer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class CElementLabels {
    public static final long M_PARAMETER_TYPES = 1L;
    public static final long M_SIMPLE_NAME = 2L;
    public static final long M_EXCEPTIONS = 4L;
    public static final long M_APP_RETURNTYPE = 8L;
    public static final long M_PRE_RETURNTYPE = 16L;
    public static final long M_FULLY_QUALIFIED = 32L;
    public static final long M_POST_QUALIFIED = 64L;
    public static final long TEMPLATE_PARAMETERS = 128L;
    public static final long F_SIMPLE_NAME = 256L;
    public static final long F_APP_TYPE_SIGNATURE = 512L;
    public static final long F_PRE_TYPE_SIGNATURE = 1024L;
    public static final long F_FULLY_QUALIFIED = 2048L;
    public static final long F_POST_QUALIFIED = 4096L;
    public static final long T_FULLY_QUALIFIED = 8192L;
    public static final long TEMPLATE_ARGUMENTS = 16384L;
    public static final long T_INHERITANCE = 65536L;
    public static final long TU_QUALIFIED = 0x100000L;
    public static final long TU_POST_QUALIFIED = 0x200000L;
    public static final long ROOT_QUALIFIED = 0x2000000L;
    public static final long ROOT_POST_QUALIFIED = 0x4000000L;
    public static final long APPEND_ROOT_PATH = 0x8000000L;
    public static final long PREPEND_ROOT_PATH = 0x10000000L;
    public static final long PROJECT_POST_QUALIFIED = 0x40000000L;
    public static final long MF_POST_FILE_QUALIFIED = 0x80000000L;
    public static final long COLORIZE = 0x100000000L;
    public static final long ALL_FULLY_QUALIFIED = 34613280L;
    public static final long ALL_POST_QUALIFIED = 69210176L;
    public static final long ALL_DEFAULT = 1L;
    public static final long DEFAULT_QUALIFIED = 1058848L;
    public static final long DEFAULT_POST_QUALIFIED = 2101312L;
    public static final String CONCAT_STRING = CoreModelMessages.getString((String)"CElementLabels.concat_string");
    public static final String COMMA_STRING = CoreModelMessages.getString((String)"CElementLabels.comma_string");
    public static final String DECL_STRING = CoreModelMessages.getString((String)"CElementLabels.declseparator_string");

    private CElementLabels() {
    }

    public static String getTextLabel(Object obj, long flags) {
        IWorkbenchAdapter wbadapter;
        if (obj instanceof ICElement) {
            return CElementLabels.getElementLabel((ICElement)obj, flags);
        }
        if (obj instanceof IResource) {
            return BasicElementLabels.getResourceName((IResource)obj);
        }
        if (obj instanceof IStorage) {
            return BasicElementLabels.getResourceName(((IStorage)obj).getName());
        }
        if (obj instanceof IAdaptable && (wbadapter = (IWorkbenchAdapter)((IAdaptable)obj).getAdapter(IWorkbenchAdapter.class)) != null) {
            return Strings.markLTR(wbadapter.getLabel(obj));
        }
        return "";
    }

    public static StyledString getStyledTextLabel(Object obj, long flags) {
        IWorkbenchAdapter wbadapter;
        if (obj instanceof ICElement) {
            return CElementLabels.getStyledElementLabel((ICElement)obj, flags);
        }
        if (obj instanceof IResource) {
            return CElementLabels.getStyledResourceLabel((IResource)obj);
        }
        if (obj instanceof IStorage) {
            return CElementLabels.getStyledStorageLabel((IStorage)obj);
        }
        if (obj instanceof IAdaptable && (wbadapter = (IWorkbenchAdapter)((IAdaptable)obj).getAdapter(IWorkbenchAdapter.class)) != null) {
            return Strings.markLTR(new StyledString(wbadapter.getLabel(obj)));
        }
        return new StyledString();
    }

    private static StyledString getStyledResourceLabel(IResource resource) {
        StyledString result = new StyledString(resource.getName());
        return Strings.markLTR(result);
    }

    private static StyledString getStyledStorageLabel(IStorage storage) {
        StyledString result = new StyledString(storage.getName());
        return Strings.markLTR(result);
    }

    public static String getElementLabel(ICElement element, long flags) {
        StringBuilder result = new StringBuilder();
        CElementLabels.getElementLabel(element, flags, result);
        return Strings.markCElementLabelLTR(result.toString());
    }

    public static StyledString getStyledElementLabel(ICElement element, long flags) {
        StyledString result = new StyledString();
        CElementLabels.getElementLabel(element, flags, result);
        return Strings.markCElementLabelLTR(result);
    }

    public static void getElementLabel(ICElement element, long flags, StringBuilder buf) {
        new CElementLabelComposer(buf).appendElementLabel(element, flags);
    }

    public static void getElementLabel(ICElement element, long flags, StyledString result) {
        new CElementLabelComposer(result).appendElementLabel(element, flags);
    }

    public static void getMacroLabel(IMacro macro, int flags, StringBuilder buf) {
        new CElementLabelComposer(buf).appendMacroLabel(macro, flags);
    }

    public static void getMethodLabel(IMacro macro, long flags, StyledString result) {
        new CElementLabelComposer(result).appendMacroLabel(macro, flags);
    }

    public static void getMethodLabel(IMethodDeclaration method, int flags, StringBuilder buf) {
        new CElementLabelComposer(buf).appendMethodLabel(method, flags);
    }

    public static void getMethodLabel(IMethodDeclaration method, long flags, StyledString result) {
        new CElementLabelComposer(result).appendMethodLabel(method, flags);
    }

    public static void getFieldLabel(IField field, int flags, StringBuilder buf) {
        new CElementLabelComposer(buf).appendFieldLabel(field, flags);
    }

    public static void getFieldLabel(IField field, int flags, StyledString result) {
        new CElementLabelComposer(result).appendFieldLabel(field, flags);
    }

    public static void getVariableLabel(IVariableDeclaration var, int flags, StringBuilder buf) {
        new CElementLabelComposer(buf).appendVariableLabel(var, flags);
    }

    public static void getVariableLabel(IVariableDeclaration var, int flags, StyledString result) {
        new CElementLabelComposer(result).appendVariableLabel(var, flags);
    }

    public static void getEnumeratorLabel(IEnumerator var, int flags, StringBuilder buf) {
        new CElementLabelComposer(buf).appendEnumeratorLabel(var, flags);
    }

    public static void getEnumeratorLabel(IEnumerator var, int flags, StyledString result) {
        new CElementLabelComposer(result).appendEnumeratorLabel(var, flags);
    }

    public static void getFunctionLabel(IFunctionDeclaration func, int flags, StringBuilder buf) {
        new CElementLabelComposer(buf).appendFunctionLabel(func, flags);
    }

    public static void getFunctionLabel(IFunctionDeclaration func, int flags, StyledString result) {
        new CElementLabelComposer(result).appendFunctionLabel(func, flags);
    }

    public static void getTypeDefLabel(ITypeDef typedef, int flags, StringBuilder buf) {
        new CElementLabelComposer(buf).appendTypeDefLabel(typedef, flags);
    }

    public static void getTypeDefLabel(ITypeDef typedef, int flags, StyledString result) {
        new CElementLabelComposer(result).appendTypeDefLabel(typedef, flags);
    }
}

