/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.core.trace;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.jdt.annotation.Nullable;

public interface IKernelAnalysisEventLayout {
    public static final String INITIAL_SYSCALL_NAME = "clone";

    public String eventIrqHandlerEntry();

    public String eventIrqHandlerExit();

    public String eventSoftIrqEntry();

    public String eventSoftIrqExit();

    public String eventSoftIrqRaise();

    public String eventSchedSwitch();

    public String eventSchedPiSetprio();

    public Collection<String> eventsSchedWakeup();

    public String eventSchedProcessFork();

    public String eventSchedProcessExit();

    public String eventSchedProcessFree();

    public @Nullable String eventStatedumpProcessState();

    public String eventSyscallEntryPrefix();

    public String eventCompatSyscallEntryPrefix();

    public String eventSyscallExitPrefix();

    public String eventCompatSyscallExitPrefix();

    public String eventSchedProcessExec();

    public String eventSchedProcessWakeup();

    public String eventSchedProcessWakeupNew();

    default public String eventSchedProcessWaking() {
        return "sched_waking";
    }

    default public String eventSchedMigrateTask() {
        return "sched_migrate_task";
    }

    public String eventHRTimerStart();

    public String eventHRTimerCancel();

    public String eventHRTimerExpireEntry();

    public String eventHRTimerExpireExit();

    public String eventKmemPageAlloc();

    public String eventKmemPageFree();

    default public Collection<String> getIPIIrqVectorsEntries() {
        return Collections.emptyList();
    }

    default public Collection<String> getIPIIrqVectorsExits() {
        return Collections.emptyList();
    }

    public String fieldIrq();

    public String fieldVec();

    public String fieldTid();

    public String fieldPrevTid();

    public String fieldPrevState();

    public String fieldNextComm();

    public String fieldNextTid();

    public String fieldChildComm();

    public String fieldParentTid();

    public String fieldChildTid();

    default public String fieldChildPid() {
        return "child_pid";
    }

    public String fieldComm();

    public String fieldName();

    public String fieldStatus();

    public String fieldPrevComm();

    public String fieldFilename();

    public String fieldPrio();

    public String fieldNewPrio();

    public String fieldPrevPrio();

    public String fieldNextPrio();

    public String fieldHRtimer();

    public String fieldHRtimerExpires();

    public String fieldHRtimerSoftexpires();

    public String fieldHRtimerFunction();

    public String fieldHRtimerNow();

    default public String fieldSyscallRet() {
        return "ret";
    }

    default public String fieldTargetCpu() {
        return "target_cpu";
    }

    default public String fieldDestCpu() {
        return "dest_cpu";
    }

    default public String eventBlockRqInsert() {
        return "block_rq_insert";
    }

    default public String eventBlockRqIssue() {
        return "block_rq_issue";
    }

    default public String eventBlockRqComplete() {
        return "block_rq_complete";
    }

    default public String eventBlockBioFrontmerge() {
        return "block_bio_frontmerge";
    }

    default public String eventBlockBioBackmerge() {
        return "block_bio_backmerge";
    }

    default public String eventBlockRqMerge() {
        return "block_rq_merge";
    }

    default public @Nullable String eventStatedumpBlockDevice() {
        return null;
    }

    default public String fieldBlockDeviceId() {
        return "dev";
    }

    default public String fieldBlockSector() {
        return "sector";
    }

    default public String fieldBlockNrSector() {
        return "nr_sector";
    }

    default public String fieldBlockRwbs() {
        return "rwbs";
    }

    default public String fieldBlockRqSector() {
        return "rq_sector";
    }

    default public String fieldBlockNextRqSector() {
        return "nextrq_sector";
    }

    default public String fieldDiskname() {
        return "diskname";
    }

    default public @Nullable String eventStatedumpFileDescriptor() {
        return null;
    }

    default public String fieldIPIVector() {
        return "vector";
    }

    default public @Nullable String fieldOrder() {
        return null;
    }

    default public Collection<String> eventsNetworkSend() {
        return Collections.emptySet();
    }

    default public Collection<String> eventsNetworkReceive() {
        return Collections.emptySet();
    }

    default public String[] fieldPathTcpSeq() {
        return new String[]{"seq"};
    }

    default public String[] fieldPathTcpAckSeq() {
        return new String[]{"ack_seq"};
    }

    default public String[] fieldPathTcpFlags() {
        return new String[]{"flags"};
    }

    default public Collection<String> eventsKVMEntry() {
        return Collections.emptySet();
    }

    default public Collection<String> eventsKVMExit() {
        return Collections.emptySet();
    }

    default public String eventCpuFrequency() {
        return "power_cpu_frequency";
    }

    default public String eventIrqEntry() {
        return "do_IRQ_entry";
    }

    default public String eventIrqExit() {
        return "do_IRQ_return";
    }

    default public Collection<String> eventsNetworkReceiveEntry() {
        return Collections.emptySet();
    }

    default public Collection<String> eventsNetworkReceiveExit() {
        return Collections.emptySet();
    }
}

