/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.wizard.project;

import java.io.File;
import java.util.List;
import org.eclipse.buildship.core.internal.util.file.FileUtils;
import org.eclipse.buildship.core.internal.workspace.NewProjectHandler;
import org.eclipse.buildship.ui.internal.UiPlugin;
import org.eclipse.buildship.ui.internal.util.workbench.WorkingSetUtils;
import org.eclipse.buildship.ui.internal.wizard.project.AbstractProjectWizard;
import org.eclipse.buildship.ui.internal.wizard.project.GradleOptionsWizardPage;
import org.eclipse.buildship.ui.internal.wizard.project.NewGradleProjectWizardPage;
import org.eclipse.buildship.ui.internal.wizard.project.ProjectCreationConfiguration;
import org.eclipse.buildship.ui.internal.wizard.project.ProjectCreationWizardController;
import org.eclipse.buildship.ui.internal.wizard.project.ProjectImportConfiguration;
import org.eclipse.buildship.ui.internal.wizard.project.ProjectImportWizardController;
import org.eclipse.buildship.ui.internal.wizard.project.ProjectPreviewWizardPage;
import org.eclipse.buildship.ui.internal.wizard.project.ProjectWizardMessages;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IPageChangeProvider;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public final class ProjectCreationWizard
extends AbstractProjectWizard
implements INewWizard {
    private static final String PROJECT_CREATION_DIALOG_SETTINGS = "org.eclipse.buildship.ui.wizard.project.creation";
    private final NewGradleProjectWizardPage newGradleProjectPage;
    private final GradleOptionsWizardPage gradleOptionsPage;
    private final ProjectPreviewWizardPage projectPreviewPage;
    private final ProjectImportWizardController importController;
    private final ProjectCreationWizardController creationController;
    private final IPageChangedListener pageChangeListener;

    public ProjectCreationWizard() {
        this(ProjectCreationWizard.getOrCreateDialogSection(UiPlugin.getInstance().getDialogSettings()));
    }

    public ProjectCreationWizard(IDialogSettings dialogSettings) {
        this.setDialogSettings(dialogSettings);
        this.importController = new ProjectImportWizardController((IWizard)this);
        this.creationController = new ProjectCreationWizardController(this);
        this.pageChangeListener = new ProjectCreatingPageChangedListener(this);
        ProjectImportConfiguration importConfiguration = this.importController.getConfiguration();
        ProjectCreationConfiguration creationConfiguration = this.creationController.getConfiguration();
        this.newGradleProjectPage = new NewGradleProjectWizardPage(importConfiguration, creationConfiguration);
        this.gradleOptionsPage = new GradleOptionsWizardPage(importConfiguration, ProjectWizardMessages.Title_NewGradleProjectOptionsWizardPage, ProjectWizardMessages.InfoMessage_NewGradleProjectOptionsWizardPageDefault);
        this.projectPreviewPage = new ProjectPreviewWizardPage(importConfiguration, ProjectWizardMessages.Title_NewGradleProjectPreviewWizardPage, ProjectWizardMessages.InfoMessage_NewGradleProjectPreviewWizardPageDefault);
    }

    public void setContainer(IWizardContainer wizardContainer) {
        if (wizardContainer instanceof IPageChangeProvider) {
            IPageChangeProvider pageChangeProvider = (IPageChangeProvider)wizardContainer;
            pageChangeProvider.addPageChangedListener(this.pageChangeListener);
        }
        super.setContainer(wizardContainer);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        List<String> workingSetNames = WorkingSetUtils.getSelectedWorkingSetNames(selection);
        if (!workingSetNames.isEmpty()) {
            this.importController.getConfiguration().setApplyWorkingSets(true);
            this.importController.getConfiguration().setWorkingSets(workingSetNames);
        }
    }

    public String getWindowTitle() {
        return ProjectWizardMessages.Title_NewGradleProjectWizardPage;
    }

    public void addPages() {
        this.addPage((IWizardPage)this.newGradleProjectPage);
        this.addPage((IWizardPage)this.gradleOptionsPage);
        this.addPage((IWizardPage)this.projectPreviewPage);
        this.setNeedsProgressMonitor(true);
        this.setHelpAvailable(false);
    }

    public boolean performFinish() {
        return this.importController.performImportProject(this.getContainer(), NewProjectHandler.IMPORT_AND_MERGE);
    }

    public boolean performCancel() {
        File projectDir;
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        if (((Object)((Object)this.projectPreviewPage)).equals(currentPage) && (projectDir = (File)this.importController.getConfiguration().getProjectDir().getValue()) != null) {
            FileUtils.deleteRecursively((File)projectDir);
        }
        return true;
    }

    @Override
    public String getHelpContextId() {
        return "org.eclipse.buildship.ui.projectcreation";
    }

    public void dispose() {
        if (this.getContainer() instanceof IPageChangeProvider) {
            IPageChangeProvider pageChangeProvider = (IPageChangeProvider)this.getContainer();
            pageChangeProvider.removePageChangedListener(this.pageChangeListener);
        }
        super.dispose();
    }

    private static IDialogSettings getOrCreateDialogSection(IDialogSettings dialogSettings) {
        IDialogSettings section = dialogSettings.getSection(PROJECT_CREATION_DIALOG_SETTINGS);
        if (section == null) {
            section = dialogSettings.addNewSection(PROJECT_CREATION_DIALOG_SETTINGS);
        }
        return section;
    }

    private static final class ProjectCreatingPageChangedListener
    implements IPageChangedListener {
        private final ProjectCreationWizard projectCreationWizard;
        private IWizardPage previousPage;

        private ProjectCreatingPageChangedListener(ProjectCreationWizard projectCreationWizard) {
            this.projectCreationWizard = projectCreationWizard;
            this.previousPage = projectCreationWizard.newGradleProjectPage;
        }

        public void pageChanged(PageChangedEvent event) {
            File projectDir;
            if (((Object)((Object)this.projectCreationWizard.projectPreviewPage)).equals(this.previousPage) && ((Object)((Object)this.projectCreationWizard.gradleOptionsPage)).equals(event.getSelectedPage()) && (projectDir = (File)this.projectCreationWizard.importController.getConfiguration().getProjectDir().getValue()) != null) {
                FileUtils.deleteRecursively((File)projectDir);
                this.projectCreationWizard.newGradleProjectPage.setPageComplete(this.projectCreationWizard.newGradleProjectPage.isPageComplete());
            }
            this.previousPage = (IWizardPage)event.getSelectedPage();
        }
    }
}

