/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.commands;

import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.xml.core.internal.contentmodel.util.NamespaceTable;
import org.eclipse.wst.xsd.ui.internal.common.commands.AddExtensionCommand;
import org.eclipse.wst.xsd.ui.internal.common.util.XSDCommonUIUtils;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDSchema;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ExtensibleAddExtensionCommand
extends AddExtensionCommand {
    protected XSDElementDeclaration element;
    protected Element appInfo;
    protected Element newElement;

    public ExtensibleAddExtensionCommand(String label) {
        super(label);
    }

    public XSDElementDeclaration getXSDElementDeclarationElement() {
        return this.element;
    }

    public Element getNewElement() {
        return this.newElement;
    }

    public Element getAppInfo() {
        return this.appInfo;
    }

    public XSDSchema getXSDSchema() {
        return this.component.getSchema();
    }

    public void setInputs(XSDConcreteComponent input, XSDElementDeclaration element) {
        this.component = input;
        this.element = element;
    }

    public XSDAnnotation getXSDAnnotation() {
        if (this.component != null) {
            XSDAnnotation xsdAnnotation = XSDCommonUIUtils.getInputXSDAnnotation(this.component, false);
            return xsdAnnotation;
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() {
        try {
            this.beginRecording(this.component.getElement());
            super.execute();
            this.doPreprocessing();
            this.addExtensionNode();
            this.doCustomizedActions();
            this.formatChild(this.component.getElement());
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.endRecording();
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        this.endRecording();
    }

    protected void doPreprocessing() {
    }

    protected void addExtensionNode() {
        XSDAnnotation xsdAnnotation = XSDCommonUIUtils.getInputXSDAnnotation(this.component, true);
        XSDSchema schema = xsdAnnotation.getSchema();
        Element schemaElement = schema.getElement();
        if (xsdAnnotation.getApplicationInformation().size() == 0) {
            this.appInfo = xsdAnnotation.createApplicationInformation(null);
            xsdAnnotation.getElement().appendChild(this.appInfo);
            EList appInfos = xsdAnnotation.getApplicationInformation();
            appInfos.add(this.appInfo);
        } else {
            this.appInfo = (Element)xsdAnnotation.getApplicationInformation().get(0);
        }
        if (this.appInfo != null) {
            Document doc = this.appInfo.getOwnerDocument();
            String prefix = this.addToNamespaceTable(schemaElement);
            this.newElement = doc.createElementNS(this.extensionsSchemaSpec.getNamespaceURI(), this.element.getName());
            this.newElement.setPrefix(prefix);
            this.appInfo.appendChild(this.newElement);
            xsdAnnotation.updateElement();
        }
    }

    protected String addToNamespaceTable(Element schemaElement) {
        String prefix = this.addNamespaceDeclarationIfRequired(schemaElement, "p", this.extensionsSchemaSpec.getNamespaceURI());
        return prefix;
    }

    protected void doCustomizedActions() {
    }

    public void undo() {
        super.undo();
    }

    public Object getNewObject() {
        return this.newElement;
    }

    protected String addNamespaceDeclarationIfRequired(Element schemaElement, String prefixHint, String namespace) {
        String prefix = null;
        NamespaceTable namespaceTable = new NamespaceTable(schemaElement.getOwnerDocument());
        namespaceTable.addElement(schemaElement);
        prefix = namespaceTable.getPrefixForURI(namespace);
        if (prefix == null) {
            String basePrefix;
            prefix = basePrefix = prefixHint;
            String xmlnsColon = "xmlns:";
            String attributeName = String.valueOf(xmlnsColon) + prefix;
            int count = 0;
            while (schemaElement.hasAttribute(attributeName)) {
                prefix = String.valueOf(basePrefix) + ++count;
                attributeName = String.valueOf(xmlnsColon) + prefix;
            }
            schemaElement.setAttribute(attributeName, namespace);
        }
        return prefix;
    }

    protected void addSchemaAttribute(Element schemaElement, String namespace, String attributeName, String attributeValue) {
        String prefix = null;
        NamespaceTable namespaceTable = new NamespaceTable(schemaElement.getOwnerDocument());
        namespaceTable.addElement(schemaElement);
        prefix = namespaceTable.getPrefixForURI(namespace);
        try {
            if (prefix != null) {
                if (schemaElement.getAttributeNode(String.valueOf(prefix) + ":" + attributeName) == null) {
                    schemaElement.setAttribute(String.valueOf(prefix) + ":" + attributeName, attributeValue);
                }
            } else if (schemaElement.getAttributeNode(attributeName) == null) {
                schemaElement.setAttribute(attributeName, attributeValue);
            }
        }
        catch (Exception exception) {}
    }

    protected void addSourceAttributeToAppInfo(String namespace) {
        if (this.appInfo.getAttributeNode("source") == null) {
            this.appInfo.setAttribute("source", namespace);
        }
    }

    protected void addAttribute(Element element, String attributeName, String attributeValue) {
        element.setAttribute(attributeName, attributeValue);
    }
}

