/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services.format;

import java.util.List;
import org.eclipse.lemminx.dom.DOMText;
import org.eclipse.lemminx.services.format.FormatElementCategory;
import org.eclipse.lemminx.services.format.XMLFormatterDocument;
import org.eclipse.lemminx.services.format.XMLFormattingConstraints;
import org.eclipse.lsp4j.TextEdit;

public class DOMTextFormatter {
    private final XMLFormatterDocument formatterDocument;

    public DOMTextFormatter(XMLFormatterDocument formatterDocument) {
        this.formatterDocument = formatterDocument;
    }

    public void formatText(DOMText textNode, XMLFormattingConstraints parentConstraints, int start, int end, List<TextEdit> edits) {
        if (textNode.getStart() > end && end != -1 || textNode.getEnd() < start) {
            return;
        }
        FormatElementCategory formatElementCategory = parentConstraints.getFormatElementCategory();
        if (formatElementCategory == FormatElementCategory.PreserveSpace && this.isTrimTrailingWhitespace()) {
            int i;
            String text = this.formatterDocument.getText();
            char curr = text.charAt(i);
            boolean removeSpaces = true;
            int lineSeparatorOffset = i + 1;
            for (i = text.length() - 1; i >= 0; --i) {
                curr = text.charAt(i);
                if (DOMTextFormatter.isLineSeparator(curr)) {
                    if (removeSpaces && textNode.getEnd() > lineSeparatorOffset) {
                        this.removeLeftSpaces(i + 1, lineSeparatorOffset, edits);
                    }
                    removeSpaces = true;
                    lineSeparatorOffset = i;
                    continue;
                }
                if (!removeSpaces || Character.isWhitespace(curr) && !DOMTextFormatter.isLineSeparator(curr) || textNode.getEnd() <= lineSeparatorOffset) continue;
                this.removeLeftSpaces(i, lineSeparatorOffset, edits);
                removeSpaces = false;
            }
            return;
        }
        if (formatElementCategory == FormatElementCategory.PreserveSpace) {
            return;
        }
        String text = this.formatterDocument.getText();
        int availableLineWidth = parentConstraints.getAvailableLineWidth();
        int indentLevel = parentConstraints.getIndentLevel();
        boolean isMixedContent = formatElementCategory == FormatElementCategory.MixedContent;
        int spaceStart = -1;
        int spaceEnd = -1;
        int lineSeparatorOffset = -1;
        boolean containsNewLine = false;
        int textStart = textNode.getStart();
        int textEnd = textNode.getEnd();
        for (int i = textStart; i < textEnd; ++i) {
            char c = text.charAt(i);
            if (Character.isWhitespace(c)) {
                if (DOMTextFormatter.isLineSeparator(c)) {
                    if (!containsNewLine) {
                        lineSeparatorOffset = i;
                    }
                    containsNewLine = true;
                }
                if (spaceStart == -1) {
                    spaceStart = i;
                    continue;
                }
                spaceEnd = i;
                continue;
            }
            spaceEnd = i;
            int contentStart = i;
            while (i + 1 < textEnd && !Character.isWhitespace(text.charAt(i + 1))) {
                ++i;
            }
            int contentEnd = i + 1;
            if (this.isMaxLineWidthSupported()) {
                int maxLineWidth = this.getMaxLineWidth();
                if (textStart != contentStart && (availableLineWidth -= contentEnd - contentStart) >= 0 && (this.isJoinContentLines() || !containsNewLine || isMixedContent)) {
                    --availableLineWidth;
                }
                if (availableLineWidth < 0 && spaceStart != -1) {
                    int mixedContentIndentLevel = parentConstraints.getMixedContentIndentLevel() == 0 ? indentLevel : parentConstraints.getMixedContentIndentLevel();
                    this.replaceLeftSpacesWithIndentation(mixedContentIndentLevel, spaceStart, contentStart, true, edits);
                    availableLineWidth = maxLineWidth - (contentEnd - contentStart) - mixedContentIndentLevel * this.getTabSize();
                    containsNewLine = false;
                    spaceStart = -1;
                    spaceEnd = -1;
                    continue;
                }
                if (containsNewLine && !this.isJoinContentLines() && !isMixedContent) {
                    availableLineWidth = maxLineWidth - (contentEnd - contentStart) - indentLevel * this.getTabSize();
                }
            }
            if (containsNewLine && !this.isJoinContentLines() && !isMixedContent) {
                this.replaceLeftSpacesWithIndentationPreservedNewLines(spaceStart, spaceEnd, indentLevel, edits);
                containsNewLine = false;
            } else if (this.isJoinContentLines() || !containsNewLine || isMixedContent) {
                this.replaceSpacesWithOneSpace(spaceStart, spaceEnd - 1, edits);
                containsNewLine = false;
            }
            spaceStart = -1;
            spaceEnd = -1;
        }
        if (formatElementCategory != FormatElementCategory.IgnoreSpace && spaceEnd + 1 != text.length()) {
            if (!(containsNewLine && !this.isJoinContentLines() && !isMixedContent || this.isMaxLineWidthSupported() && availableLineWidth < 0)) {
                this.replaceSpacesWithOneSpace(spaceStart, spaceEnd, edits);
                if (this.isMaxLineWidthSupported() && spaceStart != -1) {
                    --availableLineWidth;
                }
            } else if (this.isMaxLineWidthSupported() && availableLineWidth < 0 && !Character.isWhitespace(text.charAt(textStart))) {
                int mixedContentIndentLevel = parentConstraints.getMixedContentIndentLevel() == 0 ? indentLevel : parentConstraints.getMixedContentIndentLevel();
                this.replaceLeftSpacesWithIndentationPreservedNewLines(textStart, textStart, mixedContentIndentLevel, edits);
                availableLineWidth = this.getMaxLineWidth() - (textEnd - textStart) - mixedContentIndentLevel * this.getTabSize();
            } else {
                if (formatElementCategory == FormatElementCategory.NormalizeSpace) {
                    --indentLevel;
                }
                this.replaceLeftSpacesWithIndentationPreservedNewLines(spaceStart, spaceEnd + 1, indentLevel, edits);
                if (this.isMaxLineWidthSupported()) {
                    availableLineWidth = this.getMaxLineWidth() - (textEnd - textStart) - indentLevel * this.getTabSize();
                }
            }
        } else if (this.isTrimTrailingWhitespace()) {
            this.removeLeftSpaces(spaceStart, lineSeparatorOffset, edits);
        }
        if (this.isMaxLineWidthSupported()) {
            parentConstraints.setAvailableLineWidth(availableLineWidth);
        }
    }

    private static boolean isLineSeparator(char c) {
        return c == '\r' || c == '\n';
    }

    private int getMaxLineWidth() {
        return this.formatterDocument.getMaxLineWidth();
    }

    private int getTabSize() {
        return this.formatterDocument.getSharedSettings().getFormattingSettings().getTabSize();
    }

    private void replaceSpacesWithOneSpace(int spaceStart, int spaceEnd, List<TextEdit> edits) {
        this.formatterDocument.replaceSpacesWithOneSpace(spaceStart, spaceEnd, edits);
    }

    private int replaceLeftSpacesWithIndentation(int indentLevel, int from, int to, boolean addLineSeparator, List<TextEdit> edits) {
        return this.formatterDocument.replaceLeftSpacesWithIndentation(indentLevel, from, to, addLineSeparator, edits);
    }

    private void replaceLeftSpacesWithIndentationPreservedNewLines(int spaceStart, int spaceEnd, int indentLevel, List<TextEdit> edits) {
        this.formatterDocument.replaceLeftSpacesWithIndentationPreservedNewLines(spaceStart, spaceEnd, indentLevel, edits);
    }

    private void removeLeftSpaces(int leftLimit, int to, List<TextEdit> edits) {
        this.formatterDocument.replaceLeftSpacesWith(leftLimit, to, "", edits);
    }

    private boolean isJoinContentLines() {
        return this.formatterDocument.getSharedSettings().getFormattingSettings().isJoinContentLines();
    }

    private boolean isTrimTrailingWhitespace() {
        return this.formatterDocument.getSharedSettings().getFormattingSettings().isTrimTrailingWhitespace();
    }

    private boolean isMaxLineWidthSupported() {
        return this.formatterDocument.isMaxLineWidthSupported();
    }
}

