/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.encoding.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.sse.core.internal.encoding.EncodingMemento;
import org.eclipse.wst.sse.core.internal.encoding.IResourceCharsetDetector;
import org.eclipse.wst.sse.core.internal.encoding.util.ByteReader;

public class UnicodeBOMEncodingDetector
implements IResourceCharsetDetector {
    private static final byte BB = -69;
    private static final byte BF = -65;
    private static final byte EF = -17;
    private static final byte FE = -2;
    private static final byte FF = -1;
    private static final String UTF_16BE_CHARSET_NAME = "UTF-16BE";
    private static final String UTF_16LE_CHARSET_NAME = "UTF-16LE";
    private static final String UTF_8_CHARSET_NAME = "UTF-8";
    private InputStream fInputStream = null;
    private boolean fNoBOMPossible;

    private EncodingMemento checkForBOM(InputStream inputStream) {
        EncodingMemento result = null;
        try {
            byte b1 = this.getNextByte(inputStream);
            byte b2 = this.getNextByte(inputStream);
            if (b1 == -2 && b2 == -1) {
                result = this.createEncodingMemento(UTF_16BE_CHARSET_NAME);
                result.setUnicodeStream(true);
            } else if (b1 == -1 && b2 == -2) {
                result = this.createEncodingMemento(UTF_16LE_CHARSET_NAME);
                result.setUnicodeStream(true);
            } else {
                byte b3 = this.getNextByte(inputStream);
                if (b1 == -17 && b2 == -69 && b3 == -65) {
                    result = this.createEncodingMemento(UTF_8_CHARSET_NAME);
                    result.setUTF83ByteBOMUsed(true);
                }
            }
        }
        catch (NotEnoughInputForBOMException notEnoughInputForBOMException) {
            result = null;
        }
        catch (IOException e) {
            throw new Error(e);
        }
        return result;
    }

    private EncodingMemento createEncodingMemento(String javaEncodingName) {
        EncodingMemento encodingMemento = new EncodingMemento();
        encodingMemento.setJavaCharsetName(javaEncodingName);
        String ianaName = Charset.forName(javaEncodingName).name();
        encodingMemento.setDetectedCharsetName(ianaName);
        if (javaEncodingName.equals(UTF_8_CHARSET_NAME)) {
            encodingMemento.setUTF83ByteBOMUsed(true);
        }
        return encodingMemento;
    }

    @Override
    public String getEncoding() throws IOException {
        return this.getEncodingMemento().getDetectedCharsetName();
    }

    public EncodingMemento getEncodingMemento() {
        EncodingMemento result = null;
        if (!this.fNoBOMPossible) {
            if (this.fInputStream == null) {
                throw new IllegalStateException("input must be set before use");
            }
            if (!this.fInputStream.markSupported()) {
                throw new IllegalArgumentException("inputStream must be resetable");
            }
            result = this.checkForBOM(this.fInputStream);
        }
        return result;
    }

    private byte getNextByte(InputStream inputStream) throws IOException {
        int byteCharAsInt = -1;
        if (inputStream.available() > 0) {
            byteCharAsInt = inputStream.read();
            byteCharAsInt &= 0xFF;
        }
        if (byteCharAsInt == -1) {
            throw new NotEnoughInputForBOMException("typically not an error");
        }
        return (byte)byteCharAsInt;
    }

    @Override
    public String getSpecDefaultEncoding() {
        return null;
    }

    private void resetAll() {
        this.fNoBOMPossible = false;
        this.fInputStream = null;
    }

    @Override
    public void set(InputStream inputStream) {
        this.resetAll();
        this.fInputStream = inputStream;
    }

    @Override
    public void set(IStorage iStorage) throws CoreException {
        this.set(new BufferedInputStream(iStorage.getContents(), 8192));
    }

    @Override
    public void set(Reader reader) {
        if (reader instanceof ByteReader) {
            ByteReader byteReader = (ByteReader)reader;
            this.fInputStream = byteReader.fInputStream;
        } else {
            this.fNoBOMPossible = true;
        }
    }

    public static class NotEnoughInputForBOMException
    extends IOException {
        private static final long serialVersionUID = 1L;

        public NotEnoughInputForBOMException() {
        }

        public NotEnoughInputForBOMException(String s) {
            super(s);
        }
    }
}

