/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.ui.viewmodel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.internal.DsfPlugin;
import org.eclipse.cdt.dsf.internal.LoggingUtils;
import org.eclipse.cdt.dsf.internal.ui.DsfUIPlugin;
import org.eclipse.cdt.dsf.ui.concurrent.SimpleDisplayExecutor;
import org.eclipse.cdt.dsf.ui.concurrent.ViewerDataRequestMonitor;
import org.eclipse.cdt.dsf.ui.viewmodel.AbstractVMAdapter;
import org.eclipse.cdt.dsf.ui.viewmodel.DefaultVMContentProviderStrategy;
import org.eclipse.cdt.dsf.ui.viewmodel.DefaultVMModelProxyStrategy;
import org.eclipse.cdt.dsf.ui.viewmodel.IRootVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMEventListener;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMModelProxy;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.ModelProxyInstalledEvent;
import org.eclipse.cdt.dsf.ui.viewmodel.VMChildrenCountUpdate;
import org.eclipse.cdt.dsf.ui.viewmodel.VMChildrenUpdate;
import org.eclipse.cdt.dsf.ui.viewmodel.VMHasChildrenUpdate;
import org.eclipse.cdt.dsf.ui.viewmodel.update.UserEditEvent;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IColumnPresentation;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerInputUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractVMProvider
implements IVMProvider,
IVMEventListener {
    public static String DEBUG_PRESENTATION_ID = null;
    public static boolean DEBUG_CONTENT_PROVIDER = false;
    public static boolean DEBUG_DELTA = false;
    private final AbstractVMAdapter fVMAdapter;
    private final IPresentationContext fPresentationContext;
    private final Executor fExecutor = SimpleDisplayExecutor.getSimpleDisplayExecutor(Display.getDefault());
    private final IElementContentProvider fContentStrategy;
    private List<IVMModelProxy> fActiveModelProxies = new LinkedList<IVMModelProxy>();
    private static final IVMNode[] EMPTY_NODES_ARRAY;
    private Map<IVMNode, IVMNode[]> fChildNodesMap = new HashMap<IVMNode, IVMNode[]>();
    private IVMNode[] fNodesListCache = null;
    private boolean fDisposed = false;
    private IRootVMNode fRootNode;
    private Map<IVMModelProxy, ModelProxyEventQueue> fProxyEventQueues = new HashMap<IVMModelProxy, ModelProxyEventQueue>();

    static {
        DEBUG_PRESENTATION_ID = Platform.getDebugOption((String)"org.eclipse.cdt.dsf.ui/debug/vm/presentationId");
        if (!DsfUIPlugin.DEBUG || "".equals(DEBUG_PRESENTATION_ID)) {
            DEBUG_PRESENTATION_ID = null;
        }
        DEBUG_CONTENT_PROVIDER = DsfUIPlugin.DEBUG && Boolean.parseBoolean(Platform.getDebugOption((String)"org.eclipse.cdt.dsf.ui/debug/vm/contentProvider"));
        DEBUG_DELTA = DsfUIPlugin.DEBUG && Boolean.parseBoolean(Platform.getDebugOption((String)"org.eclipse.cdt.dsf.ui/debug/vm/delta"));
        EMPTY_NODES_ARRAY = new IVMNode[0];
    }

    public AbstractVMProvider(AbstractVMAdapter adapter, IPresentationContext presentationContext) {
        this.fVMAdapter = adapter;
        this.fPresentationContext = presentationContext;
        this.fContentStrategy = this.createContentStrategy();
    }

    @Override
    public IPresentationContext getPresentationContext() {
        return this.fPresentationContext;
    }

    @Override
    public AbstractVMAdapter getVMAdapter() {
        return this.fVMAdapter;
    }

    protected IElementContentProvider createContentStrategy() {
        return new DefaultVMContentProviderStrategy(this);
    }

    protected IElementContentProvider getContentStrategy() {
        return this.fContentStrategy;
    }

    protected IVMModelProxy createModelProxyStrategy(Object rootElement) {
        return new DefaultVMModelProxyStrategy(this, rootElement);
    }

    protected List<IVMModelProxy> getActiveModelProxies() {
        return this.fActiveModelProxies;
    }

    public void handleEvent(Object event) {
        this.handleEvent(event, null);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void handleEvent(Object event, RequestMonitor rm) {
        if (AbstractVMProvider.DEBUG_DELTA && (AbstractVMProvider.DEBUG_PRESENTATION_ID == null || this.getPresentationContext().getId().equals(AbstractVMProvider.DEBUG_PRESENTATION_ID))) {
            this.trace(event, null, null, EventHandlerAction.received);
        }
        crm = new CountingRequestMonitor(this.getExecutor(), rm);
        activeModelProxies = new ArrayList<IVMModelProxy>(this.getActiveModelProxies());
        crm.setDoneCount(activeModelProxies.size());
        for (IVMModelProxy proxyStrategy : activeModelProxies) {
            block10: {
                block11: {
                    if (event instanceof ModelProxyInstalledEvent && !((ModelProxyInstalledEvent)event).getModelProxy().equals(proxyStrategy)) {
                        crm.done();
                        continue;
                    }
                    if (!proxyStrategy.isDeltaEvent(event) && !(event instanceof UserEditEvent)) break block10;
                    if (!this.fProxyEventQueues.containsKey(proxyStrategy)) {
                        this.fProxyEventQueues.put(proxyStrategy, new ModelProxyEventQueue());
                    }
                    queue = this.fProxyEventQueues.get(proxyStrategy);
                    if (queue.fCurrentEvent == null) break block11;
                    if (AbstractVMProvider.$assertionsDisabled || queue.fCurrentRm != null) ** GOTO lbl25
                    throw new AssertionError();
lbl-1000:
                    // 1 sources

                    {
                        eventToSkipInfo = queue.fEventQueue.get(queue.fEventQueue.size() - 1);
                        if (!this.canSkipHandlingEvent(event, eventToSkipInfo.fEvent)) break;
                        if (AbstractVMProvider.DEBUG_DELTA && (AbstractVMProvider.DEBUG_PRESENTATION_ID == null || this.getPresentationContext().getId().equals(AbstractVMProvider.DEBUG_PRESENTATION_ID))) {
                            this.trace(event, eventToSkipInfo.fEvent, proxyStrategy, EventHandlerAction.skipped);
                        }
                        queue.fEventQueue.remove(queue.fEventQueue.size() - 1);
                        eventToSkipInfo.fClientRm.done();
lbl25:
                        // 2 sources

                        ** while (!queue.fEventQueue.isEmpty())
                    }
lbl26:
                    // 2 sources

                    if (queue.fEventQueue.isEmpty() && this.canSkipHandlingEvent(event, queue.fCurrentEvent.fEvent)) {
                        if (AbstractVMProvider.DEBUG_DELTA && (AbstractVMProvider.DEBUG_PRESENTATION_ID == null || this.getPresentationContext().getId().equals(AbstractVMProvider.DEBUG_PRESENTATION_ID))) {
                            this.trace(event, queue.fCurrentEvent.fEvent, proxyStrategy, EventHandlerAction.canceled);
                        }
                        queue.fCurrentRm.cancel();
                    }
                    if (AbstractVMProvider.DEBUG_DELTA && (AbstractVMProvider.DEBUG_PRESENTATION_ID == null || this.getPresentationContext().getId().equals(AbstractVMProvider.DEBUG_PRESENTATION_ID))) {
                        this.trace(event, null, proxyStrategy, EventHandlerAction.queued);
                    }
                    queue.fEventQueue.add(new EventInfo(event, (RequestMonitor)crm));
                    continue;
                }
                this.doHandleEvent(queue, proxyStrategy, new EventInfo(event, (RequestMonitor)crm));
                continue;
            }
            crm.done();
        }
        activeProxies = this.getActiveModelProxies();
        itr = this.fProxyEventQueues.keySet().iterator();
        while (itr.hasNext()) {
            if (activeProxies.contains(itr.next())) continue;
            itr.remove();
        }
    }

    private void doHandleEvent(final ModelProxyEventQueue queue, final IVMModelProxy proxyStrategy, final EventInfo eventInfo) {
        assert (queue.fCurrentEvent == null && queue.fCurrentRm == null);
        queue.fCurrentEvent = eventInfo;
        queue.fCurrentRm = new RequestMonitor(this.getExecutor(), eventInfo.fClientRm){

            protected void handleCompleted() {
                eventInfo.fClientRm.done();
                queue.fCurrentEvent = null;
                queue.fCurrentRm = null;
                if (!queue.fEventQueue.isEmpty() && !AbstractVMProvider.this.fDisposed) {
                    EventInfo nextEventInfo = queue.fEventQueue.remove(0);
                    AbstractVMProvider.this.doHandleEvent(queue, proxyStrategy, nextEventInfo);
                }
            }
        };
        this.handleEvent(proxyStrategy, eventInfo.fEvent, queue.fCurrentRm);
    }

    protected void handleEvent(final IVMModelProxy proxyStrategy, final Object event, final RequestMonitor rm) {
        if (!proxyStrategy.isDisposed()) {
            if (DEBUG_DELTA && (DEBUG_PRESENTATION_ID == null || this.getPresentationContext().getId().equals(DEBUG_PRESENTATION_ID))) {
                this.trace(event, null, proxyStrategy, EventHandlerAction.processing);
            }
            proxyStrategy.createDelta(event, new DataRequestMonitor<IModelDelta>(this.getExecutor(), rm){

                public void handleSuccess() {
                    proxyStrategy.fireModelChanged((IModelDelta)this.getData());
                    if (DEBUG_DELTA && (DEBUG_PRESENTATION_ID == null || AbstractVMProvider.this.getPresentationContext().getId().equals(DEBUG_PRESENTATION_ID))) {
                        AbstractVMProvider.this.trace(event, null, proxyStrategy, EventHandlerAction.firedDeltaFor);
                    }
                    rm.done();
                }

                public String toString() {
                    return "Result of a delta for event: '" + event.toString() + "' in VMP: '" + String.valueOf(AbstractVMProvider.this) + "'\n" + ((IModelDelta)this.getData()).toString();
                }
            });
        } else {
            rm.done();
        }
    }

    protected boolean canSkipHandlingEvent(Object newEvent, Object eventToSkip) {
        return false;
    }

    @Override
    public boolean shouldWaitHandleEventToComplete() {
        return false;
    }

    @Override
    public IRootVMNode getRootVMNode() {
        return this.fRootNode;
    }

    @Override
    public IVMNode[] getAllVMNodes() {
        if (this.fNodesListCache != null) {
            return this.fNodesListCache;
        }
        ArrayList<IVMNode> list = new ArrayList<IVMNode>();
        for (IVMNode node : this.fChildNodesMap.keySet()) {
            if (node == null) continue;
            list.add(node);
        }
        this.fNodesListCache = list.toArray(new IVMNode[list.size()]);
        return this.fNodesListCache;
    }

    @Override
    public IVMNode[] getChildVMNodes(IVMNode node) {
        IVMNode[] retVal = this.fChildNodesMap.get(node);
        if (retVal != null) {
            return retVal;
        }
        return EMPTY_NODES_ARRAY;
    }

    protected void addChildNodes(IVMNode parentNode, IVMNode[] childNodes) {
        IVMNode[] existingChildNodes = this.fChildNodesMap.get(parentNode);
        if (existingChildNodes == null) {
            this.fChildNodesMap.put(parentNode, childNodes);
        } else {
            IVMNode[] newNodes = new IVMNode[existingChildNodes.length + childNodes.length];
            System.arraycopy(existingChildNodes, 0, newNodes, 0, existingChildNodes.length);
            System.arraycopy(childNodes, 0, newNodes, existingChildNodes.length, childNodes.length);
            this.fChildNodesMap.put(parentNode, newNodes);
        }
        IVMNode[] iVMNodeArray = childNodes;
        int n = childNodes.length;
        int n2 = 0;
        while (n2 < n) {
            IVMNode childNode = iVMNodeArray[n2];
            this.addNode(childNode);
            ++n2;
        }
        this.fNodesListCache = null;
    }

    protected void addNode(IVMNode node) {
        if (!this.fChildNodesMap.containsKey(node)) {
            this.fChildNodesMap.put(node, EMPTY_NODES_ARRAY);
        }
    }

    protected void clearNodes() {
        this.clearNodes(true);
        for (IVMNode node : this.fChildNodesMap.keySet()) {
            node.dispose();
        }
        this.fChildNodesMap.clear();
        this.fRootNode = null;
    }

    protected void clearNodes(boolean clearRootNode) {
        for (IVMNode node : this.fChildNodesMap.keySet()) {
            if (clearRootNode && node.equals(this.getRootVMNode())) continue;
            node.dispose();
        }
        this.fChildNodesMap.clear();
        if (clearRootNode) {
            this.fRootNode = null;
        } else {
            this.fChildNodesMap.put(this.getRootVMNode(), EMPTY_NODES_ARRAY);
        }
    }

    protected void setRootNode(IRootVMNode rootNode) {
        this.fRootNode = rootNode;
    }

    @Override
    public void dispose() {
        this.clearNodes();
        this.fRootNode = null;
        this.fDisposed = true;
    }

    public void update(IHasChildrenUpdate[] updates) {
        this.fContentStrategy.update(updates);
    }

    public void update(IChildrenCountUpdate[] updates) {
        this.fContentStrategy.update(updates);
    }

    public void update(IChildrenUpdate[] updates) {
        this.fContentStrategy.update(updates);
    }

    @Override
    public void updateNode(final IVMNode node, IHasChildrenUpdate[] updates) {
        IHasChildrenUpdate[] updateProxies = new IHasChildrenUpdate[updates.length];
        int i = 0;
        while (i < updates.length) {
            final IHasChildrenUpdate update = updates[i];
            if (DEBUG_CONTENT_PROVIDER && (DEBUG_PRESENTATION_ID == null || this.getPresentationContext().getId().equals(DEBUG_PRESENTATION_ID))) {
                DsfUIPlugin.debug("updateNodeHasChildren(node = " + String.valueOf(node) + ", update = " + String.valueOf(update) + ")");
            }
            updateProxies[i] = new VMHasChildrenUpdate((IViewerUpdate)update, (DataRequestMonitor<Boolean>)new ViewerDataRequestMonitor<Boolean>(this.getExecutor(), (IViewerUpdate)update){

                @Override
                protected void handleSuccess() {
                    update.setHasChilren(((Boolean)this.getData()).booleanValue());
                    update.done();
                }

                @Override
                protected void handleErrorOrWarning() {
                    if (this.getStatus().getCode() == 10003) {
                        if (DEBUG_CONTENT_PROVIDER && (DEBUG_PRESENTATION_ID == null || AbstractVMProvider.this.getPresentationContext().getId().equals(DEBUG_PRESENTATION_ID))) {
                            DsfUIPlugin.debug("not-supported:updateNodeHasChildren(node = " + String.valueOf(node) + ", update = " + String.valueOf(update) + ")");
                        }
                        AbstractVMProvider.this.updateNode(node, new VMChildrenUpdate((IViewerUpdate)update, -1, -1, (DataRequestMonitor<List<Object>>)new ViewerDataRequestMonitor<List<Object>>(AbstractVMProvider.this.getExecutor(), (IViewerUpdate)update){

                            @Override
                            protected void handleSuccess() {
                                update.setHasChilren(!((List)this.getData()).isEmpty());
                                update.done();
                            }
                        }));
                    } else {
                        update.setStatus(this.getStatus());
                        update.done();
                    }
                }
            });
            ++i;
        }
        node.update(updateProxies);
    }

    @Override
    public void updateNode(final IVMNode node, final IChildrenCountUpdate update) {
        if (DEBUG_CONTENT_PROVIDER && (DEBUG_PRESENTATION_ID == null || this.getPresentationContext().getId().equals(DEBUG_PRESENTATION_ID))) {
            DsfUIPlugin.debug("updateNodeChildCount(node = " + String.valueOf(node) + ", update = " + String.valueOf(update) + ")");
        }
        node.update(new IChildrenCountUpdate[]{new VMChildrenCountUpdate((IViewerUpdate)update, (DataRequestMonitor<Integer>)new ViewerDataRequestMonitor<Integer>(this.getExecutor(), (IViewerUpdate)update){

            @Override
            protected void handleSuccess() {
                update.setChildCount(((Integer)this.getData()).intValue());
                update.done();
            }

            @Override
            protected void handleErrorOrWarning() {
                if (this.getStatus().getCode() == 10003) {
                    if (DEBUG_CONTENT_PROVIDER && (DEBUG_PRESENTATION_ID == null || AbstractVMProvider.this.getPresentationContext().getId().equals(DEBUG_PRESENTATION_ID))) {
                        DsfUIPlugin.debug("not-supported:updateNodeChildCount(node = " + String.valueOf(node) + ", update = " + String.valueOf(update) + ")");
                    }
                    AbstractVMProvider.this.updateNode(node, new VMChildrenUpdate((IViewerUpdate)update, -1, -1, (DataRequestMonitor<List<Object>>)new ViewerDataRequestMonitor<List<Object>>(AbstractVMProvider.this.getExecutor(), (IViewerUpdate)update){

                        @Override
                        protected void handleSuccess() {
                            update.setChildCount(((List)this.getData()).size());
                            update.done();
                        }
                    }));
                } else {
                    super.handleErrorOrWarning();
                }
            }
        })});
    }

    @Override
    public void updateNode(IVMNode node, IChildrenUpdate update) {
        if (DEBUG_CONTENT_PROVIDER && (DEBUG_PRESENTATION_ID == null || this.getPresentationContext().getId().equals(DEBUG_PRESENTATION_ID))) {
            DsfUIPlugin.debug("updateNodeChildren(node = " + String.valueOf(node) + ", update = " + String.valueOf(update) + ")");
        }
        node.update(new IChildrenUpdate[]{update});
    }

    protected boolean isDisposed() {
        return this.fDisposed;
    }

    @Override
    public Executor getExecutor() {
        return this.fExecutor;
    }

    public IModelProxy createModelProxy(Object element, IPresentationContext context) {
        IVMModelProxy proxy = null;
        Iterator<IVMModelProxy> itr = this.getActiveModelProxies().iterator();
        while (itr.hasNext()) {
            IVMModelProxy next = itr.next();
            if (next == null) continue;
            if (next.getRootElement().equals(element) && next.isDisposed()) {
                proxy = next;
                continue;
            }
            if (!next.isDisposed()) continue;
            itr.remove();
        }
        if (proxy == null) {
            proxy = this.createModelProxyStrategy(element);
            this.getActiveModelProxies().add(proxy);
        } else if (proxy.isDisposed()) {
            proxy.init(context);
        }
        return proxy;
    }

    public IColumnPresentation createColumnPresentation(IPresentationContext context, Object element) {
        return null;
    }

    public String getColumnPresentationId(IPresentationContext context, Object element) {
        return null;
    }

    public void update(IViewerInputUpdate update) {
        update.setInputElement(update.getElement());
        update.done();
    }

    private void trace(Object event, Object skippedOrCanceledEvent, IVMModelProxy proxy, EventHandlerAction action) {
        assert (DEBUG_DELTA);
        StringBuilder str = new StringBuilder();
        str.append(DsfPlugin.getDebugTime());
        str.append(' ');
        if (action == EventHandlerAction.skipped || action == EventHandlerAction.canceled) {
            str.append(LoggingUtils.toString((Object)this)).append(' ').append((Object)action).append(" event ").append(LoggingUtils.toString((Object)skippedOrCanceledEvent)).append(" because of event ").append(LoggingUtils.toString((Object)event));
        } else {
            str.append(LoggingUtils.toString((Object)this)).append(' ').append((Object)action).append(" event ").append(LoggingUtils.toString((Object)event));
        }
        if (action != EventHandlerAction.received) {
            str.append(" for proxy ").append(LoggingUtils.toString((Object)proxy)).append(", whose root is ").append(LoggingUtils.toString((Object)proxy.getRootElement()));
        }
        DsfUIPlugin.debug(str.toString());
    }

    private static enum EventHandlerAction {
        received,
        queued,
        processing,
        firedDeltaFor,
        skipped,
        canceled;

    }

    private class EventInfo {
        Object fEvent;
        RequestMonitor fClientRm;

        EventInfo(Object event, RequestMonitor rm) {
            this.fEvent = event;
            this.fClientRm = rm;
        }
    }

    private class ModelProxyEventQueue {
        EventInfo fCurrentEvent;
        RequestMonitor fCurrentRm;
        List<EventInfo> fEventQueue = new LinkedList<EventInfo>();

        private ModelProxyEventQueue() {
        }
    }
}

