/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.ui.viewmodel.breakpoints;

import java.util.List;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.breakpoints.BreakpointOrganizerVMContext;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.breakpoints.BreakpointVMProvider;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.breakpoints.BreakpointsChangedEvent;
import org.eclipse.cdt.dsf.ui.concurrent.ViewerDataRequestMonitor;
import org.eclipse.cdt.dsf.ui.viewmodel.AbstractVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.VMDelta;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.breakpoints.provisional.IBreakpointOrganizer;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class BreakpointOrganizerVMNode
extends AbstractVMNode {
    private final IBreakpointOrganizer fOrganizer;
    private final IPropertyChangeListener fOrganizerListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            ((BreakpointVMProvider)BreakpointOrganizerVMNode.this.getVMProvider()).handleEventInExecThread(event);
        }
    };

    public BreakpointOrganizerVMNode(BreakpointVMProvider provider, IBreakpointOrganizer organizer) {
        super(provider);
        this.fOrganizer = organizer;
        this.fOrganizer.addPropertyChangeListener(this.fOrganizerListener);
    }

    @Override
    public void dispose() {
        this.fOrganizer.removePropertyChangeListener(this.fOrganizerListener);
        super.dispose();
    }

    public IBreakpointOrganizer getOrganizer() {
        return this.fOrganizer;
    }

    public void update(IHasChildrenUpdate[] updates) {
        IHasChildrenUpdate[] iHasChildrenUpdateArray = updates;
        int n = updates.length;
        int n2 = 0;
        while (n2 < n) {
            final IHasChildrenUpdate update = iHasChildrenUpdateArray[n2];
            if (this.checkUpdate((IViewerUpdate)update)) {
                ((BreakpointVMProvider)this.getVMProvider()).getBreakpointOrganizerVMCs(this, update.getElementPath(), (DataRequestMonitor<List<BreakpointOrganizerVMContext>>)new ViewerDataRequestMonitor<List<BreakpointOrganizerVMContext>>(this.getExecutor(), (IViewerUpdate)update){

                    @Override
                    protected void handleSuccess() {
                        update.setHasChilren(!((List)this.getData()).isEmpty());
                        update.done();
                    }
                });
            }
            ++n2;
        }
    }

    public void update(IChildrenCountUpdate[] updates) {
        IChildrenCountUpdate[] iChildrenCountUpdateArray = updates;
        int n = updates.length;
        int n2 = 0;
        while (n2 < n) {
            final IChildrenCountUpdate update = iChildrenCountUpdateArray[n2];
            if (this.checkUpdate((IViewerUpdate)update)) {
                ((BreakpointVMProvider)this.getVMProvider()).getBreakpointOrganizerVMCs(this, update.getElementPath(), (DataRequestMonitor<List<BreakpointOrganizerVMContext>>)new ViewerDataRequestMonitor<List<BreakpointOrganizerVMContext>>(this.getExecutor(), (IViewerUpdate)update){

                    @Override
                    protected void handleSuccess() {
                        update.setChildCount(((List)this.getData()).size());
                        update.done();
                    }
                });
            }
            ++n2;
        }
    }

    public void update(IChildrenUpdate[] updates) {
        IChildrenUpdate[] iChildrenUpdateArray = updates;
        int n = updates.length;
        int n2 = 0;
        while (n2 < n) {
            final IChildrenUpdate update = iChildrenUpdateArray[n2];
            if (this.checkUpdate((IViewerUpdate)update)) {
                ((BreakpointVMProvider)this.getVMProvider()).getBreakpointOrganizerVMCs(this, update.getElementPath(), (DataRequestMonitor<List<BreakpointOrganizerVMContext>>)new ViewerDataRequestMonitor<List<BreakpointOrganizerVMContext>>(this.getExecutor(), (IViewerUpdate)update){

                    protected void handleCompleted() {
                        if (this.isSuccess()) {
                            int updateIdx = update.getOffset() != -1 ? update.getOffset() : 0;
                            int endIdx = updateIdx + (update.getLength() != -1 ? update.getLength() : ((List)this.getData()).size());
                            while (updateIdx < endIdx && updateIdx < ((List)this.getData()).size()) {
                                update.setChild(((List)this.getData()).get(updateIdx), updateIdx);
                                ++updateIdx;
                            }
                        }
                        update.done();
                    }
                });
            }
            ++n2;
        }
    }

    protected BreakpointOrganizerVMContext createVMContext(IAdaptable category, IBreakpoint[] breakpoints) {
        return new BreakpointOrganizerVMContext(this, category, breakpoints);
    }

    @Override
    public int getDeltaFlags(Object event) {
        PropertyChangeEvent propertyEvent;
        if (event instanceof BreakpointsChangedEvent) {
            return 1024;
        }
        if (BreakpointVMProvider.isPresentationContextEvent(event) ? "FilterSelection".equals((propertyEvent = (PropertyChangeEvent)event).getProperty()) || "ElementComparator".equals(propertyEvent.getProperty()) || "BreakpointOrganizers".equals(propertyEvent.getProperty()) : BreakpointVMProvider.isBreakpointOrganizerEvent(event)) {
            return 1024;
        }
        return 0;
    }

    @Override
    public void buildDelta(Object event, VMDelta parent, int nodeOffset, RequestMonitor requestMonitor) {
        if (event instanceof BreakpointsChangedEvent) {
            parent.setFlags(parent.getFlags() | 0x400);
        } else if (BreakpointVMProvider.isPresentationContextEvent(event)) {
            PropertyChangeEvent propertyEvent = (PropertyChangeEvent)event;
            if ("FilterSelection".equals(propertyEvent.getProperty()) || "ElementComparator".equals(propertyEvent.getProperty()) || "BreakpointOrganizers".equals(propertyEvent.getProperty())) {
                parent.setFlags(parent.getFlags() | 0x400);
            }
        } else if (BreakpointVMProvider.isBreakpointOrganizerEvent(event)) {
            parent.setFlags(parent.getFlags() | 0x400);
        }
        requestMonitor.done();
    }
}

