/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.ui.spi.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.mylyn.commons.workbench.forms.CommonFormUtil;
import org.eclipse.mylyn.internal.reviews.ui.providers.ReviewsLabelProvider;
import org.eclipse.mylyn.reviews.core.model.IReviewItem;
import org.eclipse.mylyn.reviews.core.model.IReviewItemSet;
import org.eclipse.mylyn.reviews.ui.spi.editor.AbstractReviewSection;
import org.eclipse.mylyn.reviews.ui.spi.editor.Messages;
import org.eclipse.mylyn.reviews.ui.spi.editor.ReviewSetContentSection;
import org.eclipse.mylyn.reviews.ui.spi.factories.AbstractReviewItemSetUiFactoryProvider;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class ReviewSetSection
extends AbstractReviewSection {
    protected ReviewsLabelProvider labelProvider;
    private List<ReviewSetContentSection> reviewSetSections;

    public ReviewSetSection() {
        this.setPartName(Messages.ReviewSetSection_Patch_Sets);
    }

    public void initialize(AbstractTaskEditorPage taskEditorPage) {
        this.reviewSetSections = new ArrayList<ReviewSetContentSection>();
        super.initialize(taskEditorPage);
    }

    public void revealPatchSet(int patchSetNumber) {
        if (patchSetNumber > 0 && patchSetNumber <= this.reviewSetSections.size()) {
            int index = patchSetNumber - 1;
            ReviewSetContentSection patchSetSection = this.reviewSetSections.get(index);
            if (!patchSetSection.getSection().isExpanded()) {
                CommonFormUtil.setExpanded((ExpandableComposite)patchSetSection.getSection(), (boolean)true);
            }
            CommonFormUtil.ensureVisible((Control)patchSetSection.getSection());
        }
    }

    @Override
    protected Control createContent(FormToolkit toolkit, Composite parent) {
        Control content = super.createContent(toolkit, parent);
        for (IReviewItem item : this.getReview().getSets()) {
            if (!(item instanceof IReviewItemSet)) continue;
            IReviewItemSet set = (IReviewItemSet)item;
            ReviewSetContentSection subSection = new ReviewSetContentSection(this, set, this.getTaskEditorPage());
            this.reviewSetSections.add(subSection);
        }
        this.revealPatchSet(this.reviewSetSections.size());
        this.getTaskEditorPage().reflow();
        return content;
    }

    protected boolean shouldExpandOnCreate() {
        return true;
    }

    protected abstract AbstractReviewItemSetUiFactoryProvider getUiFactoryProvider();

    @Override
    public TaskRepository getTaskRepository() {
        return this.getEditor().getTaskEditorInput().getTaskRepository();
    }

    public void dispose() {
        super.dispose();
        if (this.labelProvider != null) {
            this.labelProvider.dispose();
        }
        for (ReviewSetContentSection section : this.reviewSetSections) {
            section.dispose();
        }
    }
}

