/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.jaxws.ui.wizards;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jst.ws.internal.jaxws.core.utils.JAXWSHandlerUtils;
import org.eclipse.jst.ws.internal.jaxws.ui.JAXWSUIMessages;
import org.eclipse.jst.ws.internal.jaxws.ui.JAXWSUIPlugin;
import org.eclipse.jst.ws.internal.jaxws.ui.filters.NewHandlerChainViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class OrderHandlerChainPage
extends WizardPage {
    private static final String LOGICAL_HANDLER = "javax.xml.ws.handler.LogicalHandler";
    private static final String SOAP_HANDLER = "javax.xml.ws.handler.soap.SOAPHandler";
    private IStatus ok_status = new Status(0, "org.eclipse.jst.ws.jaxws.ui", "");
    private TreeViewer treeViewer;
    private Document doc;
    private Element root;
    private IPath handlerChainPath;
    private IJavaProject javaProject;
    private boolean configure;
    private String newHandlerClassName;
    private String newHandlerType;

    public OrderHandlerChainPage() {
        super("order.handlerchain.wizard.page");
        this.setTitle(JAXWSUIMessages.JAXWS_ORDER_HANDLER_WIZARD_PAGE_TITLE);
        this.setDescription(JAXWSUIMessages.JAXWS_ORDER_HANDLER_WIZARD_PAGE_DESCRIPTION);
    }

    public OrderHandlerChainPage(IPath handlerChainPath, IJavaProject javaProject) {
        this();
        this.handlerChainPath = handlerChainPath;
        this.javaProject = javaProject;
        this.configure = true;
    }

    public Document getDocument() {
        return this.doc;
    }

    public void refreshViewer() {
        this.treeViewer.refresh();
    }

    public void setSelection(ISelection selection) {
        this.treeViewer.setSelection(selection, true);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        composite.setLayout((Layout)gridLayout);
        this.treeViewer = new TreeViewer(composite, 67588);
        this.treeViewer.getTree().setHeaderVisible(true);
        this.treeViewer.getTree().setLinesVisible(true);
        this.treeViewer.setContentProvider((IContentProvider)new HandlerChainContentProvider());
        TreeViewerColumn nameViewerColumn = new TreeViewerColumn(this.treeViewer, 16384);
        TreeColumn nameColumn = nameViewerColumn.getColumn();
        nameColumn.setWidth(200);
        nameColumn.setMoveable(false);
        nameColumn.setText(JAXWSUIMessages.JAXWS_HANDLER_NAME_COLUMN);
        nameViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Element) {
                    Element handlerNameElement;
                    Element node = (Element)element;
                    if (node.getName().equals("handler") && (handlerNameElement = node.getChild("handler-name", JAXWSHandlerUtils.JAVAEE_NS)) != null) {
                        return handlerNameElement.getText().trim();
                    }
                    if (node.getName().equals("handler-chain")) {
                        return node.getName();
                    }
                }
                return null;
            }

            public Image getImage(Object element) {
                if (element instanceof Element) {
                    return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
                }
                return null;
            }
        });
        TreeViewerColumn classViewerColumn = new TreeViewerColumn(this.treeViewer, 16384);
        TreeColumn classColumn = classViewerColumn.getColumn();
        classColumn.setWidth(200);
        classColumn.setMoveable(false);
        classColumn.setText(JAXWSUIMessages.JAXWS_HANDLER_CLASS_COLUMN);
        classViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Element handlerNameElement;
                Element node;
                if (element instanceof Element && (node = (Element)element).getName().equals("handler") && (handlerNameElement = node.getChild("handler-class", JAXWSHandlerUtils.JAVAEE_NS)) != null) {
                    return handlerNameElement.getText().trim();
                }
                return null;
            }
        });
        TreeViewerColumn typeViewerColumn = new TreeViewerColumn(this.treeViewer, 16384);
        TreeColumn typeColumn = typeViewerColumn.getColumn();
        typeColumn.setWidth(100);
        typeColumn.setMoveable(false);
        typeColumn.setText(JAXWSUIMessages.JAXWS_HANDLER_TYPE_COLUMN);
        typeViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Element handlerClassElement;
                Element node;
                if (element instanceof Element && (node = (Element)element).getName().equals("handler") && (handlerClassElement = node.getChild("handler-class", JAXWSHandlerUtils.JAVAEE_NS)) != null) {
                    if (OrderHandlerChainPage.this.newHandlerClassName != null && OrderHandlerChainPage.this.newHandlerClassName.equals(handlerClassElement.getValue().trim())) {
                        return OrderHandlerChainPage.this.newHandlerType;
                    }
                    try {
                        IType handler = OrderHandlerChainPage.this.javaProject.findType(handlerClassElement.getText().trim());
                        if (handler != null) {
                            IType[] allInterfaces;
                            ITypeHierarchy typeHierarchy = handler.newTypeHierarchy(OrderHandlerChainPage.this.javaProject, null);
                            IType[] iTypeArray = allInterfaces = typeHierarchy.getAllInterfaces();
                            int n = allInterfaces.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IType aInterface = iTypeArray[n2];
                                if (aInterface.getFullyQualifiedName().equals(OrderHandlerChainPage.LOGICAL_HANDLER)) {
                                    return JAXWSUIMessages.JAXWS_LOGICAL;
                                }
                                if (aInterface.getFullyQualifiedName().equals(OrderHandlerChainPage.SOAP_HANDLER)) {
                                    return JAXWSUIMessages.JAXWS_PROTOCOL;
                                }
                                ++n2;
                            }
                        }
                    }
                    catch (JavaModelException jme) {
                        JAXWSUIPlugin.log(jme.getStatus());
                    }
                }
                return null;
            }
        });
        GridData gridData = new GridData(4, 4, true, true);
        gridData.verticalSpan = 6;
        this.treeViewer.getTree().setLayoutData((Object)gridData);
        if (this.configure) {
            Button addButton = new Button(composite, 8);
            addButton.setText(JAXWSUIMessages.JAXWS_HANDLER_ADD);
            gridData = new GridData(4, 0x1000000, true, false);
            addButton.setLayoutData((Object)gridData);
            addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(OrderHandlerChainPage.this.getShell(), (ILabelProvider)new JavaElementLabelProvider(), (ITreeContentProvider)new StandardJavaElementContentProvider());
                    dialog.setTitle(JAXWSUIMessages.JAXWS_HANDLER_CONFIGURATION_HANDLER_DIALOG_TITLE);
                    dialog.setMessage(JAXWSUIMessages.JAXWS_HANDLER_CONFIGURATION_HANDLER_DIALOG_DESCRIPTION);
                    dialog.setAllowMultiple(false);
                    dialog.setInput((Object)JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()));
                    dialog.addFilter((ViewerFilter)new NewHandlerChainViewerFilter(OrderHandlerChainPage.this.javaProject, true, false));
                    dialog.setValidator(new ISelectionStatusValidator(){

                        public IStatus validate(Object[] selection) {
                            if (selection.length == 1 && selection[0] instanceof ICompilationUnit) {
                                ICompilationUnit compilationUnit = (ICompilationUnit)selection[0];
                                if (OrderHandlerChainPage.this.isHandler(compilationUnit)) {
                                    return OrderHandlerChainPage.this.ok_status;
                                }
                                return new Status(4, "org.eclipse.jst.ws.jaxws.ui", JAXWSUIMessages.JAXWS_HANDLER_CONFIGURATION_HANDLER_DIALOG_INVALID);
                            }
                            return new Status(4, "org.eclipse.jst.ws.jaxws.ui", "");
                        }
                    });
                    if (dialog.open() == 0) {
                        ICompilationUnit selectedHandler = (ICompilationUnit)dialog.getFirstResult();
                        OrderHandlerChainPage.this.addHandler(selectedHandler.findPrimaryType().getElementName(), selectedHandler.findPrimaryType().getPackageFragment().getElementName());
                    }
                }
            });
            Button removeButton = new Button(composite, 8);
            removeButton.setText(JAXWSUIMessages.JAXWS_HANDLER_REMOVE);
            gridData = new GridData(4, 0x1000000, true, false);
            removeButton.setLayoutData((Object)gridData);
            removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Element handlerChain;
                    Element selected;
                    IStructuredSelection selection = (IStructuredSelection)OrderHandlerChainPage.this.treeViewer.getSelection();
                    if (!selection.isEmpty() && (selected = (Element)selection.getFirstElement()).getName().equals("handler") && (handlerChain = (Element)selected.getParent()) != null) {
                        handlerChain.removeContent((Content)selected);
                        OrderHandlerChainPage.this.treeViewer.refresh();
                    }
                }
            });
        }
        Button moveUpButton = new Button(composite, 8);
        moveUpButton.setText(JAXWSUIMessages.JAXWS_HANDLER_MOVE_UP);
        gridData = new GridData(4, 0x1000000, true, false);
        moveUpButton.setLayoutData((Object)gridData);
        moveUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)OrderHandlerChainPage.this.treeViewer.getSelection();
                if (!selection.isEmpty()) {
                    Element root;
                    List handlerChains;
                    int topIndex;
                    Element selected = (Element)selection.getFirstElement();
                    Element parent = (Element)selected.getParent();
                    List children = parent.getChildren();
                    int index = children.indexOf(selected);
                    if (index > 0) {
                        children.remove(selected);
                        children.add(index - 1, selected);
                    } else if (index == 0 && (topIndex = (handlerChains = (root = (Element)parent.getParent()).getChildren()).indexOf(parent)) > 0 && handlerChains.get(topIndex - 1) != null) {
                        children.remove(selected);
                        Element topChild = (Element)handlerChains.get(topIndex - 1);
                        topChild.getChildren().add(topChild.getChildren().size(), selected);
                    }
                    OrderHandlerChainPage.this.treeViewer.refresh();
                }
            }
        });
        Button moveDownButton = new Button(composite, 8);
        moveDownButton.setText(JAXWSUIMessages.JAXWS_HANDLER_MOVE_DOWN);
        gridData = new GridData(4, 0x1000000, true, false);
        moveDownButton.setLayoutData((Object)gridData);
        moveDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)OrderHandlerChainPage.this.treeViewer.getSelection();
                if (!selection.isEmpty()) {
                    Element root;
                    List handlerChains;
                    int hIndex;
                    Element selected = (Element)selection.getFirstElement();
                    Element parent = (Element)selected.getParent();
                    List children = parent.getChildren();
                    int index = children.indexOf(selected);
                    if (index >= 0 && index < children.size() - 1) {
                        children.remove(selected);
                        children.add(index + 1, selected);
                    } else if (index == children.size() - 1 && (hIndex = (handlerChains = (root = (Element)parent.getParent()).getChildren()).indexOf(parent)) >= 0 && hIndex < handlerChains.size() - 1 && handlerChains.get(hIndex + 1) != null) {
                        children.remove(selected);
                        Element topChild = (Element)handlerChains.get(hIndex + 1);
                        topChild.getChildren().add(0, selected);
                    }
                    OrderHandlerChainPage.this.treeViewer.refresh();
                }
            }
        });
        if (this.handlerChainPath != null) {
            this.setInput(this.handlerChainPath);
        }
        this.treeViewer.expandAll();
        composite.pack();
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setInput(this.handlerChainPath);
        }
    }

    public void setHandlerChainPath(IPath handlerChainPath) {
        this.handlerChainPath = handlerChainPath;
    }

    private boolean isHandler(ICompilationUnit source) {
        final ArrayList interfaces = new ArrayList();
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(source);
        parser.setResolveBindings(true);
        CompilationUnit compilationUnit = (CompilationUnit)parser.createAST(null);
        compilationUnit.accept(new ASTVisitor(){

            public boolean visit(TypeDeclaration typeDeclaration) {
                List superInterfaces = typeDeclaration.superInterfaceTypes();
                for (Object object : superInterfaces) {
                    String qualifiedName;
                    ParameterizedType parameterizedType;
                    ITypeBinding binding;
                    if (!(object instanceof ParameterizedType) || (binding = (parameterizedType = (ParameterizedType)object).resolveBinding()) == null || !(qualifiedName = binding.getErasure().getQualifiedName()).equals(OrderHandlerChainPage.LOGICAL_HANDLER) && !qualifiedName.equals(OrderHandlerChainPage.SOAP_HANDLER)) continue;
                    interfaces.add(qualifiedName);
                    break;
                }
                return false;
            }
        });
        return interfaces.size() > 0;
    }

    public void setInput(IPath handlerChainPath) {
        if (handlerChainPath == null) {
            return;
        }
        if (!handlerChainPath.isEmpty()) {
            try {
                IFile handlerChainFile = ResourcesPlugin.getWorkspace().getRoot().getFile(handlerChainPath);
                if (handlerChainFile.getFileExtension().equals("xml")) {
                    if (handlerChainFile.exists() && JAXWSHandlerUtils.isHandlerChainFile((IFile)handlerChainFile)) {
                        FileInputStream handlerInputStream = new FileInputStream(handlerChainFile.getLocation().toFile());
                        SAXBuilder builder = new SAXBuilder();
                        this.doc = builder.build((InputStream)handlerInputStream);
                        this.root = this.doc.getRootElement();
                        this.treeViewer.setInput((Object)this.root);
                        this.treeViewer.expandAll();
                    } else {
                        JAXWSHandlerUtils.createHandlerChainFile((IPath)handlerChainPath);
                        this.setInput(handlerChainPath);
                    }
                }
            }
            catch (IOException ioe) {
                JAXWSUIPlugin.log(ioe);
            }
            catch (JDOMException jdome) {
                JAXWSUIPlugin.log(jdome);
            }
        }
    }

    public void setJavaProject(IJavaProject javaProject) {
        this.javaProject = javaProject;
    }

    public void addHandler(String newHandlerName, String packageName) {
        if (this.root != null) {
            Element handlerChainElement = this.root.getChild("handler-chain", JAXWSHandlerUtils.JAVAEE_NS);
            if (handlerChainElement == null) {
                handlerChainElement = new Element("handler-chain", JAXWSHandlerUtils.JAVAEE_NS);
                this.root.addContent((Content)handlerChainElement);
            }
            Element handlerElement = new Element("handler", JAXWSHandlerUtils.JAVAEE_NS);
            Element handlerNameElement = new Element("handler-name", JAXWSHandlerUtils.JAVAEE_NS);
            handlerNameElement.setText(newHandlerName);
            Element handlerClassElement = new Element("handler-class", JAXWSHandlerUtils.JAVAEE_NS);
            if (packageName.trim().length() > 0) {
                handlerClassElement.setText(String.valueOf(packageName) + "." + newHandlerName);
            } else {
                handlerClassElement.setText(newHandlerName);
            }
            handlerElement.addContent((Content)handlerNameElement);
            handlerElement.addContent((Content)handlerClassElement);
            handlerChainElement.addContent((Content)handlerElement);
            this.treeViewer.refresh();
            this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)handlerElement));
        }
    }

    public void addHandler(String newHandlerName, String packageName, String newHandlerType) {
        this.addHandler(newHandlerName, packageName);
        this.newHandlerClassName = String.valueOf(packageName) + "." + newHandlerName;
        this.newHandlerType = newHandlerType;
        if (newHandlerType.equals(JAXWSUIMessages.JAXWS_LOGICAL_HANDLER)) {
            this.newHandlerType = JAXWSUIMessages.JAXWS_LOGICAL;
        } else if (newHandlerType.equals(JAXWSUIMessages.JAXWS_SOAP_HANDLER)) {
            this.newHandlerType = JAXWSUIMessages.JAXWS_PROTOCOL;
        }
    }

    private class HandlerChainContentProvider
    implements ITreeContentProvider {
        private HandlerChainContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Element) {
                Element element = (Element)parentElement;
                return element.getChildren().toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof Element) {
                Element node = (Element)element;
                return node.getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            Element node;
            if (element instanceof Element && (node = (Element)element).getName().equals("handler-chain")) {
                return node.getChildren().size() > 0;
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Element) {
                Element element = (Element)inputElement;
                return element.getChildren().toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

