/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.library.build.lcdsl.tasks.p2;

import com.google.common.base.Splitter;
import java.io.File;
import java.util.Properties;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.tea.core.TaskExecutionContext;
import org.eclipse.tea.core.annotations.TaskChainContextInit;
import org.eclipse.tea.core.services.TaskChain;
import org.eclipse.tea.library.build.config.BuildDirectories;
import org.eclipse.tea.library.build.lcdsl.tasks.p2.AbstractProductBuild;
import org.eclipse.tea.library.build.lcdsl.tasks.p2.ProductBuildRegistry;
import org.eclipse.tea.library.build.lcdsl.tasks.p2.SimpleProductBuild;
import org.eclipse.tea.library.build.model.FeatureBuild;
import org.eclipse.tea.library.build.model.FeatureData;
import org.eclipse.tea.library.build.model.WorkspaceBuild;
import org.eclipse.tea.library.build.util.FileUtils;

@Creatable
public class DynamicProductBuildRegistry
extends ProductBuildRegistry {
    @Inject
    public DynamicProductBuildRegistry(WorkspaceBuild wb) {
        this.addDynamicProducts(wb);
    }

    private void addDynamicProducts(WorkspaceBuild wb) {
        for (FeatureBuild fb : wb.getSourceFeatures()) {
            Properties properties;
            File root = ((FeatureData)fb.getData()).getBundleDir();
            File props = new File(root, "product.properties");
            if (!props.exists()) {
                props = new File(root, "wpob.properties");
            }
            if (!props.exists() || !(properties = FileUtils.readProperties((File)props)).containsKey("updateSites")) continue;
            this.add((AbstractProductBuild)new SimpleProductBuild(new SimpleProductBuild.SimpleProductBuildDescription(fb, properties)), Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)properties.getProperty("updateSites")));
        }
    }

    public static TaskChain getExportProductsForSiteChain(final String siteName, final boolean zipSites) {
        return new TaskChain(){

            @TaskChainContextInit
            public void init(TaskExecutionContext c, BuildDirectories dirs, DynamicProductBuildRegistry reg) {
                reg.addAllUpdateSiteTasks(c, dirs, siteName, zipSites);
                reg.addAllProductTasks(c, siteName);
            }

            public String toString() {
                if (siteName == null) {
                    return "Export all products";
                }
                return "Export products for " + siteName;
            }
        };
    }
}

