/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.core.ui.config;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.extensions.Service;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tea.core.TaskingInjectionHelper;
import org.eclipse.tea.core.internal.TaskingConfigurationStore;
import org.eclipse.tea.core.internal.config.TaskingDevelopmentConfig;
import org.eclipse.tea.core.services.TaskingConfigurationExtension;
import org.eclipse.tea.core.ui.Activator;
import org.eclipse.tea.core.ui.config.TaskingEclipsePreferenceStore;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.Section;

public class TaskingPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    @Inject
    @Service
    private List<TaskingConfigurationExtension> extensions;
    @Inject
    private TaskingDevelopmentConfig config;
    private final List<Composite> allFieldEditorParents = new ArrayList<Composite>();
    Image logoImage;

    public TaskingPreferencePage() {
        super(1);
    }

    public void init(IWorkbench workbench) {
        this.noDefaultButton();
        this.setPreferenceStore(Activator.getInstance().getPreferenceStore());
        ContextInjectionFactory.inject((Object)((Object)this), (IEclipseContext)TaskingInjectionHelper.createConfiguredContext((TaskingConfigurationStore)new TaskingEclipsePreferenceStore()));
    }

    public void dispose() {
        super.dispose();
        this.disposeLogoImage();
    }

    private void disposeLogoImage() {
        if (this.logoImage != null) {
            this.logoImage.dispose();
        }
    }

    protected void createFieldEditors() {
        final ScrolledComposite scrolled = new ScrolledComposite(this.getFieldEditorParent(), 768);
        GridLayoutFactory.fillDefaults().applyTo((Composite)scrolled);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)scrolled);
        scrolled.setExpandHorizontal(true);
        scrolled.setExpandVertical(true);
        final Composite configComp = new Composite((Composite)scrolled, 0);
        GridLayoutFactory.fillDefaults().applyTo(configComp);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)configComp);
        scrolled.setContent((Control)configComp);
        Label logo = new Label(this.getFieldEditorParent(), 0);
        GridDataFactory.swtDefaults().align(4, 128).applyTo((Control)logo);
        this.disposeLogoImage();
        this.logoImage = Activator.imageDescriptorFromPlugin((String)"org.eclipse.tea.core.ui", (String)"resources/tea-full60r.png").createImage();
        logo.setImage(this.logoImage);
        ArrayList<TaskingConfigurationExtension> sortedExtensions = new ArrayList<TaskingConfigurationExtension>(this.extensions);
        sortedExtensions.sort((a, b) -> this.calculateName((TaskingConfigurationExtension)a, a.getClass().getAnnotation(TaskingConfigurationExtension.TaskingConfig.class)).compareTo(this.calculateName((TaskingConfigurationExtension)b, b.getClass().getAnnotation(TaskingConfigurationExtension.TaskingConfig.class))));
        for (TaskingConfigurationExtension ext : sortedExtensions) {
            if (!this.config.showHeadlessConfig && this.isAllHeadless(ext)) continue;
            final Section s = new Section(configComp, 2);
            TaskingConfigurationExtension.TaskingConfig cfg = ext.getClass().getAnnotation(TaskingConfigurationExtension.TaskingConfig.class);
            String name = this.calculateName(ext, cfg);
            s.setText(name + ":");
            s.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                public void expansionStateChanged(ExpansionEvent e) {
                    s.getParent().layout(true, true);
                    scrolled.setMinSize(configComp.computeSize(-1, -1));
                }
            });
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)s);
            Composite wrapper = new Composite((Composite)s, 0);
            GridLayoutFactory.swtDefaults().extendedMargins(15, 0, 0, 0).applyTo(wrapper);
            s.setClient((Control)wrapper);
            s.setBackground(scrolled.getBackground());
            Composite c = new Composite(wrapper, 0);
            GridLayoutFactory.fillDefaults().numColumns(2).applyTo(c);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)c);
            this.allFieldEditorParents.add(c);
            ArrayList<FieldEditor> editorsPerSection = new ArrayList<FieldEditor>();
            Field[] fieldArray = ext.getClass().getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field f = fieldArray[n2];
                TaskingConfigurationExtension.TaskingConfigProperty config = f.getAnnotation(TaskingConfigurationExtension.TaskingConfigProperty.class);
                if (config != null && (!config.headlessOnly() || this.config.showHeadlessConfig)) {
                    String propertyName = TaskingConfigurationStore.getPropertyName((Field)f);
                    if (f.getType().equals(String.class)) {
                        StringFieldEditor editor = new StringFieldEditor(propertyName, config.description(), c);
                        Text t = editor.getTextControl(c);
                        GridData d = (GridData)t.getLayoutData();
                        d.widthHint = 30;
                        this.add((FieldEditor)editor, editorsPerSection);
                    } else if (f.getType().equals(Integer.class) || f.getType().equals(Integer.TYPE)) {
                        this.add((FieldEditor)new IntegerFieldEditor(propertyName, config.description(), c), editorsPerSection);
                    } else if (f.getType().equals(Long.class) || f.getType().equals(Long.TYPE)) {
                        this.add((FieldEditor)new IntegerFieldEditor(propertyName, config.description(), c), editorsPerSection);
                    } else if (f.getType().equals(Boolean.class) || f.getType().equals(Boolean.TYPE)) {
                        this.add((FieldEditor)new BooleanFieldEditor(propertyName, config.description(), c), editorsPerSection);
                    } else if (Enum.class.isAssignableFrom(f.getType())) {
                        List<?> enumConstants = Arrays.asList(f.getType().getEnumConstants());
                        String[][] entryNamesAndValues = this.getEntryNamesAndValues(enumConstants);
                        this.add((FieldEditor)new ComboFieldEditor(propertyName, config.description(), entryNamesAndValues, c), editorsPerSection);
                    }
                }
                ++n2;
            }
            Button defPerSection = new Button(wrapper, 8);
            defPerSection.setText(JFaceResources.getString((String)"defaults"));
            Dialog.applyDialogFont((Control)defPerSection);
            GridDataFactory.fillDefaults().align(131072, 0x1000000).applyTo((Control)defPerSection);
            defPerSection.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
                for (FieldEditor editor : editorsPerSection) {
                    editor.loadDefault();
                }
                this.checkState();
                this.updateApplyButton();
            }));
        }
        scrolled.setMinSize(configComp.computeSize(-1, -1));
    }

    private String calculateName(TaskingConfigurationExtension ext, TaskingConfigurationExtension.TaskingConfig cfg) {
        if (cfg == null) {
            return "Unnamed Configuration (" + String.valueOf(ext) + ")";
        }
        return cfg.description();
    }

    private void add(FieldEditor editor, List<FieldEditor> perSection) {
        perSection.add(editor);
        this.addField(editor);
    }

    private String[][] getEntryNamesAndValues(List<?> enumConstants) {
        String[][] table = new String[enumConstants.size()][2];
        int i = 0;
        while (i < enumConstants.size()) {
            table[i][0] = enumConstants.get(i).toString();
            table[i][1] = enumConstants.get(i).toString();
            ++i;
        }
        return table;
    }

    protected void adjustGridLayout() {
        super.adjustGridLayout();
        int targetColumns = ((GridLayout)this.getFieldEditorParent().getLayout()).numColumns;
        ((GridLayout)this.getFieldEditorParent().getLayout()).numColumns = 2;
        for (Composite c : this.allFieldEditorParents) {
            ((GridLayout)c.getLayout()).numColumns = targetColumns;
        }
    }

    private boolean isAllHeadless(TaskingConfigurationExtension ext) {
        Field[] fieldArray = ext.getClass().getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            TaskingConfigurationExtension.TaskingConfigProperty prop = f.getAnnotation(TaskingConfigurationExtension.TaskingConfigProperty.class);
            if (prop != null && !prop.headlessOnly()) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

