/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.internal.mappings;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swtchart.extensions.core.ISeriesSettings;
import org.eclipse.swtchart.extensions.core.MappedSeriesSettings;
import org.eclipse.swtchart.extensions.core.MappingsKey;
import org.eclipse.swtchart.extensions.core.ResourceSupport;
import org.eclipse.swtchart.extensions.core.SeriesMapper;
import org.eclipse.swtchart.extensions.internal.mappings.Mappings_v1000;

public class MappingsIO {
    public static final String VERSION_IDENTIFIER = "Version=";
    public static final String LINE_DELIMITER = "\r\n";
    public static final String VALUE_DELIMITER = "\t";

    public static Map<MappingsKey, ISeriesSettings> readSettings(String content) {
        HashMap<MappingsKey, ISeriesSettings> mappings;
        block7: {
            String version;
            mappings = new HashMap<MappingsKey, ISeriesSettings>();
            String[] lines = content.split(LINE_DELIMITER);
            if (lines.length <= 0) break block7;
            switch (version = MappingsIO.getVersion(lines[0])) {
                case "v1000": {
                    Mappings_v1000 mappingsIO = new Mappings_v1000();
                    mappings.putAll(mappingsIO.readSettings(lines));
                    break;
                }
            }
        }
        return mappings;
    }

    public static String saveSettings(List<MappedSeriesSettings> mappings) {
        Mappings_v1000 mappingsIO = new Mappings_v1000();
        return mappingsIO.saveSettings(mappings);
    }

    public static Map<MappingsKey, ISeriesSettings> importSettings(File file) {
        HashMap<MappingsKey, ISeriesSettings> mappings = new HashMap<MappingsKey, ISeriesSettings>();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file, StandardCharsets.UTF_8));){
                StringBuilder builder = new StringBuilder();
                String line = null;
                while ((line = bufferedReader.readLine()) != null) {
                    builder.append(line);
                    builder.append(LINE_DELIMITER);
                }
                mappings.putAll(MappingsIO.readSettings(builder.toString()));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return mappings;
    }

    public static boolean exportSettings(File file, List<MappedSeriesSettings> mappings) {
        boolean success = false;
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (PrintWriter printWriter = new PrintWriter(file);){
                printWriter.print(MappingsIO.saveSettings(mappings));
                success = true;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return success;
    }

    public static void restoreSettings() {
        IPreferenceStore preferenceStore = ResourceSupport.getPreferenceStore();
        String settings = preferenceStore.getString("seriesMappings");
        String content = new String(Base64.getDecoder().decode(settings));
        Map<MappingsKey, ISeriesSettings> mappings = MappingsIO.readSettings(content);
        for (Map.Entry<MappingsKey, ISeriesSettings> mapping : mappings.entrySet()) {
            ISeriesSettings seriesSettings = mapping.getValue();
            SeriesMapper.put(mapping.getKey(), seriesSettings);
        }
    }

    public static void persistsSettings(List<MappedSeriesSettings> mappings) {
        try {
            IPreferenceStore preferenceStore = ResourceSupport.getPreferenceStore();
            String content = MappingsIO.saveSettings(mappings);
            String settings = Base64.getEncoder().encodeToString(content.getBytes());
            preferenceStore.setValue("seriesMappings", settings);
            ResourceSupport.savePreferenceStore();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static void appendVersion(StringBuilder builder, String version) {
        builder.append(VERSION_IDENTIFIER);
        builder.append(version);
        builder.append(LINE_DELIMITER);
    }

    private static String getVersion(String line) {
        String[] parts = line.trim().split("=");
        String version = parts.length == 2 ? parts[1].trim() : "v1000";
        return version;
    }
}

