/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.Cursor;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.ProcessingContext;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.References;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.Characters;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.Inline;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.Link;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.SourceSpan;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class AutoLinkSpan
extends SourceSpan {
    private static final String SCHEME_REGEX = "\\p{Alpha}[\\p{Alnum}.+-]{1,31}";
    private static final String ABSOLUTE_URI_REGEX = "\\p{Alpha}[\\p{Alnum}.+-]{1,31}:[^\\x00-\\x20\\x7F<>]+";
    private static final String EMAIL_DOMAIN_PART = "\\p{Alnum}(?:[\\p{Alnum}-]{0,61}\\p{Alnum})?";
    private static final String EMAIL_REGEX = "[\\p{Alnum}.!#$%&'*+/=?^_`{|}~-]+@\\p{Alnum}(?:[\\p{Alnum}-]{0,61}\\p{Alnum})?(?:\\.\\p{Alnum}(?:[\\p{Alnum}-]{0,61}\\p{Alnum})?)*";
    private static final Pattern PATTERN = Pattern.compile("(<(\\p{Alpha}[\\p{Alnum}.+-]{1,31}:[^\\x00-\\x20\\x7F<>]+|([\\p{Alnum}.!#$%&'*+/=?^_`{|}~-]+@\\p{Alnum}(?:[\\p{Alnum}-]{0,61}\\p{Alnum})?(?:\\.\\p{Alnum}(?:[\\p{Alnum}-]{0,61}\\p{Alnum})?)*))>).*", 32);
    private @Nullable Matcher matcher;

    @Override
    public @Nullable Inline createInline(ProcessingContext context, Cursor cursor) {
        Matcher matcher;
        char c = cursor.getChar();
        if (c == '<' && (matcher = cursor.setup(this.getMatcher())).matches()) {
            String link = matcher.group(2);
            Object href = matcher.start(3) != -1 ? "mailto:" + link : link;
            int cursorLength = matcher.end(1) - matcher.regionStart();
            int startOffset = cursor.getOffset();
            return new Link(cursor.getLineAtOffset(), startOffset, cursorLength, cursorLength, AutoLinkSpan.encodeLinkUri((String)href), null, (List<? extends Inline>)ImCollections.newList((Object)new Characters(cursor.getLineAtOffset(), startOffset + 1, cursorLength - 2, cursorLength - 2, link)));
        }
        return null;
    }

    private Matcher getMatcher() {
        if (this.matcher == null) {
            this.matcher = PATTERN.matcher("");
        }
        return this.matcher;
    }

    static String encodeLinkUri(String link) {
        return References.encodeUri(link).replace("%25", "%");
    }
}

