/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.unit.dialect;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.sirius.business.api.preferences.SiriusPreferencesKeys;
import org.eclipse.sirius.tests.support.api.SiriusDiagramTestCase;
import org.eclipse.sirius.tests.support.api.TestsUtil;
import org.eclipse.sirius.tree.DTree;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.ui.IEditorPart;
import org.junit.Assert;

public class TreeUIDialectServicesTests
extends SiriusDiagramTestCase {
    private static final String SEMANTIC_MODEL_PATH = "/org.eclipse.sirius.tests.junit/data/unit/refresh/refreshWhenSeveralEdiorsOpen/My.ecore";
    private static final String MODELER_PATH = "/org.eclipse.sirius.tests.junit/data/unit/refresh/refreshWhenSeveralEdiorsOpen/EcoreExtension.odesign";
    private static final String SESSION_PATH = "/org.eclipse.sirius.tests.junit/data/unit/refresh/refreshWhenSeveralEdiorsOpen/My.aird";
    private static final String VIEWPOINT_NAME = "Design";
    private static final String VIEWPOINT_NAME_EXTENSION = "EcoreForResfreshTest";
    private static final String REPRESENTATION_DESC_NAME_TREE = "Tree";
    private DTree tree;
    private DialectEditor editorRootTree;

    protected void setUp() throws Exception {
        super.setUp();
        this.genericSetUp(SEMANTIC_MODEL_PATH, MODELER_PATH, SESSION_PATH);
        this.initViewpoint(VIEWPOINT_NAME);
        this.initViewpoint(VIEWPOINT_NAME_EXTENSION);
        this.tree = (DTree)this.getRepresentations(REPRESENTATION_DESC_NAME_TREE).toArray()[0];
    }

    public void testDiagramDialectUIManagerRefresh() {
        this.changeSiriusPreference(SiriusPreferencesKeys.PREF_AUTO_REFRESH.name(), false);
        final EPackage ePackage = (EPackage)this.semanticModel;
        this.editorRootTree = (DialectEditor)DialectUIManager.INSTANCE.openEditor(this.session, (DRepresentation)this.tree, (IProgressMonitor)new NullProgressMonitor());
        TestsUtil.synchronizationWithUIThread();
        Assert.assertEquals((String)"Test setup is wrong.", (long)12L, (long)this.tree.getRepresentationElements().size());
        RecordingCommand changeNameCommand = new RecordingCommand(this.session.getTransactionalEditingDomain()){

            protected void doExecute() {
                ePackage.getESubpackages().clear();
            }
        };
        this.session.getTransactionalEditingDomain().getCommandStack().execute((Command)changeNameCommand);
        DialectUIManager.INSTANCE.refreshEditor(this.editorRootTree, (IProgressMonitor)new NullProgressMonitor());
        TestsUtil.synchronizationWithUIThread();
        Assert.assertEquals((String)"Refresh was not applied.", (long)0L, (long)this.tree.getRepresentationElements().size());
    }

    protected void tearDown() throws Exception {
        TestsUtil.synchronizationWithUIThread();
        DialectUIManager.INSTANCE.closeEditor((IEditorPart)this.editorRootTree, false);
        this.tree = null;
        this.editorRootTree = null;
        super.tearDown();
    }
}

