/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.commands;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewRefactorHelper;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.format.BasicSiriusStyleApplicator;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.Style;

public final class PasteStyleCommandProvider {
    private PasteStyleCommandProvider() {
    }

    private static String getCommandLabel() {
        return Messages.PasteStylePureGraphicalAction_commandLabel;
    }

    public static Command createGMFCommand(TransactionalEditingDomain domain, final IGraphicalEditPart targetEditPart, final View sourceView) {
        final ViewRefactorHelper helper = new ViewRefactorHelper(targetEditPart.getDiagramPreferencesHint());
        final List<EClass> exclusions = List.of(NotationPackage.eINSTANCE.getDescriptionStyle(), NotationPackage.eINSTANCE.getImageBufferStyle());
        AbstractTransactionalCommand viewStyleCommand = new AbstractTransactionalCommand(domain, PasteStyleCommandProvider.getCommandLabel(), null){

            protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                helper.copyViewAppearance(sourceView, targetEditPart.getNotationView(), exclusions);
                return CommandResult.newOKCommandResult();
            }
        };
        return new ICommandProxy((ICommand)viewStyleCommand);
    }

    public static Command createSiriusCommand(TransactionalEditingDomain domain, final DSemanticDecorator targetElement, final Style sourceStyle) {
        AbstractTransactionalCommand viewStyleCommand = new AbstractTransactionalCommand(domain, PasteStyleCommandProvider.getCommandLabel(), null){

            protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                BasicSiriusStyleApplicator.INSTANCE.applySiriusStyle(targetElement, sourceStyle);
                return CommandResult.newOKCommandResult();
            }
        };
        return new ICommandProxy((ICommand)viewStyleCommand);
    }
}

