/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.tools.api.interpreter;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.ext.base.collect.StackEx;

public class VariableManager {
    private Map<String, StackEx<Object>> variables = new HashMap<String, StackEx<Object>>();

    public void setVariable(String name, Object value) {
        StackEx stack = this.variables.get(name);
        if (stack == null) {
            stack = new StackEx();
            this.variables.put(name, (StackEx<Object>)stack);
        }
        stack.push(value);
    }

    public void unSetVariable(String name) {
        StackEx<Object> stack = this.variables.get(name);
        if (stack != null && !stack.isEmpty()) {
            stack.pop();
        }
    }

    public void clearVariables() {
        this.variables.clear();
    }

    public Map<String, Object> getVariables() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, StackEx<Object>> variable : this.variables.entrySet()) {
            if (variable.getValue().isEmpty()) continue;
            result.put(variable.getKey(), variable.getValue().peek());
        }
        return result;
    }

    public Object getVariable(String name) {
        StackEx<Object> stack = this.variables.get(name);
        if (stack != null && !stack.isEmpty()) {
            return stack.peek();
        }
        return null;
    }

    public VariableManager getCopy() {
        VariableManager variableManager = new VariableManager();
        for (Map.Entry<String, StackEx<Object>> variable : this.variables.entrySet()) {
            StackEx copiedStackEx = new StackEx();
            for (Object object : variable.getValue().toList()) {
                copiedStackEx.push(object);
            }
            variableManager.variables.put(variable.getKey(), (StackEx<Object>)copiedStackEx);
        }
        return variableManager;
    }

    public void setVariables(IInterpreter interpreter) {
        for (Map.Entry<String, StackEx<Object>> variable : this.variables.entrySet()) {
            for (Object object : variable.getValue().toList()) {
                interpreter.setVariable(variable.getKey(), object);
            }
        }
    }
}

