/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.actions.creation;

import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.ui.tools.internal.viewpoint.ViewpointHelper;
import org.eclipse.sirius.ui.tools.internal.wizards.CreateRepresentationWizard;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.ui.PlatformUI;

public class OtherRepresentationAction
extends Action {
    private Session session;
    private EObject semanticSelection;

    public OtherRepresentationAction(Session session, EObject theSemanticSelection) {
        this.session = session;
        this.semanticSelection = theSemanticSelection;
        this.initializeLabelAndState();
    }

    private void initializeLabelAndState() {
        this.setToolTipText(Messages.OtherRepresentationAction_tooltip);
        Collection<Viewpoint> availableViewpoints = ViewpointHelper.getAvailableViewpoints(this.session);
        boolean representationForSemanticSelectionAvailableForCreation = availableViewpoints.stream().anyMatch(viewpoint -> {
            EList ownedRepresentations = viewpoint.getOwnedRepresentations();
            return ownedRepresentations.stream().anyMatch(repDesc -> {
                boolean canCreate = DialectManager.INSTANCE.canCreate(this.semanticSelection, repDesc, false);
                return canCreate;
            });
        });
        if (representationForSemanticSelectionAvailableForCreation) {
            this.setEnabled(true);
            this.setText(Messages.OtherRepresentationAction_label);
        } else {
            this.setEnabled(false);
            this.setText(Messages.OtherRepresentationAction_noRepresentation_label);
        }
    }

    public void run() {
        super.run();
        CreateRepresentationWizard wizard = new CreateRepresentationWizard(this.session, this.semanticSelection);
        wizard.init();
        WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), (IWizard)wizard);
        dialog.setMinimumPageSize(1000, 600);
        dialog.create();
        dialog.getShell().setText(Messages.CreateRepresentationFromSessionAction_wizardTitle);
        dialog.open();
    }
}

