/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.print;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.common.ui.action.actions.IPrintActionHelper;
import org.eclipse.gmf.runtime.common.ui.services.editor.EditorService;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IDiagramPreferenceSupport;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.printing.internal.util.SWTDiagramPrinter;
import org.eclipse.gmf.runtime.diagram.ui.printing.render.actions.EnhancedPrintActionHelper;
import org.eclipse.gmf.runtime.diagram.ui.printing.render.internal.DiagramUIPrintingRenderDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.printing.render.internal.DiagramUIPrintingRenderPlugin;
import org.eclipse.gmf.runtime.diagram.ui.printing.render.internal.JPSDiagramPrinter;
import org.eclipse.gmf.runtime.diagram.ui.printing.render.internal.JPSDiagramPrinterHelper;
import org.eclipse.gmf.runtime.diagram.ui.printing.util.DiagramPrinterUtil;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.internal.print.SiriusJPSRenderedDiagramPrinter;
import org.eclipse.sirius.diagram.ui.tools.internal.print.SiriusSWTRenderedDiagramPrinter;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;

public class SiriusEnhancedPrintActionHelper
implements IPrintActionHelper {
    public void doPrint(IWorkbenchPart workbenchPart) {
        IMapMode mapMode;
        DiagramEditor diagramEditor = null;
        if (!(workbenchPart instanceof DiagramEditor)) {
            Log.error((Plugin)DiagramUIPrintingRenderPlugin.getInstance(), (int)4, (String)Messages.SiriusEnhancedPrintActionHelper_invalidIworkbenchPart);
            IllegalArgumentException e = new IllegalArgumentException(Messages.SiriusEnhancedPrintActionHelper_invalidIworkbenchPart);
            Trace.throwing((Plugin)DiagramUIPrintingRenderPlugin.getInstance(), (String)DiagramUIPrintingRenderDebugOptions.EXCEPTIONS_THROWING, EnhancedPrintActionHelper.class, (String)"doPrint()", (Throwable)e);
            throw e;
        }
        diagramEditor = (DiagramEditor)workbenchPart;
        IDiagramGraphicalViewer viewer = diagramEditor.getDiagramGraphicalViewer();
        RootEditPart rootEP = viewer == null ? null : viewer.getRootEditPart();
        PreferencesHint preferencesHint = rootEP instanceof IDiagramPreferenceSupport ? ((IDiagramPreferenceSupport)rootEP).getPreferencesHint() : PreferencesHint.USE_DEFAULTS;
        IMapMode iMapMode = mapMode = rootEP instanceof DiagramRootEditPart ? ((DiagramRootEditPart)rootEP).getMapMode() : MapModeUtil.getMapMode();
        if (Platform.getOS().startsWith("win32") && Platform.getOSArch().equals("x86")) {
            DiagramPrinterUtil.printWithSettings((IEditorPart)diagramEditor, this.createDiagramMap(), (SWTDiagramPrinter)new SiriusSWTRenderedDiagramPrinter(preferencesHint, mapMode));
        } else {
            JPSDiagramPrinterHelper.getDiagramPrinterHelper().printWithSettings((IEditorPart)diagramEditor, this.createDiagramMap(), (JPSDiagramPrinter)new SiriusJPSRenderedDiagramPrinter(preferencesHint, mapMode));
        }
    }

    private Map<String, Diagram> createDiagramMap() {
        HashMap<String, Diagram> diagramMap = new HashMap<String, Diagram>();
        List diagramEditors = EditorService.getInstance().getRegisteredEditorParts();
        for (Object obj : diagramEditors) {
            Resource resource;
            DiagramEditor dEditor;
            Diagram diagram;
            if (!(obj instanceof DiagramEditor) || (diagram = (dEditor = (DiagramEditor)obj).getDiagram()) == null) continue;
            Object diagramName = dEditor.getPartName();
            if (diagramName == null) {
                diagramName = dEditor.getTitle();
            }
            if (diagramName == null) {
                diagramName = diagram.getName();
            }
            if ((resource = diagram.eResource()) != null) {
                URI resourceURI = resource.getURI();
                diagramName = resourceURI.toString() + "#" + (String)diagramName;
            }
            diagramName = this.makeNameUnique((String)diagramName, diagramMap.keySet());
            diagramMap.put((String)diagramName, diagram);
        }
        return diagramMap;
    }

    private String makeNameUnique(String name, Set<String> existingNames) {
        String result = name;
        if (existingNames.contains(result)) {
            result = this.makeNameUnique(result, existingNames, 1);
        }
        return result;
    }

    private String makeNameUnique(String name, Set<String> existingNames, int nbIteration) {
        Object result = name + " (" + nbIteration + ")";
        if (existingNames.contains(result)) {
            result = this.makeNameUnique(name, existingNames, nbIteration + 1);
        }
        return result;
    }
}

