/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.handler;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.draw2d.FreeformLayeredPane;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ScalableFigure;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.draw2d.zoom.ZoomListener;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.LineSeg;
import org.eclipse.gmf.runtime.draw2d.ui.internal.figures.AnimationModel;
import org.eclipse.gmf.runtime.gef.ui.internal.editparts.AnimatedZoomListener;
import org.eclipse.sirius.ext.draw2d.figure.IFixedFigure;

public class SiriusAnimatableZoomManager
extends ZoomManager {
    private static final int DURATION_INCREMENT = 400;
    private int zoomAnimationStyle = 0;
    private List<Object> animationListeners = new ArrayList<Object>();

    public SiriusAnimatableZoomManager(ScalableFigure pane, Viewport viewport) {
        super(pane, viewport);
    }

    public void setZoomAsText(String zoomString) {
        List<IFixedFigure> removedFigures = this.removeSynchronizationFigureFromDiagram();
        super.setZoomAsText(zoomString);
        this.reAttachedFiguresOnDiagram(removedFigures);
    }

    private void reAttachedFiguresOnDiagram(List<IFixedFigure> removedFigures) {
        FreeformLayeredPane freeformLayeredPane = (FreeformLayeredPane)this.getScalableFigure().getChildren().stream().filter(FreeformLayeredPane.class::isInstance).findFirst().get();
        removedFigures.stream().forEach(fig -> {
            freeformLayeredPane.add((IFigure)fig);
            fig.updateLocation();
        });
    }

    private List<IFixedFigure> removeSynchronizationFigureFromDiagram() {
        FreeformLayeredPane freeformLayeredPane = (FreeformLayeredPane)this.getScalableFigure().getChildren().stream().filter(FreeformLayeredPane.class::isInstance).findFirst().get();
        Stream<IFixedFigure> volatileFigureStream = freeformLayeredPane.getChildren().stream().filter(IFixedFigure.class::isInstance).map(IFixedFigure.class::cast);
        List<IFixedFigure> removedFigures = volatileFigureStream.collect(Collectors.toList());
        removedFigures.stream().forEach(fig -> freeformLayeredPane.remove((IFigure)fig));
        return removedFigures;
    }

    public int getZoomAnimationStyle() {
        return this.zoomAnimationStyle;
    }

    public void setZoomAnimationStyle(int style) {
        this.zoomAnimationStyle = style;
    }

    public void addZoomListener(ZoomListener listener) {
        super.addZoomListener(listener);
        if (listener instanceof AnimatedZoomListener) {
            this.animationListeners.add(listener);
        }
    }

    protected void fireAnimatedZoomStarted() {
        Iterator<Object> iter = this.animationListeners.iterator();
        while (iter.hasNext()) {
            ((AnimatedZoomListener)iter.next()).animatedZoomStarted();
        }
    }

    protected void fireAnimatedZoomEnded() {
        Iterator<Object> iter = this.animationListeners.iterator();
        while (iter.hasNext()) {
            ((AnimatedZoomListener)iter.next()).animatedZoomEnded();
        }
    }

    public void zoomTo(double zoom, Point zoomedPoint, boolean considerVolatileFigure) {
        List<IFixedFigure> removedFigures = null;
        if (considerVolatileFigure) {
            removedFigures = this.removeSynchronizationFigureFromDiagram();
        }
        Point zoomedPointCopy = zoomedPoint.getCopy();
        this.getScalableFigure().translateToRelative((Translatable)zoomedPointCopy);
        this.primSetZoom(zoom, zoomedPointCopy);
        if (considerVolatileFigure) {
            this.reAttachedFiguresOnDiagram(removedFigures);
        }
    }

    public void zoomTo(Rectangle rect) {
        List<IFixedFigure> removedFigures = this.removeSynchronizationFigureFromDiagram();
        Dimension available = this.getViewport().getClientArea().getSize();
        Dimension desired = rect.getSize();
        double scaleX = (double)available.width * this.getZoom() / (double)desired.width;
        double scaleY = (double)available.height * this.getZoom() / (double)desired.height;
        double zoom = Math.min(this.getMaxZoom(), Math.max(this.getMinZoom(), Math.min(scaleX, scaleY)));
        this.zoomTo(zoom, rect.getCenter(), false);
        this.reAttachedFiguresOnDiagram(removedFigures);
    }

    protected void primSetZoom(double zoom) {
        List<IFixedFigure> removedFigures = this.removeSynchronizationFigureFromDiagram();
        Point center = this.getViewport().getClientArea().getCenter();
        this.primSetZoom(zoom, center);
        this.reAttachedFiguresOnDiagram(removedFigures);
    }

    private AnimationModel calculateAnimationModel(double zoom) {
        double dmod = Math.pow(zoom / this.getZoom(), 0.125);
        int steps = (int)Math.round(dmod > 1.0 ? dmod : 1.0 / dmod);
        int duration = Math.max(400, steps * 400);
        AnimationModel animationModel = new AnimationModel((long)duration, true);
        animationModel.animationStarted();
        return animationModel;
    }

    private void primSetZoom(double zoom, Point finalCenterAbs) {
        this.primAnimateSetZoom(zoom, finalCenterAbs, this.getZoomAnimationStyle() == 1 ? this.calculateAnimationModel(zoom) : null);
    }

    private void primAnimateSetZoom(double zoomLevel, Point pointToZoom, AnimationModel animationModel) {
        double initialZoom = this.getZoom();
        double finalZoom = zoomLevel;
        Point scaledMousePoint = pointToZoom.getCopy();
        Point originalViewLocation = this.getViewport().getViewLocation();
        Dimension zoomDifference = originalViewLocation.getDifference(pointToZoom);
        Point finalViewLocation = scaledMousePoint.scale(finalZoom / initialZoom).getTranslated(zoomDifference);
        LineSeg scrollVector = new LineSeg(originalViewLocation, finalViewLocation);
        float progress = 1.0f;
        if (animationModel != null) {
            animationModel.animationStarted();
            progress = animationModel.getProgress();
        }
        boolean finished = false;
        this.fireAnimatedZoomStarted();
        while (!finished) {
            if (animationModel == null || animationModel.isFinished()) {
                finished = true;
            }
            double currentZoom = initialZoom + (finalZoom - initialZoom) * (double)progress;
            super.primSetZoom(currentZoom);
            Point currentViewLocation = scrollVector.locatePoint((double)progress, 0L, LineSeg.Sign.POSITIVE);
            this.setViewLocation(currentViewLocation);
            this.getViewport().getUpdateManager().performUpdate();
            if (animationModel == null) continue;
            progress = animationModel.getProgress();
        }
        this.fireAnimatedZoomEnded();
    }
}

