/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.ui.interpreter.internal.language;

import org.eclipse.acceleo.ui.interpreter.language.AbstractLanguageInterpreter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public final class LanguageInterpreterDescriptor {
    public static final String LANGUAGE_INTERPRETER_ATTRIBUTE_CLASS = "class";
    private static final String LANGUAGE_INTERPRETER_ATTRIBUTE_ICON = "icon";
    private static final String LANGUAGE_INTERPRETER_ATTRIBUTE_LABEL = "label";
    private final IConfigurationElement element;
    private final ImageDescriptor icon;
    private final String interpreterClassName;
    private final String label;

    public LanguageInterpreterDescriptor(IConfigurationElement element) {
        String extendingPluginId;
        this.element = element;
        this.label = element.getAttribute(LANGUAGE_INTERPRETER_ATTRIBUTE_LABEL);
        this.interpreterClassName = element.getAttribute(LANGUAGE_INTERPRETER_ATTRIBUTE_CLASS);
        ImageDescriptor parsedIcon = null;
        String iconPath = element.getAttribute(LANGUAGE_INTERPRETER_ATTRIBUTE_ICON);
        if (iconPath != null && (extendingPluginId = element.getContributor().getName()) != null && extendingPluginId.length() > 0) {
            parsedIcon = AbstractUIPlugin.imageDescriptorFromPlugin((String)extendingPluginId, (String)iconPath);
        }
        this.icon = parsedIcon;
    }

    public AbstractLanguageInterpreter createLanguageInterpreter() {
        try {
            return (AbstractLanguageInterpreter)this.element.createExecutableExtension(LANGUAGE_INTERPRETER_ATTRIBUTE_CLASS);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public String getClassName() {
        return this.interpreterClassName;
    }

    public ImageDescriptor getIcon() {
        return this.icon;
    }

    public String getLabel() {
        return this.label;
    }
}

