/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.tools.api.resource;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class ImageFileFormat {
    public static final ImageFileFormat GIF = new ImageFileFormat("GIF");
    public static final ImageFileFormat JPEG = new ImageFileFormat("JPEG");
    public static final ImageFileFormat JPG = new ImageFileFormat("JPG");
    public static final ImageFileFormat BMP = new ImageFileFormat("BMP");
    public static final ImageFileFormat SVG = new ImageFileFormat("SVG");
    public static final ImageFileFormat SVGZ = new ImageFileFormat("SVGZ");
    public static final ImageFileFormat PNG = new ImageFileFormat("PNG");
    public static final ImageFileFormat[] VALUES = new ImageFileFormat[]{GIF, BMP, JPEG, JPG, SVG, SVGZ, PNG};
    private String name;

    private ImageFileFormat(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    protected List<ImageFileFormat> getValues() {
        return Collections.unmodifiableList(Arrays.asList(VALUES));
    }

    public static ImageFileFormat getDefaultImageFormat() {
        return GIF;
    }

    public static ImageFileFormat resolveImageFormat(int ordinal) {
        return VALUES[ordinal];
    }

    public static ImageFileFormat resolveImageFormat(String imageFormat) {
        ImageFileFormat[] imageFileFormatArray = VALUES;
        int n = VALUES.length;
        int n2 = 0;
        while (n2 < n) {
            ImageFileFormat element = imageFileFormatArray[n2];
            if (element.getName().toLowerCase().equals(imageFormat.toLowerCase())) {
                return element;
            }
            ++n2;
        }
        return ImageFileFormat.getDefaultImageFormat();
    }
}

