/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.color;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.ui.tools.api.color.VisualBindingManager;
import org.eclipse.sirius.viewpoint.RGBValues;
import org.eclipse.sirius.viewpoint.description.Group;
import org.eclipse.sirius.viewpoint.description.UserFixedColor;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class ColorManager {
    private static final String RGB_VALUES_SEPARATOR = ",";
    private static ColorManager defaultInstance;
    private Map<String, Color> lighterColorCache = new HashMap<String, Color>();

    protected ColorManager() {
    }

    public static ColorManager getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new ColorManager();
        }
        return defaultInstance;
    }

    public Color getLighterColor(RGBValues colorToLight) {
        String key = this.getKey(colorToLight);
        if (!this.lighterColorCache.containsKey(key)) {
            Color newLighterColor = FigureUtilities.mixColors((Color)VisualBindingManager.getDefault().getColorFromRGBValues(colorToLight), (Color)ColorConstants.white, (double)0.4);
            this.lighterColorCache.put(key, newLighterColor);
        }
        return this.lighterColorCache.get(key);
    }

    private String getKey(RGBValues color) {
        StringBuilder sb = new StringBuilder("Color");
        if (color != null) {
            sb.append("_r:");
            sb.append(color.getRed());
            sb.append("_g:");
            sb.append(color.getGreen());
            sb.append("_b:");
            sb.append(color.getBlue());
        }
        return sb.toString();
    }

    public Map<String, RGB> collectVsmColors(Session session) {
        Map<String, Object> vsmColors = new LinkedHashMap<String, RGB>();
        IPreferenceStore preferenceStore = SiriusEditPlugin.getPlugin().getPreferenceStore();
        if (preferenceStore != null) {
            vsmColors = session.getSelectedViewpoints(true).stream().map(EObject::eContainer).map(Group.class::cast).flatMap(group -> group.getUserColorsPalettes().stream()).flatMap(palette -> palette.getEntries().stream()).filter(UserFixedColor.class::isInstance).map(UserFixedColor.class::cast).collect(Collectors.toMap(c -> c.getName(), c -> new RGB(c.getRed(), c.getGreen(), c.getBlue()), (rgb1, rgb2) -> rgb1, () -> new LinkedHashMap()));
        }
        return vsmColors;
    }

    public String rgbToString(RGB rgb) {
        String result = new String();
        if (rgb != null) {
            result = String.format("{%d, %d, %d}", rgb.red, rgb.green, rgb.blue);
        }
        return result;
    }

    public RGB stringToRGB(String stringToConvert) {
        RGB color = null;
        if (stringToConvert != null && stringToConvert.matches("\\{(\\d{1,3})\\s?,\\s?(\\d{1,3})\\s?,\\s?(\\d{1,3})\\}")) {
            String colorString = stringToConvert.replaceAll(" ", "");
            String[] stringToParseArray = colorString.replaceAll("[{}]", "").split(RGB_VALUES_SEPARATOR);
            try {
                color = new RGB(Integer.parseInt(stringToParseArray[0]), Integer.parseInt(stringToParseArray[1]), Integer.parseInt(stringToParseArray[2]));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return color;
    }

    public List<RGB> sortColors(Collection<RGB> colorsToSort) {
        ArrayList<RGB> sortedList = Collections.EMPTY_LIST;
        if (colorsToSort != null) {
            sortedList = new ArrayList<RGB>(colorsToSort);
            Collections.sort(sortedList, new Comparator<RGB>(){

                @Override
                public int compare(RGB o1, RGB o2) {
                    float[] hsb1 = o1.getHSB();
                    float[] hsb2 = o2.getHSB();
                    int hueComparison = Float.compare(hsb1[0], hsb2[0]);
                    int saturationComparison = Float.compare(hsb1[1], hsb2[1]);
                    int brightnessComparison = Float.compare(hsb1[2], hsb2[2]);
                    int result = hueComparison != 0 ? hueComparison : (saturationComparison != 0 ? saturationComparison : brightnessComparison);
                    return result;
                }
            });
        }
        return sortedList;
    }
}

