/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.quickfix;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.image.RichTextAttributeRegistry;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.api.resource.FileProvider;
import org.eclipse.sirius.diagram.WorkspaceImage;
import org.eclipse.sirius.diagram.ui.internal.quickfix.AbstractValidationFix;
import org.eclipse.sirius.diagram.ui.internal.quickfix.ChangeMassivelyImagePathDialog;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class ImageMarkerMassResolution
extends AbstractValidationFix {
    public String getLabel() {
        return Messages.ImageMarkerMassResolution_label;
    }

    @Override
    protected void doExecuteFix(IMarker marker, IEditorPart editor, View markedView, Session session) {
        String imagePath = marker.getAttribute("IMAGE_PATH", null);
        boolean exists = FileProvider.getDefault().exists((IPath)new Path(imagePath), (Object)session);
        if (!exists) {
            boolean fixSucceeded = ImageMarkerMassResolution.fixImagePathMassively(session, imagePath);
            if (fixSucceeded) {
                this.revalidate(editor, (View)markedView.getDiagram());
            }
        } else {
            this.revalidate(editor, (View)markedView.getDiagram());
        }
    }

    private static boolean fixImagePathMassivelyInDescription(Session session, String oldPathPrefix, String newPathPrefix) {
        Set eAttributes = RichTextAttributeRegistry.INSTANCE.getEAttributes();
        boolean[] fixSucceeded = new boolean[1];
        for (Resource resource : session.getSemanticResources()) {
            EcoreUtil.getAllProperContents((Resource)resource, (boolean)true).forEachRemaining(object -> {
                if (object instanceof EObject) {
                    blArray[0] = fixSucceeded[0] || ImageMarkerMassResolution.updateImagePathInRichText(eAttributes, (EObject)object, oldPathPrefix, newPathPrefix);
                }
            });
        }
        for (DRepresentationDescriptor repDescriptor : DialectManager.INSTANCE.getAllRepresentationDescriptors(session)) {
            boolean bl = fixSucceeded[0] = fixSucceeded[0] || ImageMarkerMassResolution.updateImagePathInRichText(eAttributes, (EObject)repDescriptor, oldPathPrefix, newPathPrefix);
        }
        return fixSucceeded[0];
    }

    private static boolean fixImagePathMassivelyInWorkspaceImage(Session session, String oldPathPrefix, String newPathPrefix) {
        boolean[] fixSucceeded = new boolean[1];
        for (DRepresentation representation : DialectManager.INSTANCE.getAllRepresentations(session)) {
            Iterable it = () -> representation.eAllContents();
            StreamSupport.stream(it.spliterator(), false).filter(WorkspaceImage.class::isInstance).forEach(wImage -> {
                String workspacePath = ((WorkspaceImage)wImage).getWorkspacePath();
                if (workspacePath.startsWith(oldPathPrefix)) {
                    String newWorkspacePath = workspacePath.replaceFirst(oldPathPrefix, newPathPrefix);
                    ((WorkspaceImage)wImage).setWorkspacePath(newWorkspacePath);
                    blArray[0] = true;
                }
            });
        }
        return fixSucceeded[0];
    }

    public static boolean fixImagePathMassively(final Session session, String currentImagePath) {
        final boolean[] fixSucceeded = new boolean[1];
        String imageFolder = currentImagePath.replaceFirst("/(?:.(?!/))+$", "");
        Shell activeShell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
        final ChangeMassivelyImagePathDialog dialog = new ChangeMassivelyImagePathDialog(activeShell, imageFolder);
        if (dialog.open() == 0) {
            final String oldPathPrefix = dialog.getOldPathPrefix().replaceAll("/+$", "");
            final String newPathPrefix = dialog.getNewPathPrefix().replaceAll("/+$", "");
            session.getTransactionalEditingDomain().getCommandStack().execute((Command)new RecordingCommand(session.getTransactionalEditingDomain()){

                protected void doExecute() {
                    fixSucceeded[0] = ImageMarkerMassResolution.fixImagePathMassivelyInDescription(session, oldPathPrefix, newPathPrefix);
                    if (dialog.processDiagramContent()) {
                        fixSucceeded[0] = ImageMarkerMassResolution.fixImagePathMassivelyInWorkspaceImage(session, oldPathPrefix, newPathPrefix) || fixSucceeded[0];
                    }
                }
            });
        }
        return fixSucceeded[0];
    }

    private static boolean updateImagePathInRichText(Set<EAttribute> eAttributes, EObject eObject, String oldPathPrefix, String newPathPrefix) {
        boolean fixSucceeded = false;
        List attributesToCheck = eObject.eClass().getEAllAttributes().stream().filter(eAttributes::contains).collect(Collectors.toList());
        for (EAttribute eAttribute : attributesToCheck) {
            String srcText;
            String textToReplace;
            String htmlText;
            Object stringObj = eObject.eGet((EStructuralFeature)eAttribute);
            if (!(stringObj instanceof String) || !(htmlText = (String)stringObj).contains(textToReplace = (srcText = "src=\"") + oldPathPrefix)) continue;
            String newHtmlText = htmlText.replaceAll(textToReplace, srcText + newPathPrefix);
            eObject.eSet((EStructuralFeature)eAttribute, (Object)newHtmlText);
            fixSucceeded = true;
        }
        return fixSucceeded;
    }
}

