/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.api.image;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.sirius.diagram.ui.business.api.image.ImageSelector;
import org.eclipse.sirius.diagram.ui.business.api.image.WorkspaceImageSelector;
import org.eclipse.sirius.diagram.ui.business.internal.image.ImageSelectorDescriptor;
import org.eclipse.sirius.diagram.ui.business.internal.image.ImageSelectorDescriptorRegistry;

public class ImageSelectorService {
    public static final ImageSelectorService INSTANCE = new ImageSelectorService();

    public ImageSelector getImageSelector() {
        ImageSelectorDescriptor imageSelectorDescriptor;
        ImageSelector result = null;
        List<ImageSelectorDescriptor> imageSelectorDescriptors = ImageSelectorDescriptorRegistry.getRegisteredExtensions();
        if (!imageSelectorDescriptors.isEmpty() && (imageSelectorDescriptor = this.getFirstMostOverrider(imageSelectorDescriptors)) != null) {
            result = imageSelectorDescriptor.getImageSelector();
        }
        if (result == null) {
            result = new WorkspaceImageSelector();
        }
        return result;
    }

    private ImageSelectorDescriptor getFirstMostOverrider(List<ImageSelectorDescriptor> imageSelectorDescriptors) {
        ArrayList<String> overriddenImageSelectorIDs = new ArrayList<String>();
        ImageSelectorDescriptor firstMostOverridingImageSelectorDescriptor2 = null;
        for (ImageSelectorDescriptor firstMostOverridingImageSelectorDescriptor2 : imageSelectorDescriptors) {
            String overrideValue = firstMostOverridingImageSelectorDescriptor2.getOverrideValue();
            if (overrideValue == null) continue;
            overriddenImageSelectorIDs.add(overrideValue);
        }
        for (ImageSelectorDescriptor firstMostOverridingImageSelectorDescriptor2 : imageSelectorDescriptors) {
            if (overriddenImageSelectorIDs.contains(firstMostOverridingImageSelectorDescriptor2.getId())) continue;
            return firstMostOverridingImageSelectorDescriptor2;
        }
        return firstMostOverridingImageSelectorDescriptor2;
    }
}

