/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.tools.resolver;

import java.util.List;
import org.eclipse.persistence.jpa.jpql.tools.TypeHelper;
import org.eclipse.persistence.jpa.jpql.tools.resolver.Resolver;
import org.eclipse.persistence.jpa.jpql.tools.spi.IType;
import org.eclipse.persistence.jpa.jpql.tools.spi.ITypeDeclaration;

public class CollectionEquivalentResolver
extends Resolver {
    private List<Resolver> resolvers;

    public CollectionEquivalentResolver(Resolver parent, List<Resolver> resolvers) {
        super(parent);
        this.resolvers = resolvers;
    }

    @Override
    protected IType buildType() {
        TypeHelper helper = this.getTypeHelper();
        IType unknownType = helper.unknownType();
        IType type = null;
        int count = this.resolvers.size();
        for (int index = 0; index < count; ++index) {
            IType anotherType = this.resolvers.get(index).getType();
            if (anotherType == unknownType) continue;
            if (type == null) {
                type = anotherType;
                continue;
            }
            if (type.equals(anotherType)) continue;
            return helper.objectType();
        }
        if (type == null) {
            type = unknownType;
        }
        return type;
    }

    @Override
    protected ITypeDeclaration buildTypeDeclaration() {
        return this.getType().getTypeDeclaration();
    }
}

