/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.rep;

import com.sleepycat.je.rep.ReplicatedEnvironment;
import com.sleepycat.je.rep.ReplicatedEnvironmentStats;
import com.sleepycat.je.rep.impl.networkRestore.NetworkBackupStats;
import com.sleepycat.je.rep.utilint.HostPortPair;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import oracle.kv.impl.rep.MasterRepNodeStats;
import oracle.kv.impl.rep.migration.PartitionMigrationStatus;
import oracle.kv.impl.util.ConfigurableService;
import oracle.kv.util.PingDisplay;

public class RepNodeStatus
implements Serializable,
PingDisplay.ServiceInfo {
    private static final long serialVersionUID = 1L;
    private final ConfigurableService.ServiceStatus status;
    private final ReplicatedEnvironment.State state;
    private final long vlsn;
    private final String haHostPort;
    private final PartitionMigrationStatus[] migrationStatus;
    private final int haPort;
    private final MasterRepNodeStats masterRepNodeStats;
    private final long availableLogSize;
    private final long usedLogSize;
    private final boolean isEnvStatsAvailable;
    private final NetworkBackupStats networkRestoreStats;
    private final boolean isAuthoritativeMaster;
    private String enabledRequestType;

    public RepNodeStatus(ConfigurableService.ServiceStatus status, ReplicatedEnvironment.State state, long vlsn, String haHostPort, String enabledRequestType, PartitionMigrationStatus[] migrationStatus, ReplicatedEnvironmentStats replicatedEnvStats, long availableLogSize, long usedLogSize, boolean isEnvStatsAvaialble, NetworkBackupStats networkRestoreStats, boolean isAuthoritativeMaster) {
        this.status = status;
        this.state = state;
        this.vlsn = vlsn;
        this.haHostPort = haHostPort;
        this.enabledRequestType = enabledRequestType;
        this.migrationStatus = migrationStatus;
        this.haPort = HostPortPair.getPort((String)haHostPort);
        this.masterRepNodeStats = MasterRepNodeStats.create(replicatedEnvStats);
        this.availableLogSize = availableLogSize;
        this.usedLogSize = usedLogSize;
        this.isEnvStatsAvailable = isEnvStatsAvaialble;
        this.networkRestoreStats = networkRestoreStats;
        this.isAuthoritativeMaster = isAuthoritativeMaster && state == ReplicatedEnvironment.State.MASTER;
    }

    @Override
    public ConfigurableService.ServiceStatus getServiceStatus() {
        return this.status;
    }

    @Override
    public ReplicatedEnvironment.State getReplicationState() {
        return this.state;
    }

    public long getVlsn() {
        return this.vlsn;
    }

    public int getHAPort() {
        return this.haPort;
    }

    public long getAvailableLogSize() {
        return this.availableLogSize;
    }

    public long getUsedLogSize() {
        return this.usedLogSize;
    }

    public boolean isEnvironmentStatsAvailable() {
        return this.isEnvStatsAvailable;
    }

    public String getHAHostPort() {
        return this.haHostPort;
    }

    public PartitionMigrationStatus[] getPartitionMigrationStatus() {
        return this.migrationStatus == null ? new PartitionMigrationStatus[]{} : this.migrationStatus;
    }

    public MasterRepNodeStats getMasterRepNodeStats() {
        return this.masterRepNodeStats;
    }

    public NetworkBackupStats getNetworkRestoreStats() {
        return this.networkRestoreStats;
    }

    @Override
    public boolean getIsAuthoritativeMaster() {
        return this.isAuthoritativeMaster;
    }

    public long getNetworkRestoreTimeSecs() {
        if (this.networkRestoreStats != null) {
            long remainingBytes = this.networkRestoreStats.getExpectedBytes() - this.networkRestoreStats.getTransferredBytes();
            double transferRate = this.networkRestoreStats.getTransferRate();
            return (long)Math.ceil((double)remainingBytes / transferRate);
        }
        return 0L;
    }

    public String getEnabledRequestType() {
        return this.enabledRequestType;
    }

    public String toString() {
        return (Object)((Object)this.status) + "," + (Object)((Object)this.state) + (this.state == ReplicatedEnvironment.State.MASTER && !this.isAuthoritativeMaster ? " (non-authoritative)" : "");
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.enabledRequestType == null) {
            this.enabledRequestType = "ALL";
        }
    }
}

