/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import oracle.kv.impl.fault.WrappedClientException;
import oracle.kv.impl.util.FastExternalizable;
import oracle.kv.impl.util.SerializationUtil;

public class QueryStateException
extends IllegalStateException
implements FastExternalizable {
    private static final long serialVersionUID = 1L;
    private final String stackTrace;

    public QueryStateException(String message) {
        super("Unexpected state in query engine:\n" + message);
        StringWriter sw = new StringWriter(500);
        new RuntimeException().printStackTrace(new PrintWriter(sw));
        this.stackTrace = sw.toString();
    }

    public void throwClientException() {
        throw new WrappedClientException(this);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(1000);
        sb.append(super.toString());
        sb.append("\nStack trace: ");
        sb.append(this.stackTrace);
        return sb.toString();
    }

    public QueryStateException(DataInput in, short serialVersion) throws IOException {
        super(SerializationUtil.readString(in, serialVersion));
        this.stackTrace = SerializationUtil.readString(in, serialVersion);
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        SerializationUtil.writeString(out, serialVersion, this.getMessage());
        SerializationUtil.writeString(out, serialVersion, this.stackTrace);
    }
}

