/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.async.perf;

import com.sleepycat.je.utilint.LongAvgRate;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class CountMetrics {
    private final String name;
    private final AtomicLong count = new AtomicLong();
    private final LongAvgRate averageRate;
    private volatile long resetCnt = 0L;
    private volatile long resetTimeMs = System.currentTimeMillis();
    private volatile long currCnt = 0L;

    public CountMetrics(String name, long periodMillis) {
        this.name = name;
        this.averageRate = new LongAvgRate("expoAvg", periodMillis, TimeUnit.SECONDS);
    }

    public long incrementAndGet() {
        return this.count.incrementAndGet();
    }

    public void update() {
        long value = this.count.get();
        this.averageRate.add(value, System.currentTimeMillis());
        this.currCnt = value;
    }

    public String get() {
        Snapshot snapshot = this.getSnapshot();
        this.reset();
        return String.format("[%s]%s", this.name, snapshot.toString());
    }

    public Snapshot getSnapshot() {
        long avg = this.averageRate.get();
        float curr = this.getCurrentRate();
        return new Snapshot(avg, curr);
    }

    private float getCurrentRate() {
        long currTimeMs = System.currentTimeMillis();
        long intervalMs = currTimeMs - this.resetTimeMs;
        if (intervalMs <= 0L) {
            return 0.0f;
        }
        return (float)(this.currCnt - this.resetCnt) / ((float)intervalMs / 1000.0f);
    }

    private void reset() {
        this.resetCnt = this.currCnt;
        this.resetTimeMs = System.currentTimeMillis();
    }

    public class Snapshot {
        private final long average;
        private final float current;

        private Snapshot(long average, float current) {
            this.average = average;
            this.current = current;
        }

        public long average() {
            return this.average;
        }

        public float current() {
            return this.current;
        }

        public String toString() {
            return String.format("avg=%d, curr=%.1f", this.average, Float.valueOf(this.current));
        }
    }
}

