/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper;

import commonj.sdo.DataObject;
import commonj.sdo.Property;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.descriptors.MethodAttributeAccessor;
import org.eclipse.persistence.sdo.SDODataObject;
import org.eclipse.persistence.sdo.SDOProperty;

public class SDOMethodAttributeAccessor
extends MethodAttributeAccessor {
    protected Class<?> attributeClass;
    protected SDOProperty property;

    public SDOMethodAttributeAccessor(Property property) {
        this.setProperty(property);
    }

    public SDOMethodAttributeAccessor(Property property, Class<?> attributeClass) {
        this.setProperty(property);
        this.attributeClass = attributeClass;
    }

    @Override
    public Class<?> getAttributeClass() {
        if (this.attributeClass != null) {
            return this.attributeClass;
        }
        return Object.class;
    }

    @Override
    public Object getAttributeValueFromObject(Object anObject) throws DescriptorException {
        boolean isSet = ((DataObject)anObject).isSet(this.getProperty());
        if (!isSet) {
            return null;
        }
        return ((DataObject)anObject).get(this.getProperty());
    }

    @Override
    public void initializeAttributes(Class<?> theJavaClass) throws DescriptorException {
        if (this.getAttributeName() == null) {
            throw DescriptorException.attributeNameNotSpecified();
        }
    }

    @Override
    public boolean isMethodAttributeAccessor() {
        return true;
    }

    @Override
    public void setAttributeValueInObject(Object domainObject, Object attributeValue) throws DescriptorException {
        ((SDODataObject)domainObject).setInternal(this.property, attributeValue, false);
    }

    public void setProperty(Property property) {
        this.property = (SDOProperty)property;
    }

    public Property getProperty() {
        return this.property;
    }

    @Override
    public Class<?> getGetMethodReturnType() {
        return this.attributeClass;
    }

    @Override
    public Class<?> getSetMethodParameterType() {
        return this.attributeClass;
    }
}

