/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.filetransfer;

import java.net.URLConnection;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smackx.FormField;
import org.jivesoftware.smackx.ServiceDiscoveryManager;
import org.jivesoftware.smackx.filetransfer.FaultTolerantNegotiator;
import org.jivesoftware.smackx.filetransfer.FileTransferRequest;
import org.jivesoftware.smackx.filetransfer.IBBTransferNegotiator;
import org.jivesoftware.smackx.filetransfer.Socks5TransferNegotiator;
import org.jivesoftware.smackx.filetransfer.StreamNegotiator;
import org.jivesoftware.smackx.packet.DataForm;
import org.jivesoftware.smackx.packet.StreamInitiation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileTransferNegotiator {
    private static final String[] NAMESPACE = new String[]{"http://jabber.org/protocol/si/profile/file-transfer", "http://jabber.org/protocol/si"};
    private static final Map<Connection, FileTransferNegotiator> transferObject = new ConcurrentHashMap<Connection, FileTransferNegotiator>();
    private static final String STREAM_INIT_PREFIX = "jsi_";
    protected static final String STREAM_DATA_FIELD_NAME = "stream-method";
    private static final Random randomGenerator = new SecureRandom();
    public static boolean IBB_ONLY = System.getProperty("ibb") != null;
    private final Connection connection;
    private final StreamNegotiator byteStreamTransferManager;
    private final StreamNegotiator inbandTransferManager;

    public static FileTransferNegotiator getInstanceFor(Connection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("Connection cannot be null");
        }
        if (!connection.isConnected()) {
            return null;
        }
        if (transferObject.containsKey(connection)) {
            return transferObject.get(connection);
        }
        FileTransferNegotiator transfer = new FileTransferNegotiator(connection);
        FileTransferNegotiator.setServiceEnabled(connection, true);
        transferObject.put(connection, transfer);
        return transfer;
    }

    public static void setServiceEnabled(Connection connection, boolean isEnabled) {
        ServiceDiscoveryManager manager = ServiceDiscoveryManager.getInstanceFor(connection);
        ArrayList<String> namespaces = new ArrayList<String>();
        namespaces.addAll(Arrays.asList(NAMESPACE));
        namespaces.add("http://jabber.org/protocol/ibb");
        if (!IBB_ONLY) {
            namespaces.add("http://jabber.org/protocol/bytestreams");
        }
        for (String namespace : namespaces) {
            if (isEnabled) {
                if (manager.includesFeature(namespace)) continue;
                manager.addFeature(namespace);
                continue;
            }
            manager.removeFeature(namespace);
        }
    }

    public static boolean isServiceEnabled(Connection connection) {
        ServiceDiscoveryManager manager = ServiceDiscoveryManager.getInstanceFor(connection);
        ArrayList<String> namespaces = new ArrayList<String>();
        namespaces.addAll(Arrays.asList(NAMESPACE));
        namespaces.add("http://jabber.org/protocol/ibb");
        if (!IBB_ONLY) {
            namespaces.add("http://jabber.org/protocol/bytestreams");
        }
        for (String namespace : namespaces) {
            if (manager.includesFeature(namespace)) continue;
            return false;
        }
        return true;
    }

    public static IQ createIQ(String ID, String to, String from, IQ.Type type) {
        IQ iqPacket = new IQ(){

            public String getChildElementXML() {
                return null;
            }
        };
        iqPacket.setPacketID(ID);
        iqPacket.setTo(to);
        iqPacket.setFrom(from);
        iqPacket.setType(type);
        return iqPacket;
    }

    public static Collection<String> getSupportedProtocols() {
        ArrayList<String> protocols = new ArrayList<String>();
        protocols.add("http://jabber.org/protocol/ibb");
        if (!IBB_ONLY) {
            protocols.add("http://jabber.org/protocol/bytestreams");
        }
        return Collections.unmodifiableList(protocols);
    }

    private FileTransferNegotiator(Connection connection) {
        this.configureConnection(connection);
        this.connection = connection;
        this.byteStreamTransferManager = new Socks5TransferNegotiator(connection);
        this.inbandTransferManager = new IBBTransferNegotiator(connection);
    }

    private void configureConnection(final Connection connection) {
        connection.addConnectionListener(new ConnectionListener(){

            public void connectionClosed() {
                FileTransferNegotiator.this.cleanup(connection);
            }

            public void connectionClosedOnError(Exception e) {
                FileTransferNegotiator.this.cleanup(connection);
            }

            public void reconnectionFailed(Exception e) {
            }

            public void reconnectionSuccessful() {
            }

            public void reconnectingIn(int seconds) {
            }
        });
    }

    private void cleanup(Connection connection) {
        if (transferObject.remove(connection) != null) {
            this.inbandTransferManager.cleanup();
        }
    }

    public StreamNegotiator selectStreamNegotiator(FileTransferRequest request) throws XMPPException {
        StreamNegotiator selectedStreamNegotiator;
        StreamInitiation si = request.getStreamInitiation();
        FormField streamMethodField = this.getStreamMethodField(si.getFeatureNegotiationForm());
        if (streamMethodField == null) {
            String errorMessage = "No stream methods contained in packet.";
            XMPPError error = new XMPPError(XMPPError.Condition.bad_request, errorMessage);
            IQ iqPacket = FileTransferNegotiator.createIQ(si.getPacketID(), si.getFrom(), si.getTo(), IQ.Type.ERROR);
            iqPacket.setError(error);
            this.connection.sendPacket(iqPacket);
            throw new XMPPException(errorMessage, error);
        }
        try {
            selectedStreamNegotiator = this.getNegotiator(streamMethodField);
        }
        catch (XMPPException e) {
            IQ iqPacket = FileTransferNegotiator.createIQ(si.getPacketID(), si.getFrom(), si.getTo(), IQ.Type.ERROR);
            iqPacket.setError(e.getXMPPError());
            this.connection.sendPacket(iqPacket);
            throw e;
        }
        return selectedStreamNegotiator;
    }

    private FormField getStreamMethodField(DataForm form) {
        FormField field = null;
        Iterator<FormField> it = form.getFields();
        while (it.hasNext()) {
            field = it.next();
            if (field.getVariable().equals(STREAM_DATA_FIELD_NAME)) break;
            field = null;
        }
        return field;
    }

    private StreamNegotiator getNegotiator(FormField field) throws XMPPException {
        boolean isByteStream = false;
        boolean isIBB = false;
        Iterator<FormField.Option> it = field.getOptions();
        while (it.hasNext()) {
            String variable = it.next().getValue();
            if (variable.equals("http://jabber.org/protocol/bytestreams") && !IBB_ONLY) {
                isByteStream = true;
                continue;
            }
            if (!variable.equals("http://jabber.org/protocol/ibb")) continue;
            isIBB = true;
        }
        if (!isByteStream && !isIBB) {
            XMPPError error = new XMPPError(XMPPError.Condition.bad_request, "No acceptable transfer mechanism");
            throw new XMPPException(error.getMessage(), error);
        }
        if (isByteStream && isIBB) {
            return new FaultTolerantNegotiator(this.connection, this.byteStreamTransferManager, this.inbandTransferManager);
        }
        if (isByteStream) {
            return this.byteStreamTransferManager;
        }
        return this.inbandTransferManager;
    }

    public void rejectStream(StreamInitiation si) {
        XMPPError error = new XMPPError(XMPPError.Condition.forbidden, "Offer Declined");
        IQ iqPacket = FileTransferNegotiator.createIQ(si.getPacketID(), si.getFrom(), si.getTo(), IQ.Type.ERROR);
        iqPacket.setError(error);
        this.connection.sendPacket(iqPacket);
    }

    public String getNextStreamID() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(STREAM_INIT_PREFIX);
        buffer.append(Math.abs(randomGenerator.nextLong()));
        return buffer.toString();
    }

    public StreamNegotiator negotiateOutgoingTransfer(String userID, String streamID, String fileName, long size, String desc, int responseTimeout) throws XMPPException {
        StreamInitiation si = new StreamInitiation();
        si.setSesssionID(streamID);
        si.setMimeType(URLConnection.guessContentTypeFromName(fileName));
        StreamInitiation.File siFile = new StreamInitiation.File(fileName, size);
        siFile.setDesc(desc);
        si.setFile(siFile);
        si.setFeatureNegotiationForm(this.createDefaultInitiationForm());
        si.setFrom(this.connection.getUser());
        si.setTo(userID);
        si.setType(IQ.Type.SET);
        PacketCollector collector = this.connection.createPacketCollector(new PacketIDFilter(si.getPacketID()));
        this.connection.sendPacket(si);
        Packet siResponse = collector.nextResult(responseTimeout);
        collector.cancel();
        if (siResponse instanceof IQ) {
            IQ iqResponse = (IQ)siResponse;
            if (iqResponse.getType().equals(IQ.Type.RESULT)) {
                StreamInitiation response = (StreamInitiation)siResponse;
                return this.getOutgoingNegotiator(this.getStreamMethodField(response.getFeatureNegotiationForm()));
            }
            if (iqResponse.getType().equals(IQ.Type.ERROR)) {
                throw new XMPPException(iqResponse.getError());
            }
            throw new XMPPException("File transfer response unreadable");
        }
        return null;
    }

    private StreamNegotiator getOutgoingNegotiator(FormField field) throws XMPPException {
        boolean isByteStream = false;
        boolean isIBB = false;
        Iterator<String> it = field.getValues();
        while (it.hasNext()) {
            String variable = it.next();
            if (variable.equals("http://jabber.org/protocol/bytestreams") && !IBB_ONLY) {
                isByteStream = true;
                continue;
            }
            if (!variable.equals("http://jabber.org/protocol/ibb")) continue;
            isIBB = true;
        }
        if (!isByteStream && !isIBB) {
            XMPPError error = new XMPPError(XMPPError.Condition.bad_request, "No acceptable transfer mechanism");
            throw new XMPPException(error.getMessage(), error);
        }
        if (isByteStream && isIBB) {
            return new FaultTolerantNegotiator(this.connection, this.byteStreamTransferManager, this.inbandTransferManager);
        }
        if (isByteStream) {
            return this.byteStreamTransferManager;
        }
        return this.inbandTransferManager;
    }

    private DataForm createDefaultInitiationForm() {
        DataForm form = new DataForm("form");
        FormField field = new FormField(STREAM_DATA_FIELD_NAME);
        field.setType("list-single");
        if (!IBB_ONLY) {
            field.addOption(new FormField.Option("http://jabber.org/protocol/bytestreams"));
        }
        field.addOption(new FormField.Option("http://jabber.org/protocol/ibb"));
        form.addField(field);
        return form;
    }
}

