/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.osgi.services.remoteserviceadmin.console;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Converter;
import org.apache.felix.service.command.Descriptor;
import org.apache.felix.service.command.Parameter;
import org.eclipse.ecf.console.AbstractCommand;
import org.eclipse.ecf.core.IContainerManager;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IIDFactory;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.DebugRemoteServiceAdminListener;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.EndpointDescription;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.EndpointDescriptionReader;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.EndpointDescriptionWriter;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.RemoteServiceAdmin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.remoteserviceadmin.ExportReference;
import org.osgi.service.remoteserviceadmin.ExportRegistration;
import org.osgi.service.remoteserviceadmin.ImportReference;
import org.osgi.service.remoteserviceadmin.ImportRegistration;
import org.osgi.service.remoteserviceadmin.RemoteServiceAdminListener;

@Component(immediate=true, property={"osgi.command.scope=ecf", "osgi.command.function=listexports", "osgi.command.function=lexps", "osgi.command.function=listimports", "osgi.command.function=limps", "osgi.command.function=unexportservice", "osgi.command.function=unexpsvc", "osgi.command.function=unimportservice", "osgi.command.function=unimpsvc", "osgi.command.function=rsadebug", "osgi.command.function=exportservice", "osgi.command.function=expsvc", "osgi.command.function=importservice", "osgi.command.function=impsvc", "osgi.command.function=updateservice", "osgi.command.function=updsvc"}, service={RSACommand.class, Converter.class})
public class RSACommand
extends AbstractCommand
implements Converter {
    private static final String DEFAULT_EXPORT_CONFIG = System.getProperty("org.eclipse.ecf.osgi.services.remoteserviceadmin.console.defaultconfig", "ecf.generic.server");
    private static final boolean DEBUGON = Boolean.parseBoolean(System.getProperty("org.eclipse.ecf.osgi.services.remoteserviceadmin.console.rsadebug", "true"));
    private static final String EXPORT_LINE_FORMAT = System.getProperty("org.eclipse.ecf.osgi.services.remoteserviceadmin.console.exportlineformat", "%1$-37s|%2$-45s|%3$s");
    private static final String IMPORT_LINE_FORMAT = System.getProperty("org.eclipse.ecf.osgi.services.remoteserviceadmin.console.importlineformat", "%1$-37s|%2$-45s|%3$s");
    private IContainerManager containerManager;
    private IIDFactory idFactory;
    private RemoteServiceAdmin rsa;
    private BundleContext context;
    private ServiceRegistration<?> debugReg;

    @Reference
    void bindContainerManager(IContainerManager cm) {
        this.containerManager = cm;
    }

    void unbindContainerManager(IContainerManager cm) {
        this.containerManager = null;
    }

    @Reference
    void bindIDFactory(IIDFactory idf) {
        this.idFactory = idf;
    }

    void unbindIDFactory(IIDFactory idf) {
        this.idFactory = null;
    }

    @Reference
    void bindRSA(org.osgi.service.remoteserviceadmin.RemoteServiceAdmin rsa) {
        this.rsa = (RemoteServiceAdmin)rsa;
    }

    void unbindRSA(org.osgi.service.remoteserviceadmin.RemoteServiceAdmin rsa) {
        this.rsa = null;
    }

    protected IContainerManager getContainerManager() {
        return this.containerManager;
    }

    protected IIDFactory getIDFactory() {
        return this.idFactory;
    }

    private RemoteServiceAdmin getRSA() {
        return this.rsa;
    }

    private List<RemoteServiceAdmin.ExportReference> getExports() {
        ArrayList<RemoteServiceAdmin.ExportReference> results = new ArrayList<RemoteServiceAdmin.ExportReference>();
        for (ExportReference er : this.getRSA().getExportedServices()) {
            results.add((RemoteServiceAdmin.ExportReference)er);
        }
        return results;
    }

    private List<RemoteServiceAdmin.ImportReference> getImports() {
        ArrayList<RemoteServiceAdmin.ImportReference> results = new ArrayList<RemoteServiceAdmin.ImportReference>();
        for (ImportReference er : this.getRSA().getImportedEndpoints()) {
            results.add((RemoteServiceAdmin.ImportReference)er);
        }
        return results;
    }

    public Object convert(Class<?> desiredType, Object in) throws Exception {
        if (desiredType == RemoteServiceAdmin.ExportReference.class && in instanceof String) {
            return this.getExportReferenceForIdOrContainerId((String)in);
        }
        if (desiredType == RemoteServiceAdmin.ExportReference.class && in instanceof Long) {
            return this.getExportReferenceForServiceId((Long)in);
        }
        if (desiredType == RemoteServiceAdmin.ImportReference.class && in instanceof String) {
            return this.getImportReferenceForIdOrContainerId((String)in);
        }
        if (desiredType == RemoteServiceAdmin.ExportReference.class && in instanceof Long) {
            return this.getImportReferenceForServiceId((Long)in);
        }
        return null;
    }

    private String formatExportReference(RemoteServiceAdmin.ExportReference er, int level, Converter escape) {
        EndpointDescription ed = (EndpointDescription)er.getExportedEndpoint();
        if (ed == null) {
            return null;
        }
        return this.formatReference(EXPORT_LINE_FORMAT, ed, ed.getContainerID().getName(), ed.getServiceId(), level, escape);
    }

    private String formatReference(String lineFormat, EndpointDescription ed, String containerId, long serviceId, int level, Converter escape) {
        if (ed == null) {
            return null;
        }
        switch (level) {
            case 2: {
                return null;
            }
            case 1: {
                return this.formatLine(lineFormat, new Object[]{ed.getId(), containerId, serviceId});
            }
            case 0: {
                return this.formatEndpoint(ed);
            }
        }
        return null;
    }

    private String formatImportReference(RemoteServiceAdmin.ImportReference ir, int level, Converter escape) {
        ID localContainerID = ir.getLocalContainerID();
        if (localContainerID == null) {
            return null;
        }
        ServiceReference ref = ir.getImportedService();
        if (ref == null) {
            return null;
        }
        return this.formatReference(IMPORT_LINE_FORMAT, (EndpointDescription)ir.getImportedEndpoint(), localContainerID.getName(), (Long)ref.getProperty("service.id"), level, escape);
    }

    private String formatEndpoint(EndpointDescription ed) {
        EndpointDescriptionWriter edw = new EndpointDescriptionWriter();
        StringWriter sw = new StringWriter();
        try {
            edw.writeEndpointDescription((Writer)sw, (org.osgi.service.remoteserviceadmin.EndpointDescription)ed);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return this.formatLine("%s", new Object[]{sw.toString()});
    }

    public String format(Object target, int level, Converter escape) {
        if (target instanceof RemoteServiceAdmin.ExportReference) {
            return this.formatExportReference((RemoteServiceAdmin.ExportReference)target, level, escape);
        }
        if (target instanceof RemoteServiceAdmin.ImportReference) {
            return this.formatImportReference((RemoteServiceAdmin.ImportReference)target, level, escape);
        }
        return null;
    }

    @Activate
    void activate(BundleContext context) {
        this.context = context;
        if (DEBUGON) {
            this.debugOn();
        }
    }

    @Deactivate
    void deactivate() {
        this.debugOff();
    }

    synchronized void debugOff() {
        if (this.debugReg != null) {
            this.debugReg.unregister();
            this.debugReg = null;
        }
    }

    synchronized void debugOn() {
        if (this.debugReg == null) {
            this.debugReg = this.context.registerService(RemoteServiceAdminListener.class, (Object)new DebugRemoteServiceAdminListener(), null);
        }
    }

    private RemoteServiceAdmin.ExportReference getExportReferenceForIdOrContainerId(String exportRefId) {
        for (RemoteServiceAdmin.ExportReference r : this.getExports()) {
            EndpointDescription ed = (EndpointDescription)r.getExportedEndpoint();
            if (ed == null || !ed.getId().equals(exportRefId) && !ed.getContainerID().getName().equals(exportRefId)) continue;
            return r;
        }
        return null;
    }

    private RemoteServiceAdmin.ExportRegistration getExportRegistrationForId(String id) {
        for (RemoteServiceAdmin.ExportRegistration r : this.getRSA().getExportedRegistrations()) {
            EndpointDescription ed;
            RemoteServiceAdmin.ExportReference er = (RemoteServiceAdmin.ExportReference)r.getExportReference();
            if (er == null || (ed = (EndpointDescription)er.getExportedEndpoint()) == null || !ed.getId().equals(id)) continue;
            return r;
        }
        return null;
    }

    private RemoteServiceAdmin.ImportRegistration getImportRegistrationForId(String id) {
        for (RemoteServiceAdmin.ImportRegistration r : this.getRSA().getImportedRegistrations()) {
            EndpointDescription ed;
            RemoteServiceAdmin.ImportReference er = (RemoteServiceAdmin.ImportReference)r.getImportReference();
            if (er == null || (ed = (EndpointDescription)er.getImportedEndpoint()) == null || !ed.getId().equals(id)) continue;
            return r;
        }
        return null;
    }

    private RemoteServiceAdmin.ExportReference getExportReferenceForServiceId(Long serviceId) {
        for (RemoteServiceAdmin.ExportReference r : this.getExports()) {
            EndpointDescription ed = (EndpointDescription)r.getExportedEndpoint();
            if (ed == null || ed.getServiceId() != serviceId.longValue()) continue;
            return r;
        }
        return null;
    }

    private RemoteServiceAdmin.ImportReference getImportReferenceForServiceId(Long serviceId) {
        for (RemoteServiceAdmin.ImportReference r : this.getImports()) {
            EndpointDescription ed = (EndpointDescription)r.getImportedEndpoint();
            if (ed == null || ed.getServiceId() != serviceId.longValue()) continue;
            return r;
        }
        return null;
    }

    private RemoteServiceAdmin.ImportReference getImportReferenceForIdOrContainerId(String importRefId) {
        for (RemoteServiceAdmin.ImportReference r : this.getImports()) {
            EndpointDescription ed = (EndpointDescription)r.getImportedEndpoint();
            if (ed == null || !ed.getId().equals(importRefId) && !ed.getContainerID().getName().equals(importRefId)) continue;
            return r;
        }
        return null;
    }

    @Descriptor(value="List RSA exported services")
    public List<RemoteServiceAdmin.ExportReference> listexports(CommandSession cs) {
        this.consoleLine(cs, EXPORT_LINE_FORMAT, new Object[]{"endpoint.id", "Exporting Container ID", "Exported Service Id\n"});
        return this.getExports();
    }

    @Descriptor(value="List RSA exported services")
    public List<RemoteServiceAdmin.ExportReference> lexps(CommandSession cs) {
        return this.listexports(cs);
    }

    @Descriptor(value="Details about a single RSA exported service")
    public RemoteServiceAdmin.ExportReference listexports(@Descriptor(value="The endpoint.id of the exported service") RemoteServiceAdmin.ExportReference r) {
        return r;
    }

    @Descriptor(value="Details about a single RSA exported service")
    public RemoteServiceAdmin.ExportReference lexps(@Descriptor(value="The endpoint.id of the exported service") RemoteServiceAdmin.ExportReference r) {
        return r;
    }

    @Descriptor(value="List RSA imported services")
    public List<RemoteServiceAdmin.ImportReference> listimports(CommandSession cs) {
        this.consoleLine(cs, IMPORT_LINE_FORMAT, new Object[]{"endpoint.id", "Importing Container ID", "Imported Service Id\n"});
        return this.getImports();
    }

    @Descriptor(value="List RSA imported services")
    public List<RemoteServiceAdmin.ImportReference> limps(CommandSession cs) {
        return this.listimports(cs);
    }

    @Descriptor(value="Details about a single RSA imported service")
    public RemoteServiceAdmin.ImportReference listimports(@Descriptor(value="The endpoint.id of the exported service") RemoteServiceAdmin.ImportReference r) {
        return r;
    }

    @Descriptor(value="Details about a single RSA imported service")
    public RemoteServiceAdmin.ImportReference limps(@Descriptor(value="The endpoint.id of the exported service") RemoteServiceAdmin.ImportReference r) {
        return r;
    }

    @Descriptor(value="Unexport an RSA exported service")
    public String unexportservice(@Descriptor(value="The endpoint.id of the exported service") String endpointId) {
        RemoteServiceAdmin.ExportRegistration reg = this.getExportRegistrationForId(endpointId);
        if (reg != null) {
            reg.close();
            return endpointId + " unexported";
        }
        return endpointId + " not found";
    }

    @Descriptor(value="Unexport an RSA exported service")
    public String unexpsvc(@Descriptor(value="The endpoint.id of the exported service") String endpointId) {
        return this.unexportservice(endpointId);
    }

    @Descriptor(value="Unimport an RSA imported service")
    public String unimportservice(@Descriptor(value="The endpoint.id of the imported service") String endpointId) {
        RemoteServiceAdmin.ImportRegistration reg = this.getImportRegistrationForId(endpointId);
        if (reg != null) {
            reg.close();
            return endpointId + " unimported";
        }
        return endpointId + " not found";
    }

    @Descriptor(value="Unimport an RSA imported service")
    public String unimpsvc(@Descriptor(value="The endpoint.id of the imported service") String endpointId) {
        return this.unimportservice(endpointId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Descriptor(value="Toggle whether RSA debug output is output to console")
    public String rsadebug() {
        RSACommand rSACommand = this;
        synchronized (rSACommand) {
            return this.rsadebug(this.debugReg == null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Descriptor(value="Set whether RSA debug output is output to console")
    public String rsadebug(@Descriptor(value="Whether to turn debug on or off") boolean on) {
        RSACommand rSACommand = this;
        synchronized (rSACommand) {
            block8: {
                block6: {
                    block7: {
                        if (this.debugReg != null) break block6;
                        if (!on) break block7;
                        this.debugOn();
                        return "RSA debugging ON";
                    }
                    return "RSA debugging already off";
                }
                if (!on) break block8;
                return "RSA debugging already on";
            }
            this.debugOff();
            return "RSA debugging OFF";
        }
    }

    @Descriptor(value="Export a service via Remote Service Admin")
    public RemoteServiceAdmin.ExportReference exportservice(CommandSession cs, @Descriptor(value="service.id of service to export") long serviceid, @Descriptor(value="Map of service properties for exporting the service") Map<String, ?> map) {
        Collection regs;
        HashMap<String, String> op;
        ServiceReference ref = null;
        try {
            ServiceReference[] refs = this.context.getAllServiceReferences(null, "(service.id=" + String.valueOf(serviceid) + ")");
            if (refs == null || refs.length < 1) {
                cs.getConsole().println("Cannot find registered service with service.id=" + String.valueOf(serviceid));
            }
            ref = refs[0];
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace(cs.getConsole());
            return null;
        }
        HashMap<String, String> hashMap = op = map == null ? new HashMap<String, String>() : new HashMap(map);
        if (!op.containsKey("service.exported.interfaces")) {
            op.put("service.exported.interfaces", "*");
        }
        if (!op.containsKey("service.exported.configs")) {
            op.put("service.exported.configs", DEFAULT_EXPORT_CONFIG);
        }
        if ((regs = this.getRSA().exportService(ref, op)) != null) {
            for (ExportRegistration reg : regs) {
                Throwable t = reg.getException();
                if (t != null) {
                    t.printStackTrace(cs.getConsole());
                    continue;
                }
                RemoteServiceAdmin.ExportReference er = (RemoteServiceAdmin.ExportReference)reg.getExportReference();
                if (er == null) continue;
                cs.getConsole().println("service.id=" + String.valueOf(serviceid) + " successfully exported with endpoint description:");
                return er;
            }
        }
        return null;
    }

    @Descriptor(value="Export a service via Remote Service Admin")
    public RemoteServiceAdmin.ExportReference exportservice(CommandSession cs, @Descriptor(value="service.id of service to export") long serviceid) {
        return this.exportservice(cs, serviceid, null);
    }

    @Descriptor(value="Export a service via Remote Service Admin")
    public RemoteServiceAdmin.ExportReference expsvc(CommandSession cs, @Descriptor(value="service.id of service to export") long serviceid, @Descriptor(value="Map of service properties for exporting the service") Map<String, ?> map) {
        return this.exportservice(cs, serviceid, map);
    }

    @Descriptor(value="Export a service via Remote Service Admin")
    public RemoteServiceAdmin.ExportReference expsvc(CommandSession cs, @Descriptor(value="service.id of service to export") long serviceid) {
        return this.exportservice(cs, serviceid, null);
    }

    @Descriptor(value="Import a remote service via Remote Service Admin.  If -e is used, the given endpoint URL is read to read the EndpointDescription.  If not used, an EndpointDescription is expected from the console input (e.g. copy and paste)")
    public RemoteServiceAdmin.ImportReference importservice(CommandSession cs, @Descriptor(value="Optional URL indicating location of an Endpoint Description (EDEF format)") @Parameter(names={"-e", "--edefurl"}, absentValue="") String endpointurl) {
        InputStream ins = null;
        URL url = null;
        if ("".equals(endpointurl)) {
            ins = cs.getKeyboard();
            cs.getConsole().println("Waiting for console input.   To complete enter an empty line...");
        } else {
            try {
                url = new URL(endpointurl);
                ins = url.openStream();
            }
            catch (IOException e) {
                e.printStackTrace(cs.getConsole());
            }
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(ins));
        StringBuffer buf = new StringBuffer();
        try {
            String line;
            while ((line = br.readLine()) != null && line.length() > 0) {
                buf.append(line).append("\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace(cs.getConsole());
            return null;
        }
        if (url != null) {
            try {
                ins.close();
            }
            catch (IOException e) {
                e.printStackTrace(cs.getConsole());
            }
        }
        ByteArrayInputStream bins = new ByteArrayInputStream(buf.toString().getBytes());
        EndpointDescriptionReader r = new EndpointDescriptionReader();
        org.osgi.service.remoteserviceadmin.EndpointDescription[] eds = null;
        try {
            eds = r.readEndpointDescriptions((InputStream)bins);
        }
        catch (IOException e) {
            e.printStackTrace(cs.getConsole());
            return null;
        }
        ImportRegistration reg = this.getRSA().importService(eds[0]);
        if (reg == null) {
            return null;
        }
        Throwable t = reg.getException();
        if (t != null) {
            t.printStackTrace(cs.getConsole());
            return null;
        }
        RemoteServiceAdmin.ImportReference ir = (RemoteServiceAdmin.ImportReference)reg.getImportReference();
        if (ir != null) {
            EndpointDescription ed = (EndpointDescription)ir.getImportedEndpoint();
            if (ed == null) {
                cs.getConsole().println("Cannot get endpoint description for imported endpoint");
                return null;
            }
            cs.getConsole().println("endpoint.id=" + ed.getId() + " with service.id=" + String.valueOf(ir.getImportedService().getProperty("service.id")) + " successfully imported:");
            return ir;
        }
        return null;
    }

    @Descriptor(value="Import a remote service via Remote Service Admin.  If -e|-edefurl is used, the given endpoint URL is read to read the EndpointDescription.  If not used, an EndpointDescription is expected from the console input (e.g. copy and paste)")
    public RemoteServiceAdmin.ImportReference impsvc(CommandSession cs, @Descriptor(value="Optional URL indicating location of an Endpoint Description (EDEF format)") @Parameter(names={"-e", "--edefurl"}, absentValue="") String endpointurl) {
        return this.importservice(cs, endpointurl);
    }

    @Descriptor(value="Update the properties of a remote service via Remote Service Admin")
    public RemoteServiceAdmin.ExportReference updateservice(CommandSession cs, @Descriptor(value="endpoint.id of remote service to update") String endpointid, @Descriptor(value="Map of properties for update") Map<String, ?> map) {
        RemoteServiceAdmin.ExportRegistration ereg = this.getExportRegistrationForId(endpointid);
        if (ereg == null) {
            cs.getConsole().println("Cannot find export with endpoint.id=" + endpointid);
            return null;
        }
        RemoteServiceAdmin.ExportReference eref = (RemoteServiceAdmin.ExportReference)ereg.getExportReference();
        if (eref == null) {
            cs.getConsole().println("The remote service with endpoint.id=" + endpointid + " has been closed");
            return null;
        }
        ereg.update(map);
        cs.getConsole().println("The endpoint.id=" + endpointid + " has been updated");
        return eref;
    }

    @Descriptor(value="Update the properties of a remote service via Remote Service Admin")
    public RemoteServiceAdmin.ExportReference updsvc(CommandSession cs, @Descriptor(value="endpoint.id of remote service to update") String endpointid, @Descriptor(value="Map of properties for update") Map<String, ?> map) {
        return this.updateservice(cs, endpointid, map);
    }
}

