package org.mandas.docker.client.messages.swarm;

import java.util.Objects;

/**
 * Immutable implementation of {@link GlobalJob}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableGlobalJob.builder()}.
 */
@SuppressWarnings({"all"})
final class ImmutableGlobalJob implements GlobalJob {

  private ImmutableGlobalJob(ImmutableGlobalJob.Builder builder) {
  }

  /**
   * This instance is equal to all instances of {@code ImmutableGlobalJob} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableGlobalJob
        && equalsByValue((ImmutableGlobalJob) another);
  }

  @SuppressWarnings("MethodCanBeStatic")
  private boolean equalsByValue(ImmutableGlobalJob another) {
    return true;
  }

  /**
   * Returns a constant hash code value.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return -394622690;
  }

  /**
   * Prints the immutable value {@code GlobalJob}.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GlobalJob{}";
  }

  /**
   * Creates an immutable copy of a {@link GlobalJob} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable GlobalJob instance
   */
  public static ImmutableGlobalJob copyOf(GlobalJob instance) {
    if (instance instanceof ImmutableGlobalJob) {
      return (ImmutableGlobalJob) instance;
    }
    return ImmutableGlobalJob.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableGlobalJob ImmutableGlobalJob}.
   * <pre>
   * ImmutableGlobalJob.builder()
   *    .build();
   * </pre>
   * @return A new ImmutableGlobalJob builder
   */
  public static ImmutableGlobalJob.Builder builder() {
    return new ImmutableGlobalJob.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableGlobalJob ImmutableGlobalJob}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  static final class Builder implements GlobalJob.Builder {

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GlobalJob} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GlobalJob instance) {
      Objects.requireNonNull(instance, "instance");
      return this;
    }

    /**
     * Builds a new {@link ImmutableGlobalJob ImmutableGlobalJob}.
     * @return An immutable instance of GlobalJob
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableGlobalJob build() {
      return new ImmutableGlobalJob(this);
    }
  }
}
