/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.service.policy.ui;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.wst.ws.internal.service.policy.ui.BaseOperationImpl;
import org.eclipse.wst.ws.service.policy.IDescriptor;
import org.eclipse.wst.ws.service.policy.IPolicyState;
import org.eclipse.wst.ws.service.policy.IServicePolicy;
import org.eclipse.wst.ws.service.policy.ui.IPolicyOperation;

public class PolicyOperationImpl
implements IPolicyOperation {
    private BaseOperationImpl baseOperation;
    private IServicePolicy policy;

    public PolicyOperationImpl(BaseOperationImpl baseOperation, IServicePolicy policy) {
        this.baseOperation = baseOperation;
        this.policy = policy;
    }

    @Override
    public String getDefaultItem() {
        return this.baseOperation.getDefaultItem();
    }

    @Override
    public IDescriptor getDescriptor() {
        return this.baseOperation.getDescriptor();
    }

    @Override
    public String getEnumerationId() {
        return this.baseOperation.getEnumerationId();
    }

    @Override
    public String getId() {
        return this.baseOperation.getId();
    }

    @Override
    public IPolicyOperation.OperationKind getOperationKind() {
        return this.baseOperation.getOperationKind();
    }

    @Override
    public String getPolicyIdPattern() {
        return this.baseOperation.getPolicyIdPattern();
    }

    @Override
    public boolean isEnabled(List<IServicePolicy> selectedPolicies) {
        return this.baseOperation.isEnabled(selectedPolicies);
    }

    @Override
    public boolean isWorkspaceOnly() {
        return this.baseOperation.isWorkspaceOnly();
    }

    @Override
    public void launchOperation(List<IServicePolicy> selectedPolicies) {
        this.baseOperation.launchOperation(this.policy, selectedPolicies);
    }

    @Override
    public IServicePolicy getServicePolicy() {
        return this.policy;
    }

    @Override
    public String getStateItem(IProject project) {
        IPolicyState state = this.getState(project);
        String key = this.baseOperation.getId();
        String defaultItem = this.baseOperation.getDefaultItem();
        if (this.baseOperation.isUseDefaultData()) {
            key = "default.value.key";
        }
        if (defaultItem != null) {
            state.putDefaultValue(key, defaultItem, false);
        }
        return state.getValue(key);
    }

    @Override
    public void setStateItem(IProject project, String stateItem) {
        IPolicyState state = this.getState(project);
        String key = this.baseOperation.getId();
        if (this.baseOperation.isUseDefaultData()) {
            key = "default.value.key";
        }
        state.putValue(key, stateItem);
    }

    private IPolicyState getState(IProject project) {
        return project == null ? this.policy.getPolicyState() : this.policy.getPolicyState(project);
    }

    @Override
    public boolean isUseDefaultData() {
        return this.baseOperation.isUseDefaultData();
    }
}

