/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import org.eclipse.wst.jsdt.core.ast.IJsDocArgumentExpression;
import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.Argument;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeReference;
import org.eclipse.wst.jsdt.internal.compiler.impl.Constant;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ClassScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Scope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;

public class JavadocArgumentExpression
extends Expression
implements IJsDocArgumentExpression {
    public char[] token;
    public Argument argument;

    public JavadocArgumentExpression(char[] name, int startPos, int endPos, TypeReference typeRef) {
        this.token = name;
        this.sourceStart = startPos;
        this.sourceEnd = endPos;
        long pos = ((long)startPos << 32) + (long)endPos;
        this.argument = new Argument(name, pos, typeRef, 0);
        this.bits |= 0x8000;
    }

    private TypeBinding internalResolveType(Scope scope) {
        TypeReference typeRef;
        this.constant = Constant.NotAConstant;
        if (this.resolvedType != null) {
            return this.resolvedType.isValidBinding() ? this.resolvedType : null;
        }
        if (this.argument != null && (typeRef = this.argument.type) != null) {
            typeRef.resolvedType = this.resolvedType = typeRef.getTypeBinding(scope);
            if (!this.resolvedType.isValidBinding()) {
                scope.problemReporter().javadocInvalidType(typeRef, this.resolvedType, scope.getDeclarationModifiers());
                return null;
            }
            if (this.isTypeUseDeprecated(this.resolvedType, scope)) {
                scope.problemReporter().javadocDeprecatedType(this.resolvedType, typeRef, scope.getDeclarationModifiers());
            }
            return this.resolvedType;
        }
        return null;
    }

    @Override
    public StringBuffer printExpression(int indent, StringBuffer output) {
        if (this.argument == null) {
            if (this.token != null) {
                output.append(this.token);
            }
        } else {
            this.argument.print(indent, output);
        }
        return output;
    }

    @Override
    public void resolve(BlockScope scope) {
        if (this.argument != null) {
            this.argument.resolve(scope);
        }
    }

    @Override
    public TypeBinding resolveType(BlockScope scope) {
        return this.internalResolveType(scope);
    }

    @Override
    public TypeBinding resolveType(ClassScope scope) {
        return this.internalResolveType(scope);
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope blockScope) {
        if (visitor.visit(this, blockScope) && this.argument != null) {
            this.argument.traverse(visitor, blockScope);
        }
        visitor.endVisit(this, blockScope);
    }

    @Override
    public void traverse(ASTVisitor visitor, ClassScope blockScope) {
        if (visitor.visit(this, blockScope) && this.argument != null) {
            this.argument.traverse(visitor, blockScope);
        }
        visitor.endVisit(this, blockScope);
    }

    @Override
    public int getASTType() {
        return 53;
    }
}

