/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.command.internal.env.ui.widgets;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.wst.command.internal.env.ui.widgets.PageInfo;
import org.eclipse.wst.command.internal.env.ui.widgets.PageWizardDataEvents;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;
import org.eclipse.wst.command.internal.env.ui.widgets.WizardPageManager;

public class SimpleWizardPage
extends WizardPage
implements PageWizardDataEvents {
    private WidgetContributor widget_;
    private WidgetDataEvents dataEvents_;
    private Listener statusListener_;
    protected WizardPageManager pageManager_;

    public SimpleWizardPage(PageInfo pageInfo, WizardPageManager pageManager) {
        super("");
        this.setTitle(pageInfo.getPageName());
        this.setDescription(pageInfo.getPageTitle());
        this.widget_ = pageInfo.getWidgetFactory().create();
        this.statusListener_ = new StatusListener();
        this.pageManager_ = pageManager;
    }

    public void createControl(Composite parent) {
        ScrolledComposite control = new ScrolledComposite(parent, 512);
        Composite inner = this.internalCreateControl((Composite)control);
        control.setExpandHorizontal(true);
        control.setExpandVertical(true);
        control.setContent((Control)inner);
        control.setMinSize(inner.computeSize(-1, -1));
        Dialog.applyDialogFont((Control)control);
        this.setControl((Control)control);
    }

    protected Composite internalCreateControl(Composite parent) {
        Composite control = new Composite(parent, 0);
        control.setLayout((Layout)new GridLayout());
        control.setLayoutData((Object)new GridData(1808));
        this.dataEvents_ = this.widget_.addControls(control, this.statusListener_);
        return control;
    }

    @Override
    public WidgetDataEvents getDataEvents() {
        return this.dataEvents_;
    }

    @Override
    public void validatePageToStatus() {
        IStatus status = this.widget_.getStatus();
        if (status != null) {
            if (status.getSeverity() == 4) {
                String message = status.getMessage();
                if (message.length() == 0) {
                    this.setErrorMessage(null);
                    this.setMessage(this.getDescription());
                } else {
                    this.setErrorMessage(message);
                }
                this.setPageComplete(false);
            } else if (status.getSeverity() == 2) {
                this.setErrorMessage(null);
                this.setMessage(status.getMessage(), 2);
                this.setPageComplete(true);
            } else if (status.getSeverity() == 1) {
                this.setErrorMessage(null);
                this.setMessage(status.getMessage(), 1);
                this.setPageComplete(true);
            } else {
                this.setErrorMessage(null);
                this.setMessage(this.getDescription());
                this.setPageComplete(true);
            }
        } else {
            this.setErrorMessage(null);
            this.setMessage(this.getDescription());
            this.setPageComplete(true);
        }
        this.getContainer().updateButtons();
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete() && this.pageManager_.hasNextPage();
    }

    public IWizardPage getNextPage() {
        return this.pageManager_.getNextPage();
    }

    public void setVisible(boolean value) {
        this.pageManager_.handlePageVisible(this, value);
        super.setVisible(value);
    }

    private class StatusListener
    implements Listener {
        private StatusListener() {
        }

        public void handleEvent(Event evt) {
            SimpleWizardPage.this.validatePageToStatus();
        }
    }
}

