/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.ui.dialogs.color;

import org.eclipse.swt.graphics.RGB;

public final class ColorInfo {
    public final String m_name;
    public final String m_description;
    public final RGB m_rgb;
    public final float m_hue;
    public final float m_saturation;
    public final float m_lightness;
    private Object m_data;
    private Object m_toolkitColor;

    public ColorInfo(int red, int green, int blue) {
        this(null, null, new RGB(red, green, blue));
    }

    public ColorInfo(String name, int red, int green, int blue) {
        this(name, null, new RGB(red, green, blue));
    }

    public ColorInfo(String name, RGB rgb) {
        this(name, null, rgb);
    }

    public ColorInfo(String name, String description, RGB rgb) {
        this.m_name = name;
        this.m_description = description;
        this.m_rgb = rgb;
        float[] hsl = ColorInfo.RGB_to_HSL(this.m_rgb.red, this.m_rgb.green, this.m_rgb.blue);
        this.m_hue = hsl[0];
        this.m_saturation = hsl[1];
        this.m_lightness = hsl[2];
    }

    public String getName() {
        if (this.m_name != null) {
            return this.m_name;
        }
        return "";
    }

    public String getTitle() {
        Object title = "";
        if (this.m_name != null) {
            title = (String)title + this.m_name + " ";
        }
        if (this.m_rgb != null) {
            title = (String)title + "#" + this.getHexRGB();
            title = (String)title + " H:" + (int)(this.m_hue * 360.0f) + "deg";
            title = (String)title + " S:" + (int)(this.m_saturation * 100.0f) + "%";
            title = (String)title + " L:" + (int)(this.m_lightness * 100.0f) + "%";
        }
        return title;
    }

    public RGB getRGB() {
        return this.m_rgb;
    }

    public String getHexRGB() {
        return ColorInfo.getHexPartRGB(this.m_rgb.red) + ColorInfo.getHexPartRGB(this.m_rgb.green) + ColorInfo.getHexPartRGB(this.m_rgb.blue);
    }

    public String getCommaRGB() {
        return this.m_rgb.red + ", " + this.m_rgb.green + ", " + this.m_rgb.blue;
    }

    private static String getHexPartRGB(int value) {
        Object result = Integer.toHexString(value);
        if (((String)result).length() < 2) {
            result = "0" + value;
        }
        return result;
    }

    public Object getData() {
        return this.m_data;
    }

    public void setData(Object data) {
        this.m_data = data;
    }

    public Object getToolkitColor() {
        return this.m_toolkitColor;
    }

    public void setToolkitColor(Object toolkitColor) {
        this.m_toolkitColor = toolkitColor;
    }

    private static float[] RGB_to_HSL(int r, int g, int b) {
        float hue = 0.0f;
        float saturation = 0.0f;
        float lightness = 0.0f;
        float r_color = (float)r / 255.0f;
        float g_color = (float)g / 255.0f;
        float b_color = (float)b / 255.0f;
        float min_color = Math.min(Math.min(r_color, g_color), b_color);
        float max_color = Math.max(Math.max(r_color, g_color), b_color);
        lightness = (max_color + min_color) / 2.0f;
        float dist_color = max_color - min_color;
        if (dist_color == 0.0f) {
            hue = 0.0f;
            saturation = 0.0f;
        } else {
            saturation = lightness < 0.5f ? dist_color / (max_color + min_color) : dist_color / (2.0f - max_color - min_color);
            if (ColorInfo.equals(r_color, max_color)) {
                hue = (g_color - b_color) / dist_color;
            } else if (ColorInfo.equals(g_color, max_color)) {
                hue = 2.0f + (b_color - r_color) / dist_color;
            } else if (ColorInfo.equals(b_color, max_color)) {
                hue = 4.0f + (r_color - g_color) / dist_color;
            }
            if (hue < 0.0f) {
                hue += 1.0f;
            }
            hue /= 6.0f;
        }
        return new float[]{hue, saturation, lightness};
    }

    private static boolean equals(float a, float b) {
        return (double)Math.abs(a - b) < 1.0E-5;
    }
}

