/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtbot.generator.ui.launcher;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swtbot.generator.ui.Messages;
import org.eclipse.swtbot.generator.ui.StartupRecorder;
import org.eclipse.swtbot.generator.ui.launcher.TestRecorderLaunchConfiguration;
import org.eclipse.swtbot.generator.ui.launcher.TestRecorderWizardPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class TestRecorderWizard
extends Wizard
implements INewWizard {
    private TestRecorderWizardPage firstPage;

    public void addPages() {
        this.setWindowTitle(Messages.recorderDialogTitle);
        this.firstPage = new TestRecorderWizardPage();
        this.addPage((IWizardPage)this.firstPage);
    }

    public boolean performFinish() {
        if (this.firstPage.runNewInstance()) {
            ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfigurationType type = manager.getLaunchConfigurationType(TestRecorderLaunchConfiguration.class.getName());
            try {
                ILaunchConfiguration[] lcs = manager.getLaunchConfigurations(type);
                ILaunchConfigurationWorkingCopy workingCopy = null;
                int i = 0;
                while (i < lcs.length) {
                    if (lcs[i].getName().equals("Test Recorder " + this.firstPage.getSelectedDialogName())) {
                        workingCopy = lcs[i].getWorkingCopy();
                        break;
                    }
                    ++i;
                }
                if (workingCopy == null) {
                    workingCopy = type.newInstance(null, "Test Recorder " + this.firstPage.getSelectedDialogName());
                    String recorderDialog = " -Dorg.eclipse.swtbot.generator.dialog=" + this.firstPage.getSelectedDialogId();
                    workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, recorderDialog);
                }
                final ILaunchConfiguration config = workingCopy.doSave();
                Display.getCurrent().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        DebugUITools.openLaunchConfigurationDialog((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (ILaunchConfiguration)config, (String)"org.eclipse.debug.ui.launchGroup.run", null);
                    }
                });
            }
            catch (CoreException ex) {
                ex.printStackTrace();
            }
        } else {
            StartupRecorder.openRecorder((String)this.firstPage.getSelectedDialogId());
        }
        return true;
    }

    public void init(IWorkbench arg0, IStructuredSelection arg1) {
    }
}

